/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers.utils;

import com.android.tools.r8.InputDependencyGraphConsumer;
import com.android.tools.r8.origin.Origin;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DepsFileWriter
implements InputDependencyGraphConsumer {
    private final Path dependentFile;
    private final String dependencyOutput;
    private final Set<Path> dependencies = new HashSet<Path>();

    public DepsFileWriter(Path dependentFile, String dependencyOutput) {
        this.dependentFile = dependentFile;
        this.dependencyOutput = dependencyOutput;
    }

    @Override
    public void accept(Origin dependent, Path dependency) {
        this.dependencies.add(dependency);
    }

    @Override
    public void finished() {
        ArrayList<Path> sorted = new ArrayList<Path>(this.dependencies);
        sorted.sort(Path::compareTo);
        Path output = Paths.get(this.dependencyOutput, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(DepsFileWriter.escape(this.dependentFile.toString()));
            writer.write(":");
            for (Path path : sorted) {
                writer.write(" ");
                writer.write(DepsFileWriter.escape(path.toString()));
            }
            writer.write("\n");
        }
        catch (IOException e15) {
            throw new RuntimeException(e15);
        }
    }

    private static String escape(String filepath) {
        return filepath.replace(" ", "\\ ");
    }
}

