/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import org.conscrypt.ArrayUtils;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLX25519Key;
import org.conscrypt.OpenSSLX509CertificateFactory;

public class OpenSSLX25519PrivateKey
implements OpenSSLX25519Key,
PrivateKey {
    private static final long serialVersionUID = -3136201500221850916L;
    private static final byte[] PKCS8_PREAMBLE = new byte[]{48, 46, 2, 1, 0, 48, 5, 6, 3, 43, 101, 110, 4, 34, 4, 32};
    private byte[] uCoordinate;

    public OpenSSLX25519PrivateKey(EncodedKeySpec keySpec) throws InvalidKeySpecException {
        byte[] encoded = keySpec.getEncoded();
        if ("PKCS#8".equals(keySpec.getFormat())) {
            try {
                this.uCoordinate = NativeCrypto.EVP_raw_X25519_private_key(encoded);
            }
            catch (InvalidKeyException | OpenSSLX509CertificateFactory.ParsingException e) {
                throw new InvalidKeySpecException(e);
            }
        } else if ("raw".equalsIgnoreCase(keySpec.getFormat())) {
            this.uCoordinate = encoded;
        } else {
            throw new InvalidKeySpecException("Encoding must be in PKCS#8 or raw format");
        }
        if (this.uCoordinate.length != 32) {
            throw new InvalidKeySpecException("Invalid key size");
        }
    }

    public OpenSSLX25519PrivateKey(byte[] coordinateBytes) {
        if (coordinateBytes.length != 32) {
            throw new IllegalArgumentException("Invalid key size");
        }
        this.uCoordinate = (byte[])coordinateBytes.clone();
    }

    @Override
    public String getAlgorithm() {
        return "XDH";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return ArrayUtils.concat(PKCS8_PREAMBLE, this.uCoordinate);
    }

    @Override
    public byte[] getU() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return (byte[])this.uCoordinate.clone();
    }

    @Override
    public void destroy() {
        if (this.uCoordinate != null) {
            Arrays.fill(this.uCoordinate, (byte)0);
            this.uCoordinate = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.uCoordinate == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSSLX25519PrivateKey)) {
            return false;
        }
        OpenSSLX25519PrivateKey that = (OpenSSLX25519PrivateKey)o;
        return Arrays.equals(this.uCoordinate, that.uCoordinate);
    }

    public int hashCode() {
        return Arrays.hashCode(this.uCoordinate);
    }
}

