/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class GraphPlotter
implements Cloneable {
    private Map<String, Point> nodes = new HashMap<String, Point>();
    private final Set<String> edges = new HashSet<String>();
    private double leftmost = 1.0;
    private double rightmost = -1.0;
    private double topmost = -1.0;
    private double bottommost = 1.0;

    public Object clone() {
        GraphPlotter g = new GraphPlotter();
        g.nodes.putAll(this.nodes);
        g.edges.addAll(this.edges);
        g.leftmost = this.leftmost;
        g.rightmost = this.rightmost;
        g.topmost = this.topmost;
        g.bottommost = this.bottommost;
        return g;
    }

    public static void force(Point calcPoint, Point currentPoint, Point otherPoint, Ribbon r) {
        double d;
        double dy = otherPoint.y - currentPoint.y;
        double dx = otherPoint.x - currentPoint.x;
        double a = Math.atan(dy / dx);
        if (a < 0.0) {
            a += Math.PI * 2;
        }
        boolean attraction = (d = Math.sqrt(dx * dx + dy * dy)) > r.length;
        double f = attraction ? r.attraction * (d - r.length) * (d - r.length) : -r.repulsion * (r.length - d) * (r.length - d);
        double x1 = Math.cos(a) * f;
        double y1 = Math.sin(a) * f;
        assert (!attraction || !(a < Math.PI) || y1 >= 0.0) : "attraction = " + attraction + ", a = " + a + ", y1 = " + y1;
        assert (attraction || !(a < Math.PI) || y1 <= 0.0) : "attraction = " + attraction + ", a = " + a + ", y1 = " + y1;
        assert (!attraction || !(a > Math.PI) || y1 <= 0.0) : "attraction = " + attraction + ", a = " + a + ", y1 = " + y1;
        assert (attraction || !(a > Math.PI) || y1 >= 0.0) : "attraction = " + attraction + ", a = " + a + ", y1 = " + y1;
        assert (!attraction || !(a < 1.5707963267948966) && !(a > 4.71238898038469) || x1 >= 0.0) : "attraction = " + attraction + ", a = " + a + ", x1 = " + x1;
        assert (attraction || !(a < 1.5707963267948966) && !(a > 4.71238898038469) || x1 <= 0.0) : "attraction = " + attraction + ", a = " + a + ", x1 = " + x1;
        assert (!attraction || a < 1.5707963267948966 || a > 4.71238898038469 || x1 <= 0.0) : "attraction = " + attraction + ", a = " + a + ", x1 = " + x1;
        assert (attraction || a < 1.5707963267948966 || a > 4.71238898038469 || x1 >= 0.0) : "attraction = " + attraction + ", a = " + a + ", x1 = " + x1;
        calcPoint.x += x1;
        calcPoint.y += y1;
    }

    public GraphPlotter physics(Ribbon all2, Ribbon edges) {
        GraphPlotter g = new GraphPlotter();
        for (Map.Entry<String, Point> node : this.nodes.entrySet()) {
            Point calc = (Point)node.getValue().clone();
            Point current = (Point)node.getValue().clone();
            for (Map.Entry<String, Point> p : this.nodes.entrySet()) {
                if (node.getKey().equals(p.getKey())) continue;
                GraphPlotter.force(calc, current, p.getValue(), all2);
            }
            for (String e : this.getEdges(node.getKey(), true)) {
                GraphPlotter.force(calc, current, this.getNode(e), edges);
            }
            for (String e : this.getEdges(node.getKey(), false)) {
                GraphPlotter.force(calc, current, this.getNode(e), edges);
            }
            g.addNode(node.getKey(), calc);
        }
        g.edges.addAll(this.edges);
        return g;
    }

    public Point getNode(String node) {
        return this.nodes.get(node);
    }

    private Point[] getEdge(String edge) {
        int p = edge.indexOf(36, 0);
        if (p < 0) {
            return null;
        }
        Point from = this.getNode(edge.substring(0, p));
        Point to = this.getNode(edge.substring(p + 1));
        if (from == null || to == null) {
            return null;
        }
        return new Point[]{from, to};
    }

    private String getLeftmost() {
        if (this.nodes.size() == 0) {
            return null;
        }
        String ns = "";
        double ps = Double.MAX_VALUE;
        for (Map.Entry<String, Point> node : this.nodes.entrySet()) {
            if (!(node.getValue().x < ps)) continue;
            ns = node.getKey();
            ps = node.getValue().x;
        }
        assert (ns != null);
        return ns;
    }

    private String getBottommost() {
        if (this.nodes.size() == 0) {
            return null;
        }
        String ns = "";
        double ps = Double.MAX_VALUE;
        for (Map.Entry<String, Point> node : this.nodes.entrySet()) {
            if (!(node.getValue().y < ps)) continue;
            ns = node.getKey();
            ps = node.getValue().y;
        }
        assert (ns != null);
        return ns;
    }

    public int normalizeVertical() {
        HashMap<String, Point> nc = new HashMap<String, Point>();
        int d = 0;
        while (this.nodes.size() > 0) {
            String n = this.getBottommost();
            Point p = this.nodes.remove(n);
            p.y = d++;
            nc.put(n, p);
        }
        this.nodes = nc;
        this.bottommost = 0.0;
        this.topmost = d - 1;
        return d;
    }

    public int normalizeHorizontal() {
        Point p;
        ArrayList<AbstractMap.SimpleEntry<String, Point>> l = new ArrayList<AbstractMap.SimpleEntry<String, Point>>();
        int d = 0;
        while (this.nodes.size() > 0) {
            String n = this.getLeftmost();
            p = this.nodes.remove(n);
            p.x = d++;
            l.add(new AbstractMap.SimpleEntry<String, Point>(n, p));
        }
        for (int i = 0; i < l.size() / 5; ++i) {
            p = (Point)((Map.Entry)l.get(i)).getValue();
            p.x += (double)(3 * ((String)((Map.Entry)l.get(i)).getKey()).length() / 2);
            this.rightmost = Math.max(p.x, this.rightmost);
            p = (Point)((Map.Entry)l.get(l.size() - i - 1)).getValue();
            p.x -= (double)(3 * ((String)((Map.Entry)l.get(i)).getKey()).length() / 2);
            this.leftmost = Math.min(p.x, this.leftmost);
        }
        this.leftmost = Double.MAX_VALUE;
        this.rightmost = Double.MIN_VALUE;
        HashMap<String, Point> nc = new HashMap<String, Point>();
        for (Map.Entry entry2 : l) {
            p = (Point)entry2.getValue();
            nc.put((String)entry2.getKey(), p);
            if (p.x - (double)((String)entry2.getKey()).length() < this.leftmost) {
                this.leftmost = p.x - (double)((String)entry2.getKey()).length();
            }
            if (!(p.x + (double)((String)entry2.getKey()).length() > this.rightmost)) continue;
            this.rightmost = p.x + (double)((String)entry2.getKey()).length();
        }
        this.nodes = nc;
        return d;
    }

    public void normalize() {
        this.normalizeVertical();
        this.normalizeHorizontal();
    }

    public void addNode(String node, Point p) {
        Point op = this.nodes.get(node);
        if (op == null) {
            this.nodes.put(node, p);
        } else {
            op.layer = Math.min(op.layer, p.layer);
        }
        if (p.x > this.rightmost) {
            this.rightmost = p.x;
        }
        if (p.x < this.leftmost) {
            this.leftmost = p.x;
        }
        if (p.y > this.topmost) {
            this.topmost = p.y;
        }
        if (p.y < this.bottommost) {
            this.bottommost = p.y;
        }
    }

    public void addNode(String node, double x, double y, int layer) {
        this.addNode(node, new Point(x, y, layer));
    }

    public boolean hasEdge(String fromNode, String toNode) {
        return this.edges.contains(fromNode + "-" + toNode);
    }

    public void setEdge(String fromNode, String toNode) {
        Point from = this.nodes.get(fromNode);
        Point to = this.nodes.get(toNode);
        assert (from != null);
        assert (to != null);
        this.edges.add(fromNode + "$" + toNode);
    }

    public Collection<String> getEdges(String node, boolean start) {
        ArrayList<String> c = new ArrayList<String>();
        if (start) {
            String s = node + "$";
            for (String e : this.edges) {
                if (!e.startsWith(s)) continue;
                c.add(e.substring(s.length()));
            }
        } else {
            String s = "$" + node;
            for (String e : this.edges) {
                if (!e.endsWith(s)) continue;
                c.add(e.substring(0, e.length() - s.length()));
            }
        }
        return c;
    }

    public void print() {
        for (Map.Entry<String, Point> entry2 : this.nodes.entrySet()) {
            String name = entry2.getKey();
            Point c = entry2.getValue();
            System.out.println("point(" + c.x + ", " + c.y + ", " + c.layer + ") [" + name + "]");
        }
        Iterator<String> j = this.edges.iterator();
        while (j.hasNext()) {
            System.out.println("border(" + j.next() + ")");
        }
    }

    public RasterPlotter draw(int width, int height, int leftborder, int rightborder, int topborder, int bottomborder, int xraster, int yraster, String color_back, String color_dot0, String color_dota, String color_line, String color_lineend, String color_text) {
        RasterPlotter.DrawMode drawMode = RasterPlotter.darkColor(color_back) ? RasterPlotter.DrawMode.MODE_ADD : RasterPlotter.DrawMode.MODE_SUB;
        RasterPlotter image = new RasterPlotter(width, height, drawMode, color_back);
        double xfactor = this.rightmost - this.leftmost == 0.0 ? 0.0 : (double)(width - leftborder - rightborder) / (this.rightmost - this.leftmost);
        double yfactor = this.topmost - this.bottommost == 0.0 ? 0.0 : (double)(height - topborder - bottomborder) / (this.topmost - this.bottommost);
        Iterator<Map.Entry<String, Point>> i = this.nodes.entrySet().iterator();
        Long color_dot0_l = Long.parseLong(color_dot0, 16);
        Long color_dota_l = Long.parseLong(color_dota, 16);
        Long color_line_l = Long.parseLong(color_line, 16);
        Long color_lineend_l = Long.parseLong(color_lineend, 16);
        Long color_text_l = Long.parseLong(color_text, 16);
        while (i.hasNext()) {
            Map.Entry<String, Point> entry2 = i.next();
            String name = entry2.getKey();
            Point c = entry2.getValue();
            int x = xfactor == 0.0 ? this.raster(width / 2, xraster) : leftborder + this.raster((c.x - this.leftmost) * xfactor, xraster);
            int y = yfactor == 0.0 ? this.raster(height / 2, yraster) : height - bottomborder - this.raster((c.y - this.bottommost) * yfactor, yraster);
            image.setColor(c.layer == 0 ? color_dot0_l : color_dota_l);
            image.dot(x, y, 6, true, 100);
            image.setColor(color_text_l);
            PrintTool.print5(image, x, y + 10, 0, name.toUpperCase(), 0, 100);
        }
        Iterator<String> j = this.edges.iterator();
        image.setColor(color_line_l);
        while (j.hasNext()) {
            int y1;
            int y0;
            int x1;
            int x0;
            Point[] border = this.getEdge(j.next());
            if (border == null) continue;
            if (xfactor == 0.0) {
                x0 = this.raster(width / 2, xraster);
                x1 = this.raster(width / 2, xraster);
            } else {
                x0 = leftborder + this.raster((border[0].x - this.leftmost) * xfactor, xraster);
                x1 = leftborder + this.raster((border[1].x - this.leftmost) * xfactor, xraster);
            }
            if (yfactor == 0.0) {
                y0 = this.raster(height / 2, yraster);
                y1 = this.raster(height / 2, yraster);
            } else {
                y0 = height - bottomborder - this.raster((border[0].y - this.bottommost) * yfactor, yraster);
                y1 = height - bottomborder - this.raster((border[1].y - this.bottommost) * yfactor, yraster);
            }
            image.lineArrow(x0, y0, x1, y1, 6, 5, color_line_l, color_lineend_l);
        }
        return image;
    }

    private int raster(double pos, int raster) {
        if (raster <= 1) {
            return (int)pos;
        }
        return (int)(pos / (double)raster) * raster;
    }

    public static class Point
    implements Cloneable {
        public double x;
        public double y;
        public int layer;

        public Point(double x, double y, int layer) {
            this.x = x;
            this.y = y;
            this.layer = layer;
        }

        public Object clone() {
            return new Point(this.x, this.y, this.layer);
        }
    }

    public static class Ribbon {
        double length;
        double attraction;
        double repulsion;

        public Ribbon(double length, double attraction, double repulsion) {
            this.length = length;
            this.attraction = attraction;
            this.repulsion = repulsion;
        }
    }
}

