/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;

public class PKCS12Tool {
    private final KeyStore kspkcs12;
    private final String kspkcs12Pass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS12Tool(String pkcs12FileName, String pkcs12Pwd) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        if (pkcs12FileName == null) {
            throw new NullPointerException();
        }
        this.kspkcs12Pass = pkcs12Pwd;
        this.kspkcs12 = KeyStore.getInstance("PKCS12");
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(pkcs12FileName);
            this.kspkcs12.load(fileIn, pkcs12Pwd != null ? pkcs12Pwd.toCharArray() : null);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ioe) {
                    System.err.println("Could not close file " + pkcs12FileName);
                }
            }
        }
    }

    public Enumeration<String> aliases() throws KeyStoreException {
        return this.kspkcs12.aliases();
    }

    public void printAliases() throws KeyStoreException {
        Enumeration<String> aliases = this.aliases();
        while (aliases.hasMoreElements()) {
            System.out.println(aliases.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importToJKS(String jksName, String jksPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore jks = KeyStore.getInstance("JKS");
        FileInputStream jksFileIn = null;
        File jksFile = new File(jksName);
        if (jksFile.exists()) {
            System.err.println("Loading java keystore from file '" + String.valueOf(jksFile) + "'");
            jksFileIn = new FileInputStream(jksFile);
        } else {
            System.err.println("Creating new java keystore '" + String.valueOf(jksFile) + "'");
        }
        try {
            jks.load(jksFileIn, jksPassword != null ? jksPassword.toCharArray() : null);
        }
        finally {
            if (jksFileIn != null) {
                try {
                    jksFileIn.close();
                }
                catch (IOException ioe) {
                    System.err.println("Error while closing input stream on file " + String.valueOf(jksFile));
                }
            }
        }
        Enumeration<String> pkcs12Aliases = this.aliases();
        while (pkcs12Aliases.hasMoreElements()) {
            String strAlias = pkcs12Aliases.nextElement();
            System.err.println("Importing Alias '" + strAlias + "'");
            if (!this.kspkcs12.isKeyEntry(strAlias)) continue;
            System.err.println("- Alias has key");
            Key key = this.kspkcs12.getKey(strAlias, this.kspkcs12Pass != null ? this.kspkcs12Pass.toCharArray() : null);
            System.err.println("- Alias key imported");
            Certificate[] chain = this.kspkcs12.getCertificateChain(strAlias);
            System.err.println("- Alias certificate chain size: " + chain.length);
            jks.setKeyEntry(strAlias, key, jksPassword != null ? jksPassword.toCharArray() : null, chain);
        }
        System.err.print("Storing java keystore");
        FileOutputStream jksFileOut = null;
        try {
            jksFileOut = new FileOutputStream(jksName);
            jks.store(jksFileOut, jksPassword != null ? jksPassword.toCharArray() : null);
        }
        finally {
            if (jksFileOut != null) {
                try {
                    jksFileOut.close();
                }
                catch (IOException ioe) {
                    System.err.println("Could not close file " + String.valueOf(jksFileOut));
                }
            }
        }
        System.err.print("Import finished.");
    }

    public static void main(String[] args) throws Exception {
        PKCS12Tool pkcs12 = new PKCS12Tool("c:/temp/keystore.pkcs12", "test");
        pkcs12.importToJKS("c:/temp/jks.ks", "test");
    }
}

