/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import net.yacy.cora.document.encoding.ASCII;

public class Bitfield {
    private byte[] bb;

    public Bitfield() {
        this(0);
    }

    public Bitfield(int bytelength) {
        this.bb = new byte[bytelength];
        for (int i = 0; i < bytelength; ++i) {
            this.bb[i] = 32;
        }
    }

    public Bitfield(byte[] field) {
        this.bb = field;
    }

    private static byte setAtom(byte a, int pos) {
        if (pos > 5 || pos < 0) {
            throw new RuntimeException("atom position out of bounds: " + pos);
        }
        byte b = (byte)((a - 32 | 1 << pos) + 32);
        return b;
    }

    private static byte unsetAtom(byte a, int pos) {
        if (pos > 5 || pos < 0) {
            throw new RuntimeException("atom position out of bounds: " + pos);
        }
        byte b = (byte)((a - 32 & (0xFF ^ 1 << pos)) + 32);
        return b;
    }

    public void set(int pos, boolean value) {
        int slot = pos / 5;
        if (pos < 0) {
            throw new RuntimeException("position out of bounds: " + pos);
        }
        if (slot > this.bb.length) {
            byte[] nb = new byte[slot + 1];
            System.arraycopy(this.bb, 0, nb, 0, this.bb.length);
            for (int i = this.bb.length; i < nb.length; ++i) {
                nb[i] = 0;
            }
            this.bb = nb;
        }
        this.bb[slot] = value ? Bitfield.setAtom(this.bb[slot], pos % 5) : Bitfield.unsetAtom(this.bb[slot], pos % 5);
    }

    public boolean get(int pos) {
        int slot = pos / 5;
        if (pos < 0) {
            throw new RuntimeException("position out of bounds: " + pos);
        }
        if (slot > this.bb.length) {
            return false;
        }
        boolean b = (this.bb[slot] - 32 & 1 << pos % 5) > 0;
        return b;
    }

    public int length() {
        return this.bb.length * 5;
    }

    public byte[] getBytes() {
        return this.bb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        for (int i = this.length() - 1; i >= 0; --i) {
            sb.append(this.get(i) ? (char)'1' : '0');
        }
        return ASCII.String(this.bb) + " " + sb.toString();
    }

    public static void main(String[] args) {
        int i;
        Bitfield f = new Bitfield(4);
        for (int i2 = 0; i2 < 20; ++i2) {
            f.set(i2, false);
            if (f.get(i2)) {
                System.out.println("i = " + i2);
            }
            f.set(i2, true);
            if (!f.get(i2)) {
                System.out.println("!i = " + i2);
            }
            System.out.println(i2 + ":" + f.toString());
        }
        Bitfield test2 = new Bitfield(4);
        int l = test2.length();
        System.out.println("available: " + l);
        System.out.println("before:    " + test2.toString());
        for (i = 0; i < l / 2; ++i) {
            test2.set(i, true);
            System.out.println(i + ":" + test2.toString());
        }
        for (i = l / 2 - 1; i >= 0; --i) {
            test2.set(i, false);
            System.out.println(i + ":" + test2.toString());
        }
        System.out.println("after:     " + test2.toString());
    }
}

