/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;
import net.yacy.server.http.TemplateEngine;
import net.yacy.server.serverObjects;

public final class HTTPDemon {
    private static final int ERRORCASE_MESSAGE = 4;
    private static final int ERRORCASE_FILE = 5;
    private static volatile Switchboard switchboard = Switchboard.getSwitchboard();

    static final void sendRespondError(HashMap<String, Object> conProp, OutputStream respond, int errorcase, int httpStatusCode, String httpStatusText, String detailedErrorMsg, Throwable stackTrace) throws IOException {
        HTTPDemon.sendRespondError(conProp, respond, errorcase, httpStatusCode, httpStatusText, detailedErrorMsg, null, null, stackTrace, null);
    }

    static final void sendRespondError(HashMap<String, Object> conProp, OutputStream respond, int httpStatusCode, String httpStatusText, File detailedErrorMsgFile, serverObjects detailedErrorMsgValues, Throwable stackTrace) throws IOException {
        HTTPDemon.sendRespondError(conProp, respond, 5, httpStatusCode, httpStatusText, null, detailedErrorMsgFile, detailedErrorMsgValues, stackTrace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendRespondError(HashMap<String, Object> conProp, OutputStream respond, int errorcase, int httpStatusCode, String httpStatusText, String detailedErrorMsgText, Object detailedErrorMsgFile, serverObjects detailedErrorMsgValues, Throwable stackTrace, ResponseHeader header) throws IOException {
        FileInputStream fis = null;
        ByteArrayOutputStream o = null;
        try {
            String httpVersion = (String)conProp.get("HTTP");
            if (httpVersion == null) {
                httpVersion = "HTTP/1.1";
            }
            if (httpStatusText == null || httpStatusText.length() == 0) {
                httpStatusText = HeaderFramework.http1_1.containsKey(Integer.toString(httpStatusCode)) ? HeaderFramework.http1_1.get(Integer.toString(httpStatusCode)) : "Unknown";
            }
            HttpServletRequest origrequest = (HttpServletRequest)conProp.get("CLIENT_HTTPSERVLETREQUEST");
            String method = origrequest.getMethod();
            DigestURL url = (DigestURL)conProp.get("URL");
            serverObjects tp = new serverObjects();
            tp.put("peerName", HTTPDemon.switchboard.peers == null ? "" : HTTPDemon.switchboard.peers.myName());
            tp.put("errorMessageType", Integer.toString(errorcase));
            tp.put("httpStatus", Integer.toString(httpStatusCode) + " " + httpStatusText);
            tp.put("requestMethod", method);
            tp.put("requestURL", url.toString());
            switch (errorcase) {
                case 5: {
                    tp.put("errorMessageType_file", detailedErrorMsgFile == null ? "" : detailedErrorMsgFile.toString());
                    if (detailedErrorMsgValues == null || detailedErrorMsgValues.isEmpty()) break;
                    for (Map.Entry<String, String> entry2 : detailedErrorMsgValues.entrySet()) {
                        tp.put("errorMessageType_" + entry2.getKey(), entry2.getValue());
                    }
                    break;
                }
                default: {
                    tp.put("errorMessageType_detailedErrorMsg", detailedErrorMsgText == null ? "" : detailedErrorMsgText.replaceAll("\n", "<br />"));
                }
            }
            if (stackTrace != null) {
                tp.put("printStackTrace", "1");
                ByteBuffer errorMsg = new ByteBuffer(100);
                PrintStream printStream = new PrintStream(errorMsg);
                stackTrace.printStackTrace(printStream);
                tp.put("printStackTrace_exception", stackTrace.toString());
                tp.put("printStackTrace_stacktrace", UTF8.String(errorMsg.getBytes()));
                printStream.close();
            } else {
                tp.put("printStackTrace", "0");
            }
            String systemDate = HeaderFramework.formatRFC1123(new Date());
            tp.put("date", systemDate);
            File htRootPath = new File(switchboard.getAppPath(), switchboard.getConfig("htRootPath", "htroot"));
            fis = new FileInputStream(new File(htRootPath, "/proxymsg/error.html"));
            o = new ByteArrayOutputStream(512);
            TemplateEngine.writeTemplate("/proxymsg/error.html", fis, o, tp);
            byte[] result = o.toByteArray();
            o.close();
            o = null;
            if (header == null) {
                header = new ResponseHeader(httpStatusCode);
            }
            header.put("PROXY_RESPOND_STATUS", Integer.toString(httpStatusCode));
            header.put("Date", systemDate);
            header.put("Content-Type", "text/html");
            header.put("Content-Length", Integer.toString(result.length));
            header.put("Pragma", "no-cache, no-store");
            HTTPDemon.sendRespondHeader(conProp, respond, httpVersion, httpStatusCode, httpStatusText, header);
            if (!method.equals("HEAD")) {
                FileUtils.copy(result, respond);
            }
            respond.flush();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
            if (o != null) {
                try {
                    o.close();
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
    }

    static final void sendRespondHeader(HashMap<String, Object> conProp, OutputStream respond, String httpVersion, int httpStatusCode, String httpStatusText, ResponseHeader responseHeader) throws IOException {
        if (respond == null) {
            throw new NullPointerException("The outputstream must not be null.");
        }
        if (conProp == null) {
            throw new NullPointerException("The connection property structure must not be null.");
        }
        if (httpVersion == null) {
            httpVersion = (String)conProp.get("HTTP");
        }
        if (httpVersion == null) {
            httpVersion = "HTTP/1.1";
        }
        if (responseHeader == null) {
            responseHeader = new ResponseHeader(httpStatusCode);
        }
        try {
            if (httpStatusText == null || httpStatusText.length() == 0) {
                httpStatusText = HeaderFramework.http1_1.containsKey(Integer.toString(httpStatusCode)) ? HeaderFramework.http1_1.get(Integer.toString(httpStatusCode)) : "Unknown";
            }
            StringBuilder header = new StringBuilder(560);
            if (!httpVersion.toUpperCase().equals("HTTP/0.9")) {
                header.append(httpVersion).append(" ").append(Integer.toString(httpStatusCode)).append(" ").append(httpStatusText).append("\r\n");
                if (!responseHeader.containsKey("Date")) {
                    responseHeader.put("Date", HeaderFramework.formatRFC1123(new Date()));
                }
                if (!responseHeader.containsKey("Content-Type")) {
                    responseHeader.put("Content-Type", "text/html; charset=UTF-8");
                }
                if (!responseHeader.containsKey("Connection") && conProp.containsKey("PERSISTENT")) {
                    responseHeader.put("Connection", (String)conProp.get("PERSISTENT"));
                }
                if (!responseHeader.containsKey("Proxy-Connection") && conProp.containsKey("PERSISTENT")) {
                    responseHeader.put("Proxy-Connection", (String)conProp.get("PERSISTENT"));
                }
                if (conProp.containsKey("PERSISTENT") && conProp.get("PERSISTENT").equals("keep-alive") && !responseHeader.containsKey("Transfer-Encoding") && !responseHeader.containsKey("Content-Length")) {
                    responseHeader.put("Content-Length", "0");
                }
                if (responseHeader.getCookiesEntries() != null) {
                    for (Cookie c : responseHeader.getCookiesEntries()) {
                        header.append("Set-Cookie: " + c.getName()).append("=").append(c.getValue()).append(";\r\n");
                    }
                }
                for (String key : responseHeader.keySet()) {
                    char tag = key.charAt(0);
                    if (tag == '*' || tag == '#') continue;
                    int count = responseHeader.keyCount(key);
                    for (int j = 0; j < count; ++j) {
                        header.append(key).append(": ").append(responseHeader.getSingle(key, j)).append("\r\n");
                    }
                }
                header.append("\r\n");
                respond.write(UTF8.getBytes(header.toString()));
                respond.flush();
            }
            conProp.put("PROXY_RESPOND_HEADER", responseHeader);
            conProp.put("PROXY_RESPOND_STATUS", Integer.toString(httpStatusCode));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

