/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server.http;

import java.io.File;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.server.serverSwitch;

public final class HTTPDFileHandler {
    private static serverSwitch switchboard = null;
    public static File htDocsPath = null;
    public static String[] defaultFiles = null;
    private static File htDefaultPath = null;
    private static File htLocalePath = null;
    public static String indexForward = "";

    public static final void initDefaultPath() {
        defaultFiles = switchboard.getConfigArray("defaultFiles", "index.html");
        if (defaultFiles.length == 0) {
            defaultFiles = new String[]{"index.html"};
        }
        if ((indexForward = switchboard.getConfig("indexForward", "")).startsWith("/")) {
            indexForward = indexForward.substring(1);
        }
    }

    public static File getLocalizedFile(String path, String clientLang) {
        File localePath;
        String localeSelection = switchboard.getConfig("locale.language", "browser");
        if (!localeSelection.equals("default") && (localeSelection.equals("browser") ? clientLang != null && !clientLang.isEmpty() && (localePath = new File(htLocalePath, clientLang + "/" + path)).exists() : (localePath = new File(htLocalePath, localeSelection + "/" + path)).exists())) {
            return localePath;
        }
        File docsPath = new File(htDocsPath, path);
        if (docsPath.exists()) {
            return docsPath;
        }
        return new File(htDefaultPath, path);
    }

    public static final File getOverlayedFile(String path) {
        File targetFile = HTTPDFileHandler.getLocalizedFile(path, null);
        if (!targetFile.exists()) {
            targetFile = new File(htDocsPath, path);
        }
        return targetFile;
    }

    static {
        Switchboard theSwitchboard = Switchboard.getSwitchboard();
        if (switchboard == null) {
            switchboard = theSwitchboard;
            if (Classification.countMimes() == 0) {
                String mimeTablePath = theSwitchboard.getConfig("mimeTable", "");
                ConcurrentLog.config("HTTPDFiles", "Loading mime mapping file " + mimeTablePath);
                Classification.init(new File(theSwitchboard.getAppPath(), mimeTablePath));
            }
            HTTPDFileHandler.initDefaultPath();
            if (htDocsPath == null && !(htDocsPath = theSwitchboard.getDataPath("htDocsPath", "DATA/HTDOCS")).exists()) {
                htDocsPath.mkdirs();
            }
            if (htDefaultPath == null) {
                htDefaultPath = theSwitchboard.getAppPath("htDefaultPath", "htroot");
            }
            if (htLocalePath == null) {
                htLocalePath = theSwitchboard.getDataPath("locale.translated_html", "DATA/LOCALE/htroot");
            }
        }
    }
}

