/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.query;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.responsewriter.OpensearchResponseWriter;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.sorting.ScoreMapUpdatesListener;
import net.yacy.cora.sorting.WeakPriorityBlockingQueue;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.WorkTables;
import net.yacy.document.LargeNumberCache;
import net.yacy.document.LibraryProvider;
import net.yacy.document.ProbabilisticClassifier;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceFactory;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.TermSearch;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.SetTools;
import net.yacy.peers.RemoteSearch;
import net.yacy.peers.SeedDB;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.repository.Blacklist;
import net.yacy.repository.LoaderDispatcher;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorPlugins;
import net.yacy.search.query.HeuristicResult;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.query.SearchEventType;
import net.yacy.search.query.SecondarySearchSuperviser;
import net.yacy.search.ranking.ReferenceOrder;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.snippet.TextSnippet;

public final class SearchEvent
implements ScoreMapUpdatesListener {
    private static final String PROTOCOL_NAVIGATOR_SUPPORTED_VALUES = "http,https,smb,ftp,file";
    private static final int max_results_rwi = 3000;
    private static final int max_results_node = 150;
    public static final ConcurrentLog log = new ConcurrentLog("SEARCH");
    public static final int SNIPPET_MAX_LENGTH = 220;
    private static final int MAX_TOPWORDS = 12;
    private long eventTime;
    public QueryParams query;
    public final SeedDB peers;
    final WorkTables workTables;
    public final SecondarySearchSuperviser secondarySearchSuperviser;
    public final List<RemoteSearch> primarySearchThreadsL;
    public final List<Thread> nodeSearchThreads;
    public Thread[] secondarySearchThreads;
    public final SortedSet<byte[]> preselectedPeerHashes;
    private final SortedMap<byte[], Integer> IACount;
    private final SortedMap<byte[], String> IAResults;
    private final SortedMap<byte[], HeuristicResult> heuristics;
    private byte[] IAmaxcounthash;
    private byte[] IAneardhthash;
    public Thread rwiProcess;
    public Thread localsolrsearch;
    private int localsolroffset;
    private final AtomicInteger expectedRemoteReferences;
    private final AtomicInteger maxExpectedRemoteReferences;
    public final ScoreMap<String> locationNavigator;
    public final ScoreMap<String> protocolNavigator;
    public final ConcurrentScoreMap<String> dateNavigator;
    public final Map<String, ScoreMap<String>> vocabularyNavigator;
    private final int topicNavigatorCount;
    public final Map<String, Navigator> navigatorPlugins;
    private final AtomicLong navGeneration = new AtomicLong();
    private final LoaderDispatcher loader;
    private final HandleSet snippetFetchWordHashes;
    private final Set<String> snippetFetchWords;
    private final boolean deleteIfSnippetFail;
    private final long urlRetrievalAllTime;
    private final long snippetComputationAllTime;
    private final ConcurrentHashMap<String, LinkedHashSet<String>> snippets;
    private final boolean remote;
    public final boolean addResultsToLocalIndex;
    private long remoteStoredDocMaxSize;
    private SortedMap<byte[], ReferenceContainer<WordReference>> localSearchInclusion;
    private final ScoreMap<String> ref;
    private final long maxtime;
    private final ConcurrentHashMap<String, WeakPriorityBlockingQueue<WordReferenceVars>> doubleDomCache;
    private final int[] flagcount;
    private final AtomicInteger feedersAlive;
    private final AtomicInteger feedersTerminated;
    private final AtomicInteger snippetFetchAlive;
    private boolean addRunning;
    private final AtomicInteger receivedRemoteReferences;
    private final ReferenceOrder order;
    private final HandleSet urlhashes;
    private final Map<String, String> taggingPredicates;
    private final WeakPriorityBlockingQueue<WordReferenceVars> rwiStack;
    private final WeakPriorityBlockingQueue<URIMetadataNode> nodeStack;
    private final WeakPriorityBlockingQueue<URIMetadataNode> resultList;
    private final boolean pollImmediately;
    public final boolean excludeintext_image;
    public final AtomicInteger local_rwi_available;
    public final AtomicInteger local_rwi_stored;
    public final AtomicInteger remote_rwi_available;
    public final AtomicInteger remote_rwi_stored;
    public final AtomicInteger remote_rwi_peerCount;
    public final AtomicInteger local_solr_evicted;
    public final AtomicInteger local_solr_stored;
    public final AtomicInteger remote_solr_available;
    public final AtomicInteger remote_solr_stored;
    public final AtomicInteger remote_solr_peerCount;
    public final Semaphore resortCacheAllowed;
    private int imagePageCounter = 0;
    private final LinkedHashMap<String, ImageResult> imageViewed = new LinkedHashMap();
    private final LinkedHashMap<String, ImageResult> imageSpareGood = new LinkedHashMap();
    private final LinkedHashMap<String, ImageResult> imageSpareBad = new LinkedHashMap();
    private static final Pattern lettermatch = Pattern.compile("[a-z]+");

    @Override
    public void updatedScoreMap() {
        this.navGeneration.incrementAndGet();
    }

    public int getResultCount() {
        return Math.max(this.local_rwi_available.get() + this.remote_rwi_available.get() + this.remote_solr_available.get() + Math.max(0, this.local_solr_stored.get() - this.local_solr_evicted.get()), this.imageViewed.size() + this.sizeSpare());
    }

    public long getNavGeneration() {
        return this.navGeneration.get();
    }

    public void setRemoteDocStoredMaxSize(long maxSize) {
        this.remoteStoredDocMaxSize = maxSize;
    }

    public long getRemoteDocStoredMaxSize() {
        return this.remoteStoredDocMaxSize;
    }

    protected SearchEvent(QueryParams query2, SeedDB peers, WorkTables workTables, final SortedSet<byte[]> preselectedPeerHashes, boolean generateAbstracts, LoaderDispatcher loader, final int remote_maxcount, final long remote_maxtime, boolean deleteIfSnippetFail, boolean addResultsToLocalIdx) {
        int en;
        int eb;
        long ab = MemoryControl.available();
        if (ab < 0xC800000L) {
            eb = SearchEventCache.size();
            SearchEventCache.cleanupEvents(false);
            en = SearchEventCache.size();
            if (en < eb) {
                log.info("Cleaned up search event cache (1) " + eb + "->" + en + ", " + (ab - MemoryControl.available()) / 1024L / 1024L + " MB freed");
            }
        }
        ab = MemoryControl.available();
        eb = SearchEventCache.size();
        SearchEventCache.cleanupEvents(Math.max(1, (int)(MemoryControl.available() / 0x7800000L)));
        en = SearchEventCache.size();
        if (en < eb) {
            log.info("Cleaned up search event cache (2) " + eb + "->" + en + ", " + (ab - MemoryControl.available()) / 1024L / 1024L + " MB freed");
        }
        this.eventTime = System.currentTimeMillis();
        this.peers = peers;
        this.workTables = workTables;
        this.query = query2;
        if (query2 != null) {
            this.imagePageCounter = query2.offset;
        }
        this.loader = loader;
        this.nodeStack = new WeakPriorityBlockingQueue(150, false);
        this.maxExpectedRemoteReferences = new AtomicInteger(0);
        this.expectedRemoteReferences = new AtomicInteger(0);
        this.excludeintext_image = Switchboard.getSwitchboard().getConfigBool("search.excludeintext.image", true);
        Set<String> navConfigs = Switchboard.getSwitchboard().getConfigSet("search.navigation");
        boolean locationNavEnabled = false;
        boolean protocolNavEnabled = false;
        boolean topicsNavEnabled = false;
        boolean dateNavEnabled = false;
        for (String navConfig : navConfigs) {
            String navName = NavigatorPlugins.getNavName(navConfig);
            if ("location".equals(navName)) {
                locationNavEnabled = true;
                continue;
            }
            if ("protocol".equals(navName)) {
                protocolNavEnabled = true;
                continue;
            }
            if ("topics".equals(navName)) {
                topicsNavEnabled = true;
                continue;
            }
            if (!"date".equals(navName)) continue;
            dateNavEnabled = true;
        }
        this.locationNavigator = locationNavEnabled ? new ConcurrentScoreMap(this) : null;
        this.protocolNavigator = protocolNavEnabled ? new ConcurrentScoreMap(this) : null;
        this.dateNavigator = dateNavEnabled ? new ConcurrentScoreMap(this) : null;
        this.topicNavigatorCount = topicsNavEnabled ? 12 : 0;
        this.vocabularyNavigator = new TreeMap<String, ScoreMap<String>>();
        this.navigatorPlugins = NavigatorPlugins.initFromCfgStrings(navConfigs);
        if (this.navigatorPlugins != null) {
            for (Navigator nav : this.navigatorPlugins.values()) {
                nav.setUpdatesListener(this);
            }
        }
        this.snippets = new ConcurrentHashMap();
        SecondarySearchSuperviser secondarySearchSuperviser = this.secondarySearchSuperviser = this.query.getQueryGoal().getIncludeHashes().size() > 1 ? new SecondarySearchSuperviser(this) : null;
        if (this.secondarySearchSuperviser != null) {
            this.secondarySearchSuperviser.start();
        }
        this.secondarySearchThreads = null;
        this.preselectedPeerHashes = preselectedPeerHashes;
        this.IAResults = new TreeMap<byte[], String>(Base64Order.enhancedCoder);
        this.IACount = new TreeMap<byte[], Integer>(Base64Order.enhancedCoder);
        this.heuristics = new TreeMap<byte[], HeuristicResult>(Base64Order.enhancedCoder);
        this.IAmaxcounthash = null;
        this.IAneardhthash = null;
        this.remote = peers != null && peers.sizeConnected() > 0 && (this.query.domType == QueryParams.Searchdom.CLUSTER || this.query.domType == QueryParams.Searchdom.GLOBAL && Switchboard.getSwitchboard().getConfigBool("allowReceiveIndex.search", false));
        this.addResultsToLocalIndex = addResultsToLocalIdx;
        this.remoteStoredDocMaxSize = -1L;
        this.local_rwi_available = new AtomicInteger(0);
        this.local_rwi_stored = new AtomicInteger(0);
        this.local_solr_evicted = new AtomicInteger(0);
        this.local_solr_stored = new AtomicInteger(0);
        this.remote_rwi_stored = new AtomicInteger(0);
        this.remote_rwi_available = new AtomicInteger(0);
        this.remote_rwi_peerCount = new AtomicInteger(0);
        this.remote_solr_stored = new AtomicInteger(0);
        this.remote_solr_available = new AtomicInteger(0);
        this.remote_solr_peerCount = new AtomicInteger(0);
        this.resortCacheAllowed = new Semaphore(1);
        long start = System.currentTimeMillis();
        this.localSearchInclusion = null;
        this.ref = new ConcurrentScoreMap<String>(this);
        this.maxtime = query2.maxtime;
        this.rwiStack = new WeakPriorityBlockingQueue(3000, false);
        this.doubleDomCache = new ConcurrentHashMap();
        this.flagcount = new int[32];
        for (int i = 0; i < 32; ++i) {
            this.flagcount[i] = 0;
        }
        this.feedersAlive = new AtomicInteger(0);
        this.feedersTerminated = new AtomicInteger(0);
        this.snippetFetchAlive = new AtomicInteger(0);
        this.addRunning = true;
        this.receivedRemoteReferences = new AtomicInteger(0);
        this.order = new ReferenceOrder(this.query.ranking, this.query.targetlang);
        this.urlhashes = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 100);
        this.taggingPredicates = new HashMap<String, String>();
        for (Tagging t : LibraryProvider.autotagging.getVocabularies()) {
            this.taggingPredicates.put(t.getName(), t.getPredicate());
        }
        if (!Switchboard.getSwitchboard().getConfigBool("debug.search.local.solr.off", false)) {
            boolean useSolrFacets = true;
            this.localsolrsearch = RemoteSearch.solrRemoteSearch(this, this.query.solrQuery(this.query.contentdom, this.query.isStrictContentDom(), true, this.excludeintext_image), this.query.offset, this.query.itemsPerPage, null, 0, Switchboard.urlBlacklist, true, true);
        }
        this.localsolroffset = this.query.offset + this.query.itemsPerPage;
        this.rwiProcess = null;
        if (query2.getSegment().connectedRWI() && !Switchboard.getSwitchboard().getConfigBool("debug.search.local.dht.off", false)) {
            this.rwiProcess = new RWIProcess(this.localsolrsearch);
            this.rwiProcess.start();
        }
        if (this.remote) {
            this.pollImmediately = false;
            long timer = System.currentTimeMillis();
            if (this.query.getQueryGoal().getIncludeHashes().isEmpty()) {
                this.primarySearchThreadsL = null;
                this.nodeSearchThreads = null;
            } else {
                this.primarySearchThreadsL = new ArrayList<RemoteSearch>();
                this.nodeSearchThreads = new ArrayList<Thread>();
                new Thread(this, "SearchEvent.primaryRemoteSearches"){
                    final /* synthetic */ SearchEvent this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void run() {
                        RemoteSearch.primaryRemoteSearches(this.this$0, 0, remote_maxcount, remote_maxtime, Switchboard.urlBlacklist, this.this$0.query.domType == QueryParams.Searchdom.GLOBAL ? null : preselectedPeerHashes);
                    }
                }.start();
            }
            if (this.primarySearchThreadsL != null) {
                ConcurrentLog.fine("SEARCH_EVENT", "STARTING " + this.primarySearchThreadsL.size() + " THREADS TO CATCH EACH " + remote_maxcount + " URLs");
                EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.REMOTESEARCH_START, "", this.primarySearchThreadsL.size(), System.currentTimeMillis() - timer), false);
                ConcurrentLog.fine("SEARCH_EVENT", "SEARCH TIME AFTER GLOBAL-TRIGGER TO " + this.primarySearchThreadsL.size() + " PEERS: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
            } else {
                ConcurrentLog.fine("SEARCH_EVENT", "NO SEARCH STARTED DUE TO EMPTY SEARCH REQUEST.");
            }
        } else {
            this.primarySearchThreadsL = null;
            this.nodeSearchThreads = null;
            boolean bl = this.pollImmediately = !query2.getSegment().connectedRWI() || !Switchboard.getSwitchboard().getConfigBool("allowReceiveIndex.search", false);
            if (generateAbstracts) {
                try {
                    if (this.rwiProcess != null && query2.getSegment().connectedRWI()) {
                        this.rwiProcess.join();
                    }
                }
                catch (Throwable timer) {
                    // empty catch block
                }
                long timer = System.currentTimeMillis();
                int maxcount = -1;
                long mindhtdistance = Long.MAX_VALUE;
                assert (!query2.getSegment().connectedRWI() || this.searchContainerMap() != null);
                if (this.searchContainerMap() != null) {
                    for (Map.Entry<byte[], ReferenceContainer<WordReference>> entry2 : this.searchContainerMap().entrySet()) {
                        long l;
                        byte[] wordhash = entry2.getKey();
                        ReferenceContainer<WordReference> container = entry2.getValue();
                        assert (Base64Order.enhancedCoder.equal(container.getTermHash(), wordhash)) : "container.getTermHash() = " + ASCII.String(container.getTermHash()) + ", wordhash = " + ASCII.String(wordhash);
                        if (container.size() > maxcount) {
                            this.IAmaxcounthash = wordhash;
                            maxcount = container.size();
                        }
                        if ((l = Distribution.horizontalDHTDistance(wordhash, ASCII.getBytes(peers.mySeed().hash))) < mindhtdistance) {
                            mindhtdistance = l;
                            this.IAneardhthash = wordhash;
                        }
                        this.IACount.put(wordhash, LargeNumberCache.valueOf(container.size()));
                        this.IAResults.put(wordhash, WordReferenceFactory.compressIndex(container, null, 1000L).toString());
                    }
                }
                EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.ABSTRACTS, "", this.searchContainerMap() == null ? 0 : this.searchContainerMap().size(), System.currentTimeMillis() - timer), false);
            } else {
                try {
                    if (this.rwiProcess != null && query2.getSegment().connectedRWI() && this.rwiProcess.isAlive()) {
                        this.rwiProcess.join(100L);
                    }
                }
                catch (Throwable timer) {
                    // empty catch block
                }
            }
        }
        this.deleteIfSnippetFail = deleteIfSnippetFail;
        this.urlRetrievalAllTime = 0L;
        this.snippetComputationAllTime = 0L;
        this.resultList = new WeakPriorityBlockingQueue(Math.max(150, 10 * query2.itemsPerPage()), true);
        boolean filtered = false;
        if (Switchboard.stopwordHashes != null) {
            Iterator<byte[]> it = query2.getQueryGoal().getIncludeHashes().iterator();
            while (it.hasNext()) {
                if (!Switchboard.stopwordHashes.contains(it.next())) continue;
                filtered = true;
                break;
            }
        }
        this.snippetFetchWordHashes = query2.getQueryGoal().getIncludeHashes().clone();
        if (filtered) {
            this.snippetFetchWordHashes.excludeDestructive(Switchboard.stopwordHashes);
        }
        this.snippetFetchWords = query2.getQueryGoal().getIncludeWordsSet();
        this.snippetFetchWords.removeAll(Switchboard.stopwords);
        SearchEventCache.cleanupEvents(false);
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.CLEANUP, "", 0, 0L), false);
        if (MemoryControl.available() < 0x6400000L) {
            SearchEventCache.cleanupEvents(false);
        }
        SearchEventCache.put(this.query.id(false), this);
    }

    public int addRWIs(ReferenceContainer<WordReference> index2, boolean local, String resourceName, int fullResource, long maxtime) {
        this.addRunning = true;
        assert (index2 != null);
        if (index2.isEmpty()) {
            return 0;
        }
        if (local) {
            assert (fullResource >= 0) : "fullResource = " + fullResource;
            this.local_rwi_stored.addAndGet(fullResource);
        } else {
            assert (fullResource >= 0) : "fullResource = " + fullResource;
            this.remote_rwi_stored.addAndGet(fullResource);
            this.remote_rwi_peerCount.incrementAndGet();
        }
        long timer = System.currentTimeMillis();
        BlockingQueue<WordReferenceVars> decodedEntries = this.order.normalizeWith(index2, maxtime, local);
        int is = index2.size();
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.NORMALIZING, resourceName, is, System.currentTimeMillis() - timer), false);
        if (!local) {
            this.receivedRemoteReferences.addAndGet(is);
        }
        timer = System.currentTimeMillis();
        long timeout = maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime;
        int successcounter = 0;
        try {
            String acceptableAlternativeSitehash = null;
            if (this.query.modifier.sitehost != null && this.query.modifier.sitehost.length() > 0) {
                try {
                    acceptableAlternativeSitehash = DigestURL.hosthash((String)(this.query.modifier.sitehost.startsWith("www.") ? this.query.modifier.sitehost.substring(4) : "www." + this.query.modifier.sitehost), 80);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            while (true) {
                long remaining;
                if ((remaining = timeout - System.currentTimeMillis()) <= 0L) {
                    ConcurrentLog.warn("SearchEvent", "terminated 'add' loop before poll time-out = " + remaining + ", decodedEntries.size = " + decodedEntries.size());
                    break;
                }
                WordReferenceVars iEntry = decodedEntries.poll(remaining, TimeUnit.MILLISECONDS);
                if (iEntry == null) {
                    ConcurrentLog.warn("SearchEvent", "terminated 'add' loop after poll time-out = " + remaining + ", decodedEntries.size = " + decodedEntries.size());
                    break;
                }
                if (iEntry == WordReferenceVars.poison) break;
                assert (iEntry.urlhash().length == index2.row().primaryKeyLength);
                if (this.urlhashes.has(iEntry.urlhash())) {
                    if (!log.isFine()) continue;
                    log.fine("dropped RWI: doublecheck");
                    continue;
                }
                Bitfield flags = iEntry.flags();
                for (int j = 0; j < 32; ++j) {
                    if (!flags.get(j)) continue;
                    int n = j;
                    this.flagcount[n] = this.flagcount[n] + 1;
                }
                if (!this.testFlags(flags)) {
                    if (!log.isFine()) continue;
                    log.fine("dropped RWI: flag test failed");
                    continue;
                }
                if (this.query.contentdom.getCode() > 0) {
                    boolean domainMatch = true;
                    if (this.query.isStrictContentDom()) {
                        if (this.query.contentdom == Classification.ContentDomain.AUDIO && iEntry.getType() != 'a' || this.query.contentdom == Classification.ContentDomain.VIDEO && iEntry.getType() != 'm' || this.query.contentdom == Classification.ContentDomain.IMAGE && iEntry.getType() != 'i' || this.query.contentdom == Classification.ContentDomain.APP && !flags.get(23)) {
                            domainMatch = false;
                        }
                    } else if (this.query.contentdom == Classification.ContentDomain.AUDIO && !flags.get(21) || this.query.contentdom == Classification.ContentDomain.VIDEO && !flags.get(22) || this.query.contentdom == Classification.ContentDomain.IMAGE && !flags.get(20) || this.query.contentdom == Classification.ContentDomain.APP && !flags.get(23)) {
                        domainMatch = false;
                    }
                    if (!domainMatch) {
                        if (!log.isFine()) continue;
                        log.fine("dropped RWI: contentdom fail");
                        continue;
                    }
                }
                if (this.query.modifier.language != null && !this.query.modifier.language.isEmpty() && !this.query.modifier.language.equals(iEntry.getLanguageString())) {
                    if (!log.isFine()) continue;
                    log.fine("dropped RWI: language constraint = " + this.query.modifier.language);
                    continue;
                }
                String hosthash = iEntry.hosthash();
                if (this.query.modifier.sitehash == null) {
                    if (this.query.siteexcludes != null && this.query.siteexcludes.contains(hosthash)) {
                        if (!log.isFine()) continue;
                        log.fine("dropped RWI: siteexcludes");
                        continue;
                    }
                } else if (!(hosthash.equals(this.query.modifier.sitehash) || acceptableAlternativeSitehash != null && hosthash.equals(acceptableAlternativeSitehash))) {
                    if (!log.isFine()) continue;
                    log.fine("dropped RWI: modifier.sitehash");
                    continue;
                }
                this.urlhashes.putUnique(iEntry.urlhash());
                while (true) {
                    try {
                        this.rwiStack.put(new WeakPriorityBlockingQueue.ReverseElement<WordReferenceVars>(iEntry, this.order.cardinal(iEntry)));
                    }
                    catch (ArithmeticException e) {
                        if (!log.isFine()) continue;
                        log.fine("dropped RWI: arithmetic exception");
                        continue;
                    }
                    break;
                }
                if (local) {
                    this.local_rwi_available.incrementAndGet();
                } else {
                    this.remote_rwi_available.incrementAndGet();
                }
                ++successcounter;
            }
            if (System.currentTimeMillis() >= timeout) {
                ConcurrentLog.warn("SearchEvent", "rwi normalization ended with timeout = " + maxtime);
            }
        }
        catch (InterruptedException | SpaceExceededException exception) {
            // empty catch block
        }
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.PRESORT, resourceName, index2.size(), System.currentTimeMillis() - timer), false);
        return successcounter;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    protected void resetEventTime() {
        this.eventTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Thread thread;
        if (this.localsolrsearch != null && this.localsolrsearch.isAlive()) {
            Thread[] threadArray = this.localsolrsearch;
            synchronized (threadArray) {
                this.localsolrsearch.interrupt();
            }
        }
        if (this.nodeSearchThreads != null) {
            for (Thread thread2 : this.nodeSearchThreads) {
                if (thread2 == null) continue;
                thread = thread2;
                synchronized (thread) {
                    if (thread2.isAlive()) {
                        thread2.interrupt();
                    }
                }
            }
        }
        if (this.primarySearchThreadsL != null) {
            for (RemoteSearch remoteSearch : this.primarySearchThreadsL) {
                if (remoteSearch == null) continue;
                thread = remoteSearch;
                synchronized (thread) {
                    if (remoteSearch.isAlive()) {
                        remoteSearch.interrupt();
                    }
                }
            }
        }
        if (this.secondarySearchThreads != null) {
            for (Thread search3 : this.secondarySearchThreads) {
                if (search3 == null) continue;
                Thread thread3 = search3;
                synchronized (thread3) {
                    if (search3.isAlive()) {
                        search3.interrupt();
                    }
                }
            }
        }
        if (this.preselectedPeerHashes != null) {
            this.preselectedPeerHashes.clear();
        }
        if (this.IACount != null) {
            this.IACount.clear();
        }
        if (this.IAResults != null) {
            this.IAResults.clear();
        }
        if (this.heuristics != null) {
            this.heuristics.clear();
        }
        this.rwiStack.clear();
        this.nodeStack.clear();
        this.resultList.clear();
    }

    public String abstractsString(byte[] hash) {
        return (String)this.IAResults.get(hash);
    }

    public Iterator<Map.Entry<byte[], Integer>> abstractsCount() {
        return this.IACount.entrySet().iterator();
    }

    public int abstractsCount(byte[] hash) {
        Integer i = (Integer)this.IACount.get(hash);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public byte[] getAbstractsMaxCountHash() {
        return this.IAmaxcounthash;
    }

    public byte[] getAbstractsNearDHTHash() {
        return this.IAneardhthash;
    }

    public List<RemoteSearch> getPrimarySearchThreads() {
        return this.primarySearchThreadsL;
    }

    public Thread[] getSecondarySearchThreads() {
        return this.secondarySearchThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeuristic(byte[] urlhash, String heuristicName, boolean redundant) {
        SortedMap<byte[], HeuristicResult> sortedMap = this.heuristics;
        synchronized (sortedMap) {
            this.heuristics.put(urlhash, new HeuristicResult(urlhash, heuristicName, redundant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicResult getHeuristic(byte[] urlhash) {
        SortedMap<byte[], HeuristicResult> sortedMap = this.heuristics;
        synchronized (sortedMap) {
            return (HeuristicResult)this.heuristics.get(urlhash);
        }
    }

    public void addNodes(List<URIMetadataNode> nodeList, Map<String, ReversibleScoreMap<String>> facets, Map<String, LinkedHashSet<String>> solrsnippets, boolean local, String resourceName, int fullResource, boolean incrementNavigators) {
        this.addBegin();
        this.snippets.putAll(solrsnippets);
        assert (nodeList != null);
        if (nodeList.isEmpty()) {
            return;
        }
        if (local) {
            this.local_solr_stored.set(fullResource);
        } else {
            assert (fullResource >= 0) : "fullResource = " + fullResource;
            this.remote_solr_stored.addAndGet(fullResource);
            this.remote_solr_peerCount.incrementAndGet();
        }
        long timer = System.currentTimeMillis();
        int is = nodeList.size();
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.NORMALIZING, resourceName, is, System.currentTimeMillis() - timer), false);
        if (!local) {
            this.receivedRemoteReferences.addAndGet(is);
        }
        timer = System.currentTimeMillis();
        if (incrementNavigators) {
            this.incrNavigatorsFromSolrFacets(facets);
        }
        try {
            for (URIMetadataNode iEntry : nodeList) {
                String matchingResult = QueryParams.matchesURL(this.query.modifier, this.query.tld, iEntry.url());
                if (!matchingResult.isEmpty()) {
                    if (log.isFine()) {
                        log.fine("dropped Node: " + matchingResult);
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                if (!this.query.urlMask_isCatchall && this.query.urlMaskPattern != null && !iEntry.matches(this.query.urlMaskPattern)) {
                    if (log.isFine()) {
                        log.fine("dropped Node: url mask does not match");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                if (this.urlhashes.has(iEntry.hash())) {
                    if (log.isFine()) {
                        log.fine("dropped Node: double check");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                for (int j = 0; j < 32; ++j) {
                    if (!iEntry.flags().get(j)) continue;
                    int[] nArray = this.flagCount();
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                Bitfield flags = iEntry.flags();
                if (!this.testFlags(flags)) {
                    if (log.isFine()) {
                        log.fine("dropped Node: flag test");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                if (this.query.contentdom.getCode() > 0) {
                    boolean domainMatch = true;
                    if (this.query.isStrictContentDom()) {
                        if (this.query.contentdom != iEntry.getContentDomain()) {
                            domainMatch = false;
                        }
                    } else if (this.query.contentdom == Classification.ContentDomain.AUDIO && !flags.get(21) || this.query.contentdom == Classification.ContentDomain.VIDEO && !flags.get(22) || this.query.contentdom == Classification.ContentDomain.IMAGE && !flags.get(20) || this.query.contentdom == Classification.ContentDomain.APP && !flags.get(23)) {
                        domainMatch = false;
                    }
                    if (!domainMatch) {
                        if (log.isFine()) {
                            log.fine("dropped Node: content domain does not match");
                        }
                        this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                        continue;
                    }
                }
                String ext = MultiProtocolURL.getFileExtension(iEntry.url().getFileName());
                if (this.query.contentdom == Classification.ContentDomain.TEXT && Classification.isImageExtension(ext) && this.excludeintext_image) {
                    if (log.isFine()) {
                        log.fine("dropped Node: file name domain does not match");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                String hosthash = iEntry.hosthash();
                if (this.query.modifier.sitehash == null && this.query.siteexcludes != null && this.query.siteexcludes.contains(hosthash)) {
                    if (log.isFine()) {
                        log.fine("dropped Node: siteexclude");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                if (this.query.modifier.language != null && !this.query.modifier.language.equals(iEntry.language())) {
                    if (log.isFine()) {
                        log.fine("dropped Node: language");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                if (this.query.modifier.author != null && !this.query.modifier.author.equals(iEntry.dc_creator())) {
                    if (log.isFine()) {
                        log.fine("dropped Node: author");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                if (this.query.modifier.keyword != null && iEntry.dc_subject().indexOf(this.query.modifier.keyword) < 0) {
                    if (log.isFine()) {
                        log.fine("dropped Node: keyword");
                    }
                    this.updateCountsOnSolrEntryToEvict(iEntry, facets, local, !incrementNavigators);
                    continue;
                }
                this.urlhashes.putUnique(iEntry.hash());
                while (true) {
                    try {
                        Float scorex = (Float)iEntry.getFieldValue("score");
                        long score = scorex != null && scorex.floatValue() > 0.0f ? (long)(1000000.0f * scorex.floatValue() - (float)iEntry.urllength()) : this.order.cardinal(iEntry);
                        this.nodeStack.put(new WeakPriorityBlockingQueue.ReverseElement<URIMetadataNode>(iEntry, score));
                    }
                    catch (ArithmeticException e) {
                        continue;
                    }
                    break;
                }
                if (!local) {
                    this.remote_solr_available.incrementAndGet();
                }
                if (!incrementNavigators) continue;
                this.incrNavigatorsFromSingleDocument(iEntry, facets);
            }
        }
        catch (SpaceExceededException spaceExceededException) {
            // empty catch block
        }
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.PRESORT, resourceName, nodeList.size(), System.currentTimeMillis() - timer), false);
    }

    private void incrNavigatorsFromSolrFacets(Map<String, ReversibleScoreMap<String>> facets) {
        if (facets != null && !facets.isEmpty()) {
            ReversibleScoreMap<String> fcts;
            for (String string : this.navigatorPlugins.keySet()) {
                Navigator navi = this.navigatorPlugins.get(string);
                if (navi == null) continue;
                navi.incFacet(facets);
            }
            if (this.locationNavigator != null && (fcts = facets.get(CollectionSchema.coordinate_p_0_coordinate.getSolrFieldName())) != null) {
                for (String coordinate : fcts) {
                    int hc = fcts.get(coordinate);
                    if (hc == 0) continue;
                    this.locationNavigator.inc(coordinate, hc);
                }
            }
            if (this.dateNavigator != null && (fcts = facets.get(CollectionSchema.dates_in_content_dts.getSolrFieldName())) != null) {
                this.dateNavigator.inc((String)((Object)fcts));
            }
            if (this.protocolNavigator != null && (fcts = facets.get(CollectionSchema.url_protocol_s.getSolrFieldName())) != null) {
                Iterator iterator = fcts.iterator();
                while (iterator.hasNext()) {
                    String protocol = (String)iterator.next();
                    if (PROTOCOL_NAVIGATOR_SUPPORTED_VALUES.indexOf(protocol) >= 0) continue;
                    iterator.remove();
                }
                this.protocolNavigator.inc(fcts);
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Tagging v : LibraryProvider.autotagging.getVocabularies()) {
                linkedHashSet.add(v.getName());
            }
            linkedHashSet.addAll(ProbabilisticClassifier.getContextNames());
            for (String vocName : linkedHashSet) {
                fcts = facets.get("vocabulary_" + vocName + "_sxt");
                if (fcts == null) continue;
                ScoreMap<String> vocNav = this.vocabularyNavigator.get(vocName);
                if (vocNav == null) {
                    vocNav = new ConcurrentScoreMap<String>();
                    this.vocabularyNavigator.put(vocName, vocNav);
                }
                vocNav.inc(fcts);
            }
        }
    }

    private void incrNavigatorsFromSingleDocument(URIMetadataNode doc, Map<String, ReversibleScoreMap<String>> facets) {
        String protocol;
        Date[] dates;
        for (String s : this.navigatorPlugins.keySet()) {
            Navigator navi = this.navigatorPlugins.get(s);
            if ((navi == null || facets != null) && facets.containsKey(navi.getIndexFieldName())) continue;
            navi.incDoc(doc);
        }
        if (!(this.dateNavigator == null || facets != null && facets.containsKey(CollectionSchema.dates_in_content_dts.getSolrFieldName()) || (dates = doc.datesInContent()) == null)) {
            for (Date date : dates) {
                if (date == null) continue;
                this.dateNavigator.inc(ISO8601Formatter.FORMATTER.format(date));
            }
        }
        if (!(this.protocolNavigator == null || facets != null && facets.containsKey(CollectionSchema.url_protocol_s.getSolrFieldName()) || (protocol = doc.url().getProtocol()) == null || PROTOCOL_NAVIGATOR_SUPPORTED_VALUES.indexOf(protocol) < 0)) {
            this.protocolNavigator.inc(protocol);
        }
        if (this.vocabularyNavigator != null) {
            LinkedHashSet<String> genericFacets = new LinkedHashSet<String>();
            for (Tagging v : LibraryProvider.autotagging.getVocabularies()) {
                genericFacets.add(v.getName());
            }
            genericFacets.addAll(ProbabilisticClassifier.getContextNames());
            for (String vocName : genericFacets) {
                String fieldName = "vocabulary_" + vocName + "_sxt";
                if (facets != null && facets.containsKey(fieldName)) continue;
                this.incrementVocNavigator(doc, vocName, fieldName);
            }
        }
    }

    protected void incrementVocNavigator(URIMetadataNode doc, String vocName, String fieldName) {
        Object docValue = doc.getFieldValue(fieldName);
        if (docValue instanceof String) {
            ScoreMap<String> vocNav = this.vocabularyNavigator.get(vocName);
            if (vocNav == null) {
                vocNav = new ConcurrentScoreMap<String>();
                this.vocabularyNavigator.put(vocName, vocNav);
            }
            vocNav.inc((String)docValue);
        } else if (docValue instanceof Collection && !((Collection)docValue).isEmpty()) {
            ScoreMap<String> vocNav = this.vocabularyNavigator.get(vocName);
            if (vocNav == null) {
                vocNav = new ConcurrentScoreMap<String>();
                this.vocabularyNavigator.put(vocName, vocNav);
            }
            for (Object singleDocValue : (Collection)docValue) {
                if (!(singleDocValue instanceof String)) continue;
                vocNav.inc((String)singleDocValue);
            }
        }
    }

    public void addExpectedRemoteReferences(int x) {
        if (x > 0) {
            this.maxExpectedRemoteReferences.addAndGet(x);
        }
        this.expectedRemoteReferences.addAndGet(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URIMetadataNode pullOneRWI(boolean skipDoubleDom) {
        URIMetadataNode node;
        WeakPriorityBlockingQueue.Element<WordReferenceVars> rwi = null;
        block10: while (true) {
            WeakPriorityBlockingQueue<WordReferenceVars> m;
            int c = 0;
            while (this.rwiStack.sizeQueue() > 0 && c++ < 10) {
                rwi = this.rwiStack.poll();
                if (rwi == null) {
                    return null;
                }
                if (!skipDoubleDom) {
                    URIMetadataNode node2 = this.query.getSegment().fulltext().getMetadata(rwi);
                    if (node2 == null) {
                        this.decrementCounts(rwi.getElement());
                        continue;
                    }
                    return node2;
                }
                String hosthash = rwi.getElement().hosthash();
                m = this.doubleDomCache.get(hosthash);
                if (m == null) {
                    ConcurrentHashMap<String, WeakPriorityBlockingQueue<WordReferenceVars>> concurrentHashMap = this.doubleDomCache;
                    synchronized (concurrentHashMap) {
                        m = this.doubleDomCache.get(hosthash);
                        if (m == null) {
                            m = new WeakPriorityBlockingQueue(3000, false);
                            this.doubleDomCache.put(hosthash, m);
                            URIMetadataNode node3 = this.query.getSegment().fulltext().getMetadata(rwi);
                            if (node3 == null) {
                                this.decrementCounts(rwi.getElement());
                                continue;
                            }
                            return node3;
                        }
                        m.put(rwi);
                        continue;
                    }
                }
                m.put(rwi);
            }
            if (this.doubleDomCache.isEmpty()) {
                return null;
            }
            WeakPriorityBlockingQueue.Element<WordReferenceVars> bestEntry = null;
            Iterator<WeakPriorityBlockingQueue<WordReferenceVars>> i = this.doubleDomCache.values().iterator();
            while (i.hasNext()) {
                try {
                    m = i.next();
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.logException(e);
                    continue block10;
                }
                if (m == null || m.isEmpty()) continue;
                if (bestEntry == null) {
                    bestEntry = m.peek();
                    continue;
                }
                WeakPriorityBlockingQueue.Element<WordReferenceVars> o = m.peek();
                if (o == null || o.getWeight() <= bestEntry.getWeight()) continue;
                bestEntry = o;
            }
            if (bestEntry == null) {
                return null;
            }
            m = this.doubleDomCache.get(((WordReferenceVars)bestEntry.getElement()).hosthash());
            if (m != null && (bestEntry = m.poll()) != null && m.sizeAvailable() == 0) {
                ConcurrentHashMap<String, WeakPriorityBlockingQueue<WordReferenceVars>> e = this.doubleDomCache;
                synchronized (e) {
                    if (m.sizeAvailable() == 0) {
                        this.doubleDomCache.remove(bestEntry.getElement().hosthash());
                    }
                }
            }
            if (bestEntry == null) {
                return null;
            }
            node = null;
            try {
                node = this.query.getSegment().fulltext().getMetadata(bestEntry);
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
            if (node != null) break;
            this.decrementCounts(bestEntry.getElement());
            if (!log.isFine()) continue;
            log.fine("dropped RWI: hash not in metadata");
        }
        return node;
    }

    public URIMetadataNode pullOneFilteredFromRWI(boolean skipDoubleDom) {
        URIMetadataNode page;
        block0: while ((page = this.pullOneRWI(skipDoubleDom)) != null) {
            Date[] dates;
            String protocol;
            double lonDelta;
            double latDelta;
            double distance;
            double lon;
            double lat;
            String matchingResult = QueryParams.matchesURL(this.query.modifier, this.query.tld, page.url());
            if (!matchingResult.isEmpty()) {
                if (log.isFine()) {
                    log.fine("dropped RWI: no match on " + matchingResult);
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (!this.query.urlMask_isCatchall && this.query.urlMaskPattern != null && !page.matches(this.query.urlMaskPattern)) {
                if (log.isFine()) {
                    log.fine("dropped RWI: no match with urlMask");
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (page.url() == null) {
                if (log.isFine()) {
                    log.fine("dropped RWI: url == null");
                }
                this.decrementCounts(page.word());
                continue;
            }
            Classification.ContentDomain contentDomain = page.getContentDomain();
            if (this.query.contentdom.getCode() > 0 && (this.query.contentdom == Classification.ContentDomain.IMAGE && contentDomain != Classification.ContentDomain.IMAGE || this.query.contentdom == Classification.ContentDomain.AUDIO && contentDomain != Classification.ContentDomain.AUDIO || this.query.contentdom == Classification.ContentDomain.VIDEO && contentDomain != Classification.ContentDomain.VIDEO || this.query.contentdom == Classification.ContentDomain.APP && contentDomain != Classification.ContentDomain.APP) && this.query.urlMask_isCatchall) {
                if (log.isFine()) {
                    log.fine("dropped RWI: wrong contentdom = " + String.valueOf((Object)this.query.contentdom) + ", domain = " + String.valueOf((Object)contentDomain));
                }
                this.decrementCounts(page.word());
                continue;
            }
            String ext = MultiProtocolURL.getFileExtension(page.url().getFileName());
            if (this.query.contentdom == Classification.ContentDomain.TEXT && Classification.isImageExtension(ext) && this.excludeintext_image) {
                if (!log.isFine()) continue;
                log.fine("dropped RWI: file name domain does not match");
                continue;
            }
            if (this.query.modifier.language != null && !this.query.modifier.language.equals(page.language())) {
                if (log.isFine()) {
                    log.fine("dropped RWI: language constraint = " + this.query.modifier.language);
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (this.query.modifier.author != null && !page.dc_creator().toLowerCase().contains(this.query.modifier.author.toLowerCase())) {
                if (log.isFine()) {
                    log.fine("dropped RWI: author  constraint = " + this.query.modifier.author);
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (this.query.modifier.collection != null) {
                Collection docCols = page.getFieldValues(CollectionSchema.collection_sxt.getSolrFieldName());
                if (docCols == null) {
                    this.decrementCounts(page.word());
                    continue;
                }
                if (!docCols.contains(this.query.modifier.collection)) {
                    this.decrementCounts(page.word());
                    continue;
                }
            }
            if (this.query.modifier.keyword != null && !page.dc_subject().toLowerCase().contains(this.query.modifier.keyword.toLowerCase())) {
                if (log.isFine()) {
                    log.fine("dropped RWI: keyword  constraint = " + this.query.modifier.keyword);
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.SEARCH, page.url())) {
                if (log.isFine()) {
                    log.fine("dropped RWI: url is blacklisted in url blacklist");
                }
                this.decrementCounts(page.word());
                continue;
            }
            String pageurl = page.url().toNormalform(true);
            String pageauthor = page.dc_creator();
            String pagetitle = page.dc_title().toLowerCase();
            if (this.query.getQueryGoal().getExcludeSize() != 0 && (QueryParams.anymatch(pagetitle, this.query.getQueryGoal().getExcludeWords()) || QueryParams.anymatch(pageurl.toLowerCase(), this.query.getQueryGoal().getExcludeWords()) || QueryParams.anymatch(pageauthor.toLowerCase(), this.query.getQueryGoal().getExcludeWords()))) {
                if (log.isFine()) {
                    log.fine("dropped RWI: no match with query goal exclusion");
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (this.query.constraint != null && this.query.constraint.get(0) && !pagetitle.startsWith("index of")) {
                Iterator<byte[]> wi = this.query.getQueryGoal().getIncludeHashes().iterator();
                if (this.query.getSegment().termIndex() != null) {
                    while (wi.hasNext()) {
                        this.query.getSegment().termIndex().removeDelayed(wi.next(), page.hash());
                    }
                }
                if (log.isFine()) {
                    log.fine("dropped RWI: url does not match index-of constraint");
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (this.query.constraint != null && this.query.constraint.get(19) && (page.lat() == 0.0 || page.lon() == 0.0)) {
                if (log.isFine()) {
                    log.fine("dropped RWI: location constraint");
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (this.query.radius > 0.0 && this.query.lat != 0.0 && this.query.lon != 0.0 && (lat = page.lat()) != 0.0 && (lon = page.lon()) != 0.0 && (distance = Math.sqrt((latDelta = this.query.lat - lat) * latDelta + (lonDelta = this.query.lon - lon) * lonDelta)) > this.query.radius) {
                if (log.isFine()) {
                    log.fine("dropped RWI: radius constraint");
                }
                this.decrementCounts(page.word());
                continue;
            }
            if (this.query.metatags != null && !this.query.metatags.isEmpty()) {
                for (Tagging.Metatag tag : this.query.metatags) {
                    Collection tagvalues;
                    URIMetadataNode sdoc = page;
                    if (sdoc != null && (tagvalues = sdoc.getFieldValues("vocabulary_" + tag.getVocabularyName() + "_sxt")) != null && tagvalues.contains(tag.getObject())) continue;
                    if (log.isFine()) {
                        log.fine("dropped RWI: url not tagged with vocabulary " + tag.getVocabularyName());
                    }
                    this.decrementCounts(page.word());
                    continue block0;
                }
            }
            for (String s : this.navigatorPlugins.keySet()) {
                Navigator navi = this.navigatorPlugins.get(s);
                if (navi == null) continue;
                navi.incDoc(page);
            }
            if (this.protocolNavigator != null && page.url() != null && (protocol = page.url().getProtocol()) != null) {
                this.protocolNavigator.inc(protocol);
            }
            if (this.dateNavigator != null && (dates = page.datesInContent()) != null) {
                for (Date date : dates) {
                    if (date == null) continue;
                    this.dateNavigator.inc(ISO8601Formatter.FORMATTER.format(date));
                }
            }
            if (this.vocabularyNavigator != null) {
                LinkedHashSet<String> genericFacets = new LinkedHashSet<String>();
                for (Tagging v : LibraryProvider.autotagging.getVocabularies()) {
                    genericFacets.add(v.getName());
                }
                genericFacets.addAll(ProbabilisticClassifier.getContextNames());
                for (String vocName : genericFacets) {
                    String fieldName = "vocabulary_" + vocName + "_sxt";
                    this.incrementVocNavigator(page, vocName, fieldName);
                }
            }
            return page;
        }
        return null;
    }

    private void decrementCounts(WordReferenceVars entry2) {
        if (entry2 == null) {
            return;
        }
        if (entry2.local()) {
            if (this.local_rwi_available.get() > 0) {
                this.local_rwi_available.decrementAndGet();
            }
        } else if (this.remote_rwi_available.get() > 0) {
            this.remote_rwi_available.decrementAndGet();
        }
    }

    private void updateCountsOnSolrEntryToEvict(URIMetadataNode entry2, Map<String, ReversibleScoreMap<String>> facets, boolean local, boolean navIncrementedEarlier) {
        ReversibleScoreMap<String> fcts;
        if (entry2 == null) {
            return;
        }
        if (local) {
            this.local_solr_evicted.incrementAndGet();
        }
        boolean navIncrementedWithFacets = facets != null && !facets.isEmpty() && !navIncrementedEarlier;
        for (String s : this.navigatorPlugins.keySet()) {
            Navigator navi = this.navigatorPlugins.get(s);
            if (navi == null) continue;
            fcts = navIncrementedWithFacets ? facets.get(navi.getIndexFieldName()) : null;
            Object value = entry2.getFieldValue(navi.getIndexFieldName());
            if (value == null) continue;
            if (value instanceof Collection) {
                for (Object singleVal : (Collection)value) {
                    if (!(singleVal instanceof String)) continue;
                    String singleStringVal = (String)singleVal;
                    if (!navIncrementedEarlier && (fcts == null || !fcts.containsKey(singleStringVal)) || navi.get(singleStringVal) <= 0) continue;
                    navi.dec(singleStringVal);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            String stringValue = (String)value;
            if (!navIncrementedEarlier && (fcts == null || !fcts.containsKey(stringValue)) || navi.get(stringValue) <= 0) continue;
            navi.dec(stringValue);
        }
        if (this.dateNavigator != null) {
            fcts = navIncrementedWithFacets ? facets.get(CollectionSchema.dates_in_content_dts.getSolrFieldName()) : null;
            Date[] dates = entry2.datesInContent();
            if (dates != null) {
                for (Date date : dates) {
                    if (date == null) continue;
                    String dateStr = ISO8601Formatter.FORMATTER.format(date);
                    if (!navIncrementedEarlier && (fcts == null || !fcts.containsKey(dateStr)) || this.dateNavigator.get(dateStr) <= 0) continue;
                    this.dateNavigator.dec(dateStr);
                }
            }
        }
        if (this.protocolNavigator != null) {
            fcts = navIncrementedWithFacets ? facets.get(CollectionSchema.url_protocol_s.getSolrFieldName()) : null;
            String protocol = entry2.url().getProtocol();
            if (protocol != null && (navIncrementedEarlier || fcts != null && fcts.containsKey(protocol)) && this.protocolNavigator.get(protocol) > 0) {
                this.protocolNavigator.dec(protocol);
            }
        }
        if (this.vocabularyNavigator != null) {
            LinkedHashSet<String> genericFacets = new LinkedHashSet<String>();
            for (Tagging v : LibraryProvider.autotagging.getVocabularies()) {
                genericFacets.add(v.getName());
            }
            genericFacets.addAll(ProbabilisticClassifier.getContextNames());
            for (String vocName : genericFacets) {
                String fieldName = "vocabulary_" + vocName + "_sxt";
                fcts = navIncrementedWithFacets ? facets.get(fieldName) : null;
                Object docValue = entry2.getFieldValue(fieldName);
                if (docValue instanceof String) {
                    ScoreMap<String> vocNav;
                    if (!navIncrementedEarlier && (fcts == null || !fcts.containsKey((String)docValue)) || (vocNav = this.vocabularyNavigator.get(vocName)) == null || vocNav.get((String)docValue) <= 0) continue;
                    vocNav.dec((String)docValue);
                    continue;
                }
                if (!(docValue instanceof Collection) || ((Collection)docValue).isEmpty()) continue;
                for (Object singleDocValue : (Collection)docValue) {
                    ScoreMap<String> vocNav;
                    if (!(singleDocValue instanceof String) || !navIncrementedEarlier && (fcts == null || !fcts.containsKey((String)singleDocValue)) || (vocNav = this.vocabularyNavigator.get(vocName)) == null || vocNav.get((String)singleDocValue) <= 0) continue;
                    vocNav.dec((String)singleDocValue);
                }
            }
        }
    }

    public long getURLRetrievalTime() {
        return this.urlRetrievalAllTime;
    }

    public long getSnippetComputationTime() {
        return this.snippetComputationAllTime;
    }

    public ScoreMap<String> getTopicNavigator(int count) {
        if (this.topicNavigatorCount > 0 && count >= 0 && !this.ref.sizeSmaller(2)) {
            ScoreMap<String> result;
            int ic;
            int n = ic = count != 0 ? count : this.topicNavigatorCount;
            if (this.ref.size() <= ic) {
                result = this.getTopics();
            } else {
                result = new ConcurrentScoreMap<String>();
                Iterator<String> it = this.getTopics().keys(false);
                while (ic-- > 0 && it.hasNext()) {
                    String word = it.next();
                    result.set(word, this.ref.get(word));
                }
            }
            return result;
        }
        return null;
    }

    public boolean drainStacksToResult(boolean concurrentSnippetFetch) {
        boolean solrSuccess = this.drainSolrStackToResult(concurrentSnippetFetch);
        boolean rwiSuccess = this.drainRWIStackToResult(concurrentSnippetFetch);
        return solrSuccess || rwiSuccess;
    }

    private boolean drainRWIStackToResult(boolean concurrentSnippetFetch) {
        boolean success = false;
        if (this.snippetFetchAlive.get() >= 10 || MemoryControl.shortStatus() || !concurrentSnippetFetch) {
            URIMetadataNode noderwi = this.pullOneFilteredFromRWI(true);
            if (noderwi != null) {
                this.addResult(this.getSnippet(noderwi, null), noderwi.score());
                success = true;
            }
        } else {
            Thread t = new Thread("SearchEvent.drainStacksToResult.oneFilteredFromRWI"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        SearchEvent.this.oneFeederStarted();
                        try {
                            URIMetadataNode noderwi = SearchEvent.this.pullOneFilteredFromRWI(true);
                            if (noderwi == null) break block9;
                            SearchEvent.this.snippetFetchAlive.incrementAndGet();
                            try {
                                SearchEvent.this.addResult(SearchEvent.this.getSnippet(noderwi, SearchEvent.this.query.snippetCacheStrategy), noderwi.score());
                                SearchEvent.this.snippetFetchAlive.decrementAndGet();
                            }
                            catch (Throwable e) {
                                try {
                                    ConcurrentLog.logException(e);
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    SearchEvent.this.snippetFetchAlive.decrementAndGet();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            SearchEvent.this.oneFeederTerminated();
                        }
                    }
                }
            };
            if (this.query.snippetCacheStrategy == null) {
                t.run();
            } else {
                t.start();
            }
        }
        return success;
    }

    private boolean drainSolrStackToResult(boolean concurrentSnippetFetch) {
        URIMetadataNode node;
        boolean success = false;
        final WeakPriorityBlockingQueue.Element<URIMetadataNode> localEntryElement = this.nodeStack.sizeQueue() > 0 ? this.nodeStack.poll() : null;
        URIMetadataNode uRIMetadataNode = node = localEntryElement == null ? null : localEntryElement.getElement();
        if (node != null) {
            LinkedHashSet<String> solrsnippetlines = this.snippets.remove(ASCII.String(node.hash()));
            if (solrsnippetlines != null && solrsnippetlines.size() > 0) {
                OpensearchResponseWriter.removeSubsumedTitle(solrsnippetlines, node.dc_title());
                TextSnippet solrsnippet = new TextSnippet(node.url(), OpensearchResponseWriter.getLargestSnippet(solrsnippetlines), true, TextSnippet.ResultClass.SOURCE_SOLR, "");
                TextSnippet yacysnippet = new TextSnippet(this.loader, node, this.query.getQueryGoal().getIncludeWordsSet(), this.query.getQueryGoal().getIncludeHashes(), CacheStrategy.CACHEONLY, false, 180, false);
                String solrsnippetline = solrsnippet.descriptionline(this.getQuery().getQueryGoal());
                String yacysnippetline = yacysnippet.descriptionline(this.getQuery().getQueryGoal());
                URIMetadataNode re = node.makeResultEntry(this.query.getSegment(), this.peers, solrsnippetline.length() > yacysnippetline.length() ? solrsnippet : yacysnippet);
                this.addResult(re, localEntryElement.getWeight());
                success = true;
            } else if (this.snippetFetchAlive.get() >= 10 || !concurrentSnippetFetch) {
                this.addResult(this.getSnippet(node, null), localEntryElement.getWeight());
                success = true;
            } else {
                new Thread(this, "SearchEvent.drainStacksToResult.getSnippet"){
                    final /* synthetic */ SearchEvent this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void run() {
                        this.this$0.oneFeederStarted();
                        try {
                            this.this$0.snippetFetchAlive.incrementAndGet();
                            try {
                                this.this$0.addResult(this.this$0.getSnippet(node, this.this$0.query.snippetCacheStrategy), localEntryElement.getWeight());
                                this.this$0.snippetFetchAlive.decrementAndGet();
                            }
                            catch (Throwable throwable) {
                                this.this$0.snippetFetchAlive.decrementAndGet();
                            }
                            catch (Throwable throwable) {
                                this.this$0.snippetFetchAlive.decrementAndGet();
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            this.this$0.oneFeederTerminated();
                        }
                    }
                }.start();
            }
        }
        return success;
    }

    public void addResult(URIMetadataNode resultEntry, long score) {
        if (resultEntry == null) {
            return;
        }
        long ranking = score * 128L + this.postRanking(resultEntry, this.ref);
        resultEntry.setScore(ranking);
        this.resultList.put(new WeakPriorityBlockingQueue.ReverseElement<URIMetadataNode>(resultEntry, ranking));
        if (this.pollImmediately) {
            this.resultList.poll();
        }
        this.addTopics(resultEntry);
    }

    private long postRanking(URIMetadataNode rentry, ScoreMap<String> topwords) {
        int tc;
        long r = 0L;
        switch (this.query.contentdom) {
            case IMAGE: {
                r += (long)(rentry.limage() << this.query.ranking.coeff_cathasimage);
                break;
            }
            case AUDIO: {
                r += (long)(rentry.laudio() << this.query.ranking.coeff_cathasaudio);
                break;
            }
            case VIDEO: {
                r += (long)(rentry.lvideo() << this.query.ranking.coeff_cathasvideo);
                break;
            }
            case APP: {
                r += (long)(rentry.lapp() << this.query.ranking.coeff_cathasapp);
                break;
            }
        }
        if (this.query.getSegment().connectedCitation()) {
            int referencesCount = this.query.getSegment().urlCitation().count(rentry.hash());
            r += (long)(128 * referencesCount / (1 + 2 * rentry.llocal() + rentry.lother()) << this.query.ranking.coeff_citation);
        }
        if (this.query.prefer.matcher(rentry.url().toNormalform(true)).matches()) {
            r += (long)(255 << this.query.ranking.coeff_prefer);
        }
        if (this.query.prefer.matcher(rentry.title()).matches()) {
            r += (long)(255 << this.query.ranking.coeff_prefer);
        }
        String urlstring = rentry.url().toNormalform(true);
        String[] urlcomps = MultiProtocolURL.urlComps(urlstring);
        String[] descrcomps = MultiProtocolURL.splitpattern.split(rentry.title().toLowerCase());
        QueryGoal.NormalizedWords urlcompmap = new QueryGoal.NormalizedWords(urlcomps);
        QueryGoal.NormalizedWords descrcompmap = new QueryGoal.NormalizedWords(descrcomps);
        for (String urlcomp : urlcompmap) {
            tc = topwords.get(urlcomp);
            if (tc <= 0) continue;
            r += (long)(tc << this.query.ranking.coeff_urlcompintoplist);
        }
        for (String descrcomp : descrcompmap) {
            tc = topwords.get(descrcomp);
            if (tc <= 0) continue;
            r += (long)(tc << this.query.ranking.coeff_descrcompintoplist);
        }
        Iterator<String> shi = this.query.getQueryGoal().getIncludeWords();
        while (shi.hasNext()) {
            String queryword = shi.next();
            if (urlcompmap.contains(queryword)) {
                r += (long)(255 << this.query.ranking.coeff_appurl);
            }
            if (!descrcompmap.contains(queryword)) continue;
            r += (long)(255 << this.query.ranking.coeff_app_dc_title);
        }
        return r;
    }

    public URIMetadataNode getSnippet(URIMetadataNode page, CacheStrategy cacheStrategy) {
        if (page == null) {
            return null;
        }
        if (cacheStrategy == null) {
            TextSnippet snippet = new TextSnippet(null, page, this.snippetFetchWords, this.snippetFetchWordHashes, null, this.query.constraint != null && this.query.constraint.get(0), 220, !this.query.isLocal());
            return page.makeResultEntry(this.query.getSegment(), this.peers, snippet);
        }
        Classification.ContentDomain contentDomain = page.getContentDomain();
        if (contentDomain == Classification.ContentDomain.TEXT || contentDomain == Classification.ContentDomain.ALL) {
            ArrayList<String> synonyms;
            long startTime = System.currentTimeMillis();
            TextSnippet snippet = new TextSnippet(this.loader, page, this.snippetFetchWords, this.snippetFetchWordHashes, cacheStrategy, this.query.constraint != null && this.query.constraint.get(0), 180, !this.query.isLocal());
            log.info("text snippet load time for " + page.url().toNormalform(true) + ": " + (System.currentTimeMillis() - startTime) + " ms, " + (String)(!snippet.getErrorCode().fail() ? "snippet found" : "no snippet found (" + snippet.getError() + ")"));
            if (!snippet.getErrorCode().fail()) {
                return page.makeResultEntry(this.query.getSegment(), this.peers, snippet);
            }
            if (cacheStrategy.mustBeOffline()) {
                return page.makeResultEntry(this.query.getSegment(), this.peers, null);
            }
            if (this.snippetFetchWords.contains("yacyall")) {
                return page.makeResultEntry(this.query.getSegment(), this.peers, null);
            }
            String reason = "no text snippet; errorCode = " + String.valueOf((Object)snippet.getErrorCode());
            if (this.deleteIfSnippetFail) {
                this.workTables.failURLsRegisterMissingWord(this.query.getSegment().termIndex(), page.url(), this.query.getQueryGoal().getIncludeHashes());
            }
            if ((synonyms = page.getSynonyms()) != null) {
                Iterator<String> words = this.query.getQueryGoal().getIncludeWords();
                while (words.hasNext()) {
                    String word = words.next().toLowerCase();
                    for (String synonym : synonyms) {
                        if (!synonym.toLowerCase().equals(word)) continue;
                        log.info("accepted url " + page.url().toNormalform(true) + " without snippet: hit in synonyms field");
                        TextSnippet synonym_snippet = new TextSnippet(page.url(), "[Synonym Match]", true, TextSnippet.ResultClass.SOURCE_METADATA, "");
                        return page.makeResultEntry(this.query.getSegment(), this.peers, synonym_snippet);
                    }
                }
            }
            log.info("sorted out url " + page.url().toNormalform(true) + " during search: " + reason);
            return null;
        }
        return page.makeResultEntry(this.query.getSegment(), this.peers, null);
    }

    public URIMetadataNode oneResult(int item, long timeout) {
        long finishTime = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.ONERESULT, "started, item = " + item + ", available = " + this.getResultCount(), 0, 0L), false);
        if (this.localsolrsearch != null && this.localsolrsearch.isAlive()) {
            try {
                this.localsolrsearch.join(100L);
            }
            catch (InterruptedException e) {
                log.warn("Wait for local solr search was interrupted.");
            }
        }
        if (item >= this.localsolroffset && this.local_solr_stored.get() == 0 && this.localsolrsearch != null && this.localsolrsearch.isAlive()) {
            try {
                this.localsolrsearch.join();
            }
            catch (InterruptedException e) {
                log.warn("Wait for local solr search was interrupted.");
            }
        }
        if (this.remote && item >= this.localsolroffset && this.local_solr_stored.get() > item) {
            int nextitems = item - this.localsolroffset + this.query.itemsPerPage;
            if (this.localsolrsearch != null && this.localsolrsearch.isAlive()) {
                try {
                    this.localsolrsearch.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!Switchboard.getSwitchboard().getConfigBool("debug.search.local.solr.off", false)) {
                boolean useSolrFacets = this.localsolrsearch == null;
                boolean incrementNavigators = false;
                this.localsolrsearch = RemoteSearch.solrRemoteSearch(this, this.query.solrQuery(this.query.contentdom, this.query.isStrictContentDom(), useSolrFacets, this.excludeintext_image), this.localsolroffset, nextitems, null, 0, Switchboard.urlBlacklist, useSolrFacets, false);
            }
            this.localsolroffset += nextitems;
        }
        if (this.remote && item < 10 && this.resultList.sizeAvailable() <= item) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.warn("Remote search results wait was interrupted.");
            }
        }
        int resultListIndex = this.remote ? item : item - (this.localsolroffset - this.query.itemsPerPage);
        while (this.resultList.sizeAvailable() <= resultListIndex && (this.rwiQueueSize() > 0 || this.nodeStack.sizeQueue() > 0 || !this.isFeedingFinished() && System.currentTimeMillis() < finishTime)) {
            if (this.drainStacksToResult(true)) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.warn("Search results wait was interrupted.");
            }
        }
        if (this.resultList.sizeAvailable() > resultListIndex) {
            URIMetadataNode re = this.resultList.element(resultListIndex).getElement();
            EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.ONERESULT, "fetched, item = " + item + ", available = " + this.getResultCount() + ": " + re.urlstring(), 0, 0L), false);
            return re;
        }
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(this.query.id(true), SearchEventType.ONERESULT, "not found, item = " + item + ", available = " + this.getResultCount(), 0, 0L), false);
        return null;
    }

    private ImageResult nthImage(int item) {
        Object o = SetTools.nth(this.imageViewed.values(), item);
        if (o == null) {
            return null;
        }
        return (ImageResult)o;
    }

    private boolean hasSpare() {
        return this.imageSpareGood.size() > 0 || this.imageSpareBad.size() > 0;
    }

    private boolean containsSpare(String id) {
        return this.imageSpareGood.containsKey(id) || this.imageSpareBad.containsKey(id);
    }

    private int sizeSpare() {
        return this.imageSpareGood.size() + this.imageSpareBad.size();
    }

    private ImageResult nextSpare() {
        if (this.imageSpareGood.size() > 0) {
            Map.Entry<String, ImageResult> next = this.imageSpareGood.entrySet().iterator().next();
            this.imageViewed.put(next.getKey(), next.getValue());
            this.imageSpareGood.remove(next.getKey());
            return next.getValue();
        }
        if (this.imageSpareBad.size() > 0) {
            Map.Entry<String, ImageResult> next = this.imageSpareBad.entrySet().iterator().next();
            this.imageViewed.put(next.getKey(), next.getValue());
            this.imageSpareBad.remove(next.getKey());
            return next.getValue();
        }
        return null;
    }

    public ImageResult oneImageResult(int item, long timeout, boolean strictContentDom) throws MalformedURLException {
        block12: {
            URIMetadataNode doc;
            block11: {
                int w;
                if (item < this.imageViewed.size()) {
                    return this.nthImage(item);
                }
                if (this.imageSpareGood.size() > 0) {
                    return this.nextSpare();
                }
                if ((doc = this.oneResult(this.imagePageCounter++, timeout)) == null) {
                    if (this.hasSpare()) {
                        return this.nextSpare();
                    }
                    throw new MalformedURLException("no image url found");
                }
                if (doc.doctype() != 'i') break block11;
                if (doc.url().getFileName().endsWith(".ico")) break block12;
                String id = ASCII.String(doc.hash());
                Collection height = doc.getFieldValues(CollectionSchema.images_height_val.getSolrFieldName());
                Collection width = doc.getFieldValues(CollectionSchema.images_width_val.getSolrFieldName());
                int h = height == null ? 0 : (Integer)height.iterator().next();
                int n = w = width == null ? 0 : (Integer)width.iterator().next();
                if (h > 0 && h <= 16 || w > 0 && w <= 16 || this.imageViewed.containsKey(id) || this.containsSpare(id)) break block12;
                this.imageSpareGood.put(id, new ImageResult(doc.url(), doc.url(), doc.mime(), doc.title(), w, h, 0));
                break block12;
            }
            if (!strictContentDom) {
                Collection altO = doc.getFieldValues(CollectionSchema.images_alt_sxt.getSolrFieldName());
                Collection imgO = doc.getFieldValues(CollectionSchema.images_urlstub_sxt.getSolrFieldName());
                if (imgO != null && imgO.size() > 0 && imgO instanceof List) {
                    List alt = altO == null ? null : (List)altO;
                    List img = (List)imgO;
                    List<String> prt = CollectionConfiguration.indexedList2protocolList(doc.getFieldValues(CollectionSchema.images_protocol_sxt.getSolrFieldName()), img.size());
                    Collection heightO = doc.getFieldValues(CollectionSchema.images_height_val.getSolrFieldName());
                    Collection widthO = doc.getFieldValues(CollectionSchema.images_width_val.getSolrFieldName());
                    List height = heightO == null ? null : (List)heightO;
                    List width = widthO == null ? null : (List)widthO;
                    for (int c = 0; c < img.size(); ++c) {
                        String image_urlstub = (String)img.get(c);
                        if (image_urlstub.endsWith(".ico")) continue;
                        try {
                            boolean match;
                            DigestURL imageUrl;
                            String id;
                            int w;
                            int h = height == null ? 0 : (Integer)height.get(c);
                            int n = w = width == null ? 0 : (Integer)width.get(c);
                            if (h > 0 && h <= 16 || w > 0 && w <= 16 || this.imageViewed.containsKey(id = ASCII.String((imageUrl = new DigestURL((prt != null && prt.size() > c ? prt.get(c) : "http") + "://" + image_urlstub)).hash())) || this.containsSpare(id)) continue;
                            String image_alt = alt != null && alt.size() > c ? (String)alt.get(c) : "";
                            ImageResult imageResult = new ImageResult(doc.url(), imageUrl, "", image_alt, w, h, 0);
                            boolean bl = match = this.query.getQueryGoal().matches(image_urlstub) || this.query.getQueryGoal().matches(image_alt);
                            if (match) {
                                this.imageSpareGood.put(id, imageResult);
                                continue;
                            }
                            this.imageSpareBad.put(id, imageResult);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.hasSpare()) {
            return this.nextSpare();
        }
        throw new MalformedURLException("no image url found");
    }

    public ArrayList<WeakPriorityBlockingQueue.Element<URIMetadataNode>> completeResults(long waitingtime) {
        URIMetadataNode re;
        long timeout = waitingtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + waitingtime;
        int i = 0;
        while (this.resultList.sizeAvailable() < this.query.neededResults() && System.currentTimeMillis() < timeout && (re = this.oneResult(i++, timeout - System.currentTimeMillis())) != null) {
        }
        return this.resultList.list(Math.min(this.query.neededResults(), this.resultList.sizeAvailable()));
    }

    public void resortCachedResults() {
        if (this.isFeedingFinished() && this.resortCacheAllowed.tryAcquire()) {
            this.resultList.requeueDrainedElements();
            WeakPriorityBlockingQueue.Element<URIMetadataNode> initialLastResult = this.resultList.getLastInQueue();
            boolean drained = this.drainSolrStackToResult(false);
            WeakPriorityBlockingQueue.Element<URIMetadataNode> newLastResult = this.resultList.getLastInQueue();
            while (drained && newLastResult == initialLastResult) {
                drained = this.drainSolrStackToResult(false);
                newLastResult = this.resultList.getLastInQueue();
            }
            drained = this.drainRWIStackToResult(false);
            newLastResult = this.resultList.getLastInQueue();
            while (drained && newLastResult == initialLastResult) {
                drained = this.drainRWIStackToResult(false);
                newLastResult = this.resultList.getLastInQueue();
            }
        }
    }

    protected boolean delete(String urlhash) {
        Iterator<WeakPriorityBlockingQueue.Element<URIMetadataNode>> i = this.resultList.iterator();
        while (i.hasNext()) {
            WeakPriorityBlockingQueue.Element<URIMetadataNode> entry2 = i.next();
            if (!urlhash.equals(ASCII.String(entry2.getElement().url().hash()))) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public ReferenceOrder getOrder() {
        return this.order;
    }

    public boolean isFeedingFinished() {
        return this.feedersTerminated.intValue() > (this.remote ? 1 : 0) && this.feedersAlive.get() == 0;
    }

    public void oneFeederTerminated() {
        this.feedersTerminated.incrementAndGet();
        int c = this.feedersAlive.decrementAndGet();
        assert (c >= 0) : "feeders = " + c;
    }

    public void oneFeederStarted() {
        this.feedersAlive.incrementAndGet();
    }

    public QueryParams getQuery() {
        return this.query;
    }

    public int[] flagCount() {
        return this.flagcount;
    }

    protected void addBegin() {
        this.addRunning = true;
    }

    public void addFinalize() {
        this.addRunning = false;
    }

    protected boolean addRunning() {
        return this.addRunning;
    }

    public boolean rwiIsEmpty() {
        if (!this.rwiStack.isEmpty()) {
            return false;
        }
        for (WeakPriorityBlockingQueue<WordReferenceVars> s : this.doubleDomCache.values()) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected int rwiQueueSize() {
        int c = this.rwiStack.sizeQueue();
        for (WeakPriorityBlockingQueue<WordReferenceVars> s : this.doubleDomCache.values()) {
            c += s.sizeQueue();
        }
        return c;
    }

    protected boolean testFlags(Bitfield flags) {
        if (this.query.constraint == null) {
            return true;
        }
        if (this.query.allofconstraint) {
            for (int i = 0; i < 32; ++i) {
                if (!this.query.constraint.get(i) || flags.get(i)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < 32; ++i) {
            if (!this.query.constraint.get(i) || !flags.get(i)) continue;
            return true;
        }
        return false;
    }

    protected Map<byte[], ReferenceContainer<WordReference>> searchContainerMap() {
        return this.localSearchInclusion;
    }

    public ScoreMap<String> getTopics() {
        return this.ref;
    }

    public void addTopic(String[] words) {
        for (String w : words) {
            String word = w.toLowerCase();
            if (word.length() <= 2 || "http_html_php_ftp_www_com_org_net_gov_edu_index_home_page_for_usage_the_and_zum_der_die_das_und_the_zur_bzw_mit_blog_wiki_aus_bei_off".indexOf(word) >= 0 || this.query.getQueryGoal().containsInclude(word) || !lettermatch.matcher(word).matches() || Switchboard.badwords.contains(word) || Switchboard.stopwords.contains(word)) continue;
            this.ref.inc(word);
        }
    }

    protected void addTopics(URIMetadataNode resultEntry) {
        if (resultEntry.url() == null || resultEntry.title() == null) {
            return;
        }
        String[] descrcomps = MultiProtocolURL.splitpattern.split(resultEntry.title());
        this.addTopic(descrcomps);
    }

    private class RWIProcess
    extends Thread {
        final Thread waitForThread;

        public RWIProcess(Thread waitForThread) {
            super("SearchEvent.RWIProcess(" + (waitForThread != null ? waitForThread.getName() : "") + ")");
            this.waitForThread = waitForThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SearchEvent.this.query.getSegment().termIndex() == null) {
                return;
            }
            SearchEvent.this.oneFeederStarted();
            try {
                long timer = System.currentTimeMillis();
                TermSearch<WordReference> search2 = SearchEvent.this.query.getSegment().termIndex().query(SearchEvent.this.query.getQueryGoal().getIncludeHashes(), SearchEvent.this.query.getQueryGoal().getExcludeHashes(), null, Segment.wordReferenceFactory, SearchEvent.this.query.maxDistance);
                SearchEvent.this.localSearchInclusion = search2.inclusion();
                ReferenceContainer<WordReference> index2 = search2.joined();
                if (!index2.isEmpty()) {
                    int successcount;
                    if (this.waitForThread != null && this.waitForThread.isAlive()) {
                        this.waitForThread.join();
                    }
                    if ((successcount = SearchEvent.this.addRWIs(index2, true, "local index: " + String.valueOf(SearchEvent.this.query.getSegment().getLocation()), index2.size(), SearchEvent.this.maxtime)) == 0 && SearchEvent.this.query.getQueryGoal().getIncludeHashes().has(Segment.catchallHash) && SearchEvent.this.query.modifier.sitehost != null && SearchEvent.this.query.modifier.sitehost.length() > 0) {
                        String newGoal = Domains.getSmartSLD(SearchEvent.this.query.modifier.sitehost);
                        search2 = SearchEvent.this.query.getSegment().termIndex().query(QueryParams.hashes2Set(ASCII.String(Word.word2hash(newGoal))), SearchEvent.this.query.getQueryGoal().getExcludeHashes(), null, Segment.wordReferenceFactory, SearchEvent.this.query.maxDistance);
                        SearchEvent.this.localSearchInclusion = search2.inclusion();
                        index2 = search2.joined();
                        if (!index2.isEmpty()) {
                            successcount = SearchEvent.this.addRWIs(index2, true, "local index: " + String.valueOf(SearchEvent.this.query.getSegment().getLocation()), index2.size(), SearchEvent.this.maxtime);
                        }
                    }
                    EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(SearchEvent.this.query.id(true), SearchEventType.JOIN, SearchEvent.this.query.getQueryGoal().getQueryString(false), successcount, System.currentTimeMillis() - timer), false);
                    SearchEvent.this.addFinalize();
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            finally {
                SearchEvent.this.oneFeederTerminated();
            }
        }
    }

    public class ImageResult {
        public DigestURL imageUrl;
        public DigestURL sourceUrl;
        public String mimetype = "";
        public String imagetext = "";
        public int width = 0;
        public int height = 0;
        public int fileSize = 0;

        public ImageResult(DigestURL sourceUrl, DigestURL imageUrl, String mimetype, String imagetext, int width, int height, int fileSize) {
            this.sourceUrl = sourceUrl;
            this.imageUrl = imageUrl;
            this.mimetype = mimetype;
            this.imagetext = imagetext.isEmpty() ? imageUrl.getFileName() : imagetext;
            this.width = width;
            this.height = height;
            this.fileSize = fileSize;
        }

        public String toString() {
            return this.imageUrl.toNormalform(false);
        }
    }
}

