/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.feed.Hit;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;
import net.yacy.visualization.SkylinePlotter;

public final class NetworkSkylineGraph {
    private static final double DOUBLE_LONG_MAX_VALUE = 9.223372036854776E18;
    private static final long SKYLINE_BACKGROUND = 17L;
    private static final long GRID_COLOR = 49407L;
    private static final long COL_ACTIVE_BUILDING = 26342L;
    private static final long COL_PASSIVE_BUILDING = 2837120L;
    private static final long COL_POTENTIAL_BUILDING = 2382909L;
    private static final long COL_SELF = 0xFF3355L;
    private static final long COL_RUNWAY = 0x103030L;
    private static final long COL_ACTIVE_TEXT = 0x77CCFFL;
    private static final long COL_PASSIVE_TEXT = 10402012L;
    private static final long COL_POTENTIAL_TEXT = 8378283L;
    private static final long COL_SELF_TEXT = 16766688L;
    private static final long COL_BEAM_IN = 5046152L;
    private static final long COL_BEAM_OUT = 0xFF7766L;
    private static final int BASE_PASSIVE_LIMIT = 60;
    private static final int BASE_POTENTIAL_LIMIT = 240;

    private NetworkSkylineGraph() {
    }

    public static SkylinePlotter getNetworkSkylinePicture(SeedDB seedDB, int width, int height, int passiveLimit, int potentialLimit, int maxCount, int coronaAngle, long communicationTimeout, String networkName, String networkTitle, long backgroundColor, int cyc) {
        SkylinePlotter.SkylineConfig config = new SkylinePlotter.SkylineConfig();
        config.width = width;
        config.height = height;
        config.backgroundColor = backgroundColor != 0L ? backgroundColor : 17L;
        config.gridColor = 49407L;
        config.gridIntensity = 40;
        config.gridPulse = 10;
        config.gridStepX = 28.0;
        config.gridStepZ = 36.0;
        config.fieldWidth = 460.0;
        config.fieldDepth = 680.0;
        config.focalLength = 580.0;
        config.cameraDepth = 150.0;
        config.groundLevel = 220.0;
        config.horizonY = height / 3;
        SkylinePlotter skyline = new SkylinePlotter(config);
        skyline.clearScene();
        HashMap<String, Placement> placements = new HashMap<String, Placement>();
        HashSet<String> seen = new HashSet<String>();
        if (seedDB != null && seedDB.mySeed() != null && seedDB.mySeed().hash != null) {
            seen.add(seedDB.mySeed().hash);
        }
        skyline.addBox(0.0, config.fieldDepth - 60.0, config.fieldWidth * 1.4, 90.0, -20.0, 16.0, 0x103030L).edges(RasterPlotter.lighten(0x103030L, 1.4)).intensity(55).dotted(4).label("DATAPLANE", -30, 22).labelIntensity(60).labelColor(RasterPlotter.lighten(0x103030L, 2.4));
        int totalCount = 0;
        if (seedDB != null) {
            Placement placement;
            totalCount += NetworkSkylineGraph.plotPeers(skyline, placements, seen, seedDB.seedsConnected(true, false, null, 0.0), maxCount, PeerTier.ACTIVE, 150.0, 90.0, passiveLimit, false);
            totalCount += NetworkSkylineGraph.plotPeers(skyline, placements, seen, seedDB.seedsSortedDisconnected(false, "LastSeen"), maxCount, PeerTier.PASSIVE, 220.0, 110.0, passiveLimit > 0 ? passiveLimit : 60, true);
            totalCount += NetworkSkylineGraph.plotPeers(skyline, placements, seen, seedDB.seedsSortedPotential(false, "LastSeen"), maxCount, PeerTier.POTENTIAL, 310.0, 130.0, potentialLimit > 0 ? potentialLimit : 240, true);
            Seed self = seedDB.mySeed();
            if (self != null && (placement = NetworkSkylineGraph.plotSelfPeer(skyline, placements, seen, self)) != null) {
                ++totalCount;
            }
            NetworkSkylineGraph.addCommunicationBeams(skyline, placements, seedDB, communicationTimeout);
        }
        int frameIndex = (cyc % 360 + 360) % 360 / 45;
        skyline.renderFrame(frameIndex);
        long headlineColor = RasterPlotter.lighten(config.gridColor, 1.2);
        skyline.setColor(headlineColor);
        String name = networkName == null ? "UNSPECIFIED" : networkName.toUpperCase();
        String title = networkTitle == null ? "" : networkTitle.toUpperCase();
        PrintTool.print5(skyline, 2, 6, 0, "YACY SKYLINE '" + name + "'", -1, 100);
        PrintTool.print5(skyline, 2, 14, 0, title, -1, 80);
        PrintTool.print5(skyline, width - 2, 6, 0, "SNAPSHOT " + new Date().toString().toUpperCase(), 1, 80);
        PrintTool.print5(skyline, width - 2, 14, 0, "RENDERED " + totalCount + " PEERS", 1, 80);
        return skyline;
    }

    private static int plotPeers(SkylinePlotter skyline, Map<String, Placement> placements, Set<String> seen, Iterator<Seed> iterator, int maxCount, PeerTier tier, double baseZ, double baseWidth, int timeLimitMinutes, boolean limitLastSeen) {
        if (iterator == null) {
            return 0;
        }
        int count = 0;
        while (iterator.hasNext() && count < maxCount) {
            long minutes;
            Seed seed = iterator.next();
            if (seed == null) {
                ConcurrentLog.warn("NetworkSkylineGraph", String.valueOf((Object)tier) + " seed == null");
                continue;
            }
            String hash = seed.hash;
            if (hash == null || hash.length() == 0 || hash.startsWith("AD") || !seen.add(hash) || limitLastSeen && (minutes = Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 60000L)) > (long)timeLimitMinutes) continue;
            Placement placement = NetworkSkylineGraph.createPlacement(skyline, seed, tier, baseZ, baseWidth);
            placements.put(hash, placement);
            ++count;
        }
        return count;
    }

    private static Placement createPlacement(SkylinePlotter skyline, Seed seed, PeerTier tier, double zBase, double footprint) {
        SkylinePlotter.SkylineConfig config = skyline.getConfig();
        long hashValue = Distribution.horizontalDHTPosition(ASCII.getBytes(seed.hash));
        double normalized = (double)hashValue / 9.223372036854776E18;
        double jitter = (double)((seed.hash.hashCode() & 0x1FF) - 256) * 0.12;
        double x = (normalized - 0.5) * config.fieldWidth * 0.9 + jitter;
        double depthJitter = (seed.hash.hashCode() >> 9 & 0x3F) - 32;
        double z = zBase + depthJitter;
        long links = Math.max(1L, seed.getLinkCount());
        double ppm = Math.max(0, seed.getPPM());
        double qpm = Math.max(0.0, (double)seed.getQPM());
        double height = NetworkSkylineGraph.computeHeight(links, ppm, qpm, tier);
        double baseHeight = Math.max(-4.0, Math.min(30.0, Math.log10((double)links + 1.0) * 4.0));
        long color = tier.color;
        long accent = RasterPlotter.lighten(color, 1.35);
        long edges = RasterPlotter.lighten(color, 1.6);
        SkylinePlotter.SkylineObject object = skyline.addBox(x, z, footprint, footprint * 0.7, baseHeight, height, color);
        String name = NetworkSkylineGraph.safePeerName(seed);
        int labelOffsetX = -Math.max(10, name.length() * 3);
        int labelOffsetY = (int)(-height / 4.0) - 10;
        object.accent(accent).edges(edges).intensity(80).bob(Math.min(18.0, ppm * tier.bobFactor / 18.0)).pulse(Math.min(16.0, qpm * tier.pulseFactor)).dotted(tier.patternModulo).patternPhase(Math.abs(seed.hash.hashCode() % 360)).animationPhase((seed.hash.hashCode() & 0x1FF) % 360).label(name, labelOffsetX, labelOffsetY).labelColor(tier.textColor).labelIntensity(90);
        return new Placement(x, z, baseHeight, height);
    }

    private static Placement plotSelfPeer(SkylinePlotter skyline, Map<String, Placement> placements, Set<String> seen, Seed self) {
        String hash = self.hash;
        if (hash == null || hash.length() == 0) {
            return null;
        }
        seen.add(hash);
        SkylinePlotter.SkylineConfig config = skyline.getConfig();
        long hashValue = Distribution.horizontalDHTPosition(ASCII.getBytes(hash));
        double normalized = (double)hashValue / 9.223372036854776E18;
        double x = (normalized - 0.5) * config.fieldWidth * 0.6;
        double z = 120.0;
        double diameter = 140.0;
        double baseHeight = 8.0;
        SkylinePlotter.SkylineObject sphere = skyline.addSphere(x, 120.0, 140.0, 8.0, 0xFF3355L);
        String name = NetworkSkylineGraph.safePeerName(self);
        sphere.accent(RasterPlotter.lighten(0xFF3355L, 1.4)).intensity(90).bob(20.0).pulse(14.0).animationPhase(180.0).label(name, -Math.max(36, name.length() * 3), -30).labelColor(16766688L);
        Placement placement = new Placement(x, 120.0, 8.0, 140.0);
        placements.put(hash, placement);
        return placement;
    }

    private static void addCommunicationBeams(SkylinePlotter skyline, Map<String, Placement> placements, SeedDB seedDB, long communicationTimeout) {
        if (communicationTimeout < 0L || seedDB == null) {
            return;
        }
        Seed self = seedDB.mySeed();
        if (self == null) {
            return;
        }
        Placement selfPlacement = placements.get(self.hash);
        if (selfPlacement == null) {
            return;
        }
        Date horizon = new Date(System.currentTimeMillis() - communicationTimeout);
        NetworkSkylineGraph.addChannelBeams(skyline, placements, seedDB, selfPlacement, horizon, EventChannel.DHTRECEIVE, 5046152L, false);
        NetworkSkylineGraph.addChannelBeams(skyline, placements, seedDB, selfPlacement, horizon, EventChannel.DHTSEND, 0xFF7766L, true);
    }

    private static void addChannelBeams(SkylinePlotter skyline, Map<String, Placement> placements, SeedDB seedDB, Placement selfPlacement, Date horizon, EventChannel channel, long color, boolean outgoing) {
        RSSFeed events = EventChannel.channels(channel);
        if (events == null) {
            return;
        }
        for (Hit event : events) {
            Placement otherPlacement;
            Seed other;
            String link;
            if (event == null || event.getPubDate() == null || event.getPubDate().before(horizon) || (link = event.getLink()) == null || (other = seedDB.get(link)) == null || (otherPlacement = placements.get(other.hash)) == null) continue;
            Placement source = outgoing ? selfPlacement : otherPlacement;
            Placement target = outgoing ? otherPlacement : selfPlacement;
            SkylinePlotter.SkylineBeam beam = skyline.addBeam(source.x, source.top() + 6.0, source.z, target.x, target.top() + 6.0, target.z, color);
            beam.intensity(88).pulse(12.0).dotted(6).patternPhase(Math.abs(link.hashCode()) % 360).animationPhase((link.hashCode() & 0x1FF) % 360);
        }
    }

    private static double computeHeight(long links, double ppm, double qpm, PeerTier tier) {
        double linkFactor = Math.min(180.0, Math.log10((double)links + 1.0) * 22.0);
        double crawlFactor = Math.min(60.0, ppm * tier.bobFactor / 8.0);
        double queryFactor = Math.min(48.0, qpm * tier.pulseFactor * 1.5);
        return 40.0 + linkFactor + crawlFactor + queryFactor;
    }

    private static String safePeerName(Seed seed) {
        if (seed == null) {
            return "UNKNOWN";
        }
        String name = seed.getName();
        if (name == null || name.length() == 0) {
            return "UNKNOWN";
        }
        return name.toUpperCase();
    }

    private static enum PeerTier {
        ACTIVE(26342L, 0x77CCFFL, 0.75, 0.2, 6),
        PASSIVE(2837120L, 10402012L, 0.4, 0.12, 0),
        POTENTIAL(2382909L, 8378283L, 0.25, 0.08, 8),
        SELF(0xFF3355L, 16766688L, 0.9, 0.3, 0);

        final long color;
        final long textColor;
        final double bobFactor;
        final double pulseFactor;
        final int patternModulo;

        private PeerTier(long color, long textColor, double bobFactor, double pulseFactor, int patternModulo) {
            this.color = color;
            this.textColor = textColor;
            this.bobFactor = bobFactor;
            this.pulseFactor = pulseFactor;
            this.patternModulo = patternModulo;
        }
    }

    private static final class Placement {
        final double x;
        final double z;
        final double base;
        final double height;

        Placement(double x, double z, double base, double height) {
            this.x = x;
            this.z = z;
            this.base = base;
            this.height = height;
        }

        double top() {
            return this.base + this.height;
        }
    }
}

