/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.NamePrefixThreadFactory;
import net.yacy.kelondro.workflow.InstantBlockingThread;
import net.yacy.kelondro.workflow.WorkflowJob;
import net.yacy.kelondro.workflow.WorkflowTask;

public class WorkflowProcessor<J extends WorkflowJob> {
    public static final int availableCPU = Runtime.getRuntime().availableProcessors();
    private static final ArrayList<WorkflowProcessor<?>> processMonitor = new ArrayList();
    private ExecutorService executor;
    private AtomicInteger executorRunning;
    private BlockingQueue<J> input;
    private final WorkflowProcessor<J> output;
    private final int maxpoolsize;
    private final WorkflowTask<J> task;
    private final String processName;
    private final String description;
    private final String[] childs;
    private long blockTime;
    private long execTime;
    private long passOnTime;
    private long execCount;

    public WorkflowProcessor(String name, String description, String[] childnames, WorkflowTask<J> task, int inputQueueSize, WorkflowProcessor<J> output, int maxpoolsize) {
        this.processName = name;
        this.description = description;
        this.task = task;
        this.childs = childnames;
        this.maxpoolsize = maxpoolsize;
        this.input = new LinkedBlockingQueue<J>(Math.max(maxpoolsize + 1, inputQueueSize));
        this.output = output;
        this.executor = Executors.newCachedThreadPool(new NamePrefixThreadFactory(name));
        this.executorRunning = new AtomicInteger(0);
        this.blockTime = 0L;
        this.execTime = 0L;
        this.passOnTime = 0L;
        this.execCount = 0L;
        processMonitor.add(this);
    }

    public WorkflowTask<J> getTask() {
        return this.task;
    }

    public int getQueueSize() {
        if (this.input == null) {
            return 0;
        }
        return this.input.size();
    }

    public boolean queueIsEmpty() {
        return this.input == null || this.input.isEmpty();
    }

    public int getMaxQueueSize() {
        if (this.input == null) {
            return 0;
        }
        return this.input.size() + this.input.remainingCapacity();
    }

    public int getMaxConcurrency() {
        return this.maxpoolsize;
    }

    public int getExecutors() {
        return this.executorRunning.get();
    }

    public void decExecutors() {
        this.executorRunning.decrementAndGet();
    }

    public J take() throws InterruptedException {
        if (this.input == null) {
            return null;
        }
        long t = System.currentTimeMillis();
        WorkflowJob j = (WorkflowJob)this.input.take();
        this.blockTime += System.currentTimeMillis() - t;
        return (J)j;
    }

    public void passOn(J next) {
        if (this.output == null) {
            return;
        }
        long t = System.currentTimeMillis();
        this.output.enQueue(next);
        this.passOnTime += System.currentTimeMillis() - t;
    }

    public void clear() {
        if (this.input != null) {
            this.input.clear();
        }
    }

    private synchronized void relaxCapacity() {
        WorkflowJob e;
        if (this.input.isEmpty()) {
            return;
        }
        if (this.input.remainingCapacity() > 1000) {
            return;
        }
        LinkedBlockingQueue<J> i = new LinkedBlockingQueue<J>();
        while (!this.input.isEmpty() && (e = (WorkflowJob)this.input.poll()) != null) {
            i.add(e);
        }
        this.input = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enQueue(J in) {
        if (this.input == null || this.executor == null || this.executor.isShutdown() || this.executor.isTerminated()) {
            try {
                WorkflowJob out = (WorkflowJob)this.task.process(in);
                if (out != null && this.output != null) {
                    this.output.enQueue(out);
                }
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
            return;
        }
        int failcount = 0;
        while (this.input != null && failcount < 10) {
            try {
                this.input.put(in);
                if (this.input.size() <= this.executorRunning.get() || this.executorRunning.get() >= this.maxpoolsize) break;
                ExecutorService executorService = this.executor;
                synchronized (executorService) {
                    if (this.input.size() > this.executorRunning.get() && this.executorRunning.get() < this.maxpoolsize) {
                        this.executorRunning.incrementAndGet();
                        this.executor.submit(new InstantBlockingThread(this));
                    }
                    break;
                }
            }
            catch (Throwable e) {
                ++failcount;
                ConcurrentLog.logException(e);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void shutdown() {
        int i;
        if (this.executor == null) {
            return;
        }
        if (this.executor.isShutdown()) {
            return;
        }
        this.relaxCapacity();
        for (i = 0; i < this.executorRunning.get(); ++i) {
            try {
                ConcurrentLog.info("serverProcessor", "putting poison pill in queue " + this.processName + ", thread " + i);
                this.input.put(WorkflowJob.poisonPill);
                ConcurrentLog.info("serverProcessor", ".. poison pill is in queue " + this.processName + ", thread " + i + ". awaiting termination");
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (i = 0; i < 10 && this.input.size() > 0; ++i) {
            ConcurrentLog.info("WorkflowProcess", "waiting for queue " + this.processName + " to shut down; input.size = " + this.input.size());
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.executorRunning.set(0);
        if (this.executor != null & !this.executor.isShutdown()) {
            try {
                this.executor.shutdown();
                for (i = 0; i < 60; ++i) {
                    this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                    if (this.input.size() > 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
        }
        ConcurrentLog.info("serverProcessor", "queue " + this.processName + ": shutdown.");
        this.executor = null;
        this.input = null;
        Iterator<WorkflowProcessor<?>> i3 = WorkflowProcessor.processes();
        while (i3.hasNext()) {
            WorkflowProcessor<?> p = i3.next();
            if (p != this) continue;
            i3.remove();
            break;
        }
    }

    public static Iterator<WorkflowProcessor<?>> processes() {
        return processMonitor.iterator();
    }

    protected void increaseJobTime(long time) {
        this.execTime += time;
        ++this.execCount;
    }

    public String getName() {
        return this.processName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getChilds() {
        StringBuilder s = new StringBuilder(this.childs.length * 40 + 1);
        for (String child : this.childs) {
            s.append(child);
            s.append(' ');
        }
        return s.toString();
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public long getExecCount() {
        return this.execCount;
    }

    public long getPassOnTime() {
        return this.passOnTime;
    }
}

