/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.yacy.kelondro.util.MemoryStrategy;

public class GenerationMemoryStrategy
extends MemoryStrategy {
    private static final long M = 0x100000L;
    private MemoryPoolMXBean eden;
    private MemoryPoolMXBean survivor;
    private MemoryPoolMXBean old;
    private MemoryMXBean heap;

    public GenerationMemoryStrategy() {
        name = "Generation Memory Strategy";
        error = this.initPoolBeans();
        this.heap = ManagementFactory.getMemoryMXBean();
        if (lastGC == 0L) {
            this.gc(10000, "initial gc - to get proper results");
        }
        if (error) {
            log.warn(name + ": not a generational heap");
        }
    }

    @Override
    protected final long free() {
        return this.youngAvailable();
    }

    @Override
    protected final long available() {
        return this.available(false);
    }

    private final long available(boolean force) {
        return force & this.properState(force) ? Math.max(this.youngAvailable(), this.oldAvailable()) : this.oldAvailable();
    }

    @Override
    protected final long used() {
        return this.heap.getHeapMemoryUsage().getUsed();
    }

    @Override
    protected final long total() {
        return this.heap.getHeapMemoryUsage().getCommitted();
    }

    @Override
    protected final long maxMemory() {
        return this.heap.getHeapMemoryUsage().getMax();
    }

    protected final long minMemory() {
        return this.getUsage(this.eden, true).getUsed();
    }

    @Override
    protected final boolean request(long size, boolean force, AtomicBoolean shortStatus) {
        boolean unknown;
        if (size == 0L) {
            return true;
        }
        boolean bl = unknown = size < 0L;
        boolean r = unknown ? this.properState(force) : size < this.available(force);
        shortStatus.set(!r);
        return r;
    }

    private final long youngAvailable() {
        MemoryUsage usage = this.getUsage(this.eden, true);
        return usage.getCommitted() - usage.getUsed();
    }

    private final long oldAvailable() {
        MemoryUsage usage = this.getUsage(this.old, true);
        return Math.max(usage.getMax(), usage.getCommitted()) - usage.getUsed();
    }

    @Override
    protected boolean properState() {
        return this.properState(false);
    }

    private boolean properState(boolean force) {
        long surv = force ? 0x100000L + this.getUsage(this.survivor, false).getUsed() : this.getUsage(this.survivor, false).getCommitted();
        return surv < this.oldAvailable();
    }

    protected long recommendHeapSize() {
        double factor = 1.2 * (double)this.heap.getHeapMemoryUsage().getMax() / (double)this.getUsage(this.old, false).getMax();
        long neededOld = this.getUsage(this.old, true).getUsed() + this.getUsage(this.survivor, false).getMax();
        return (long)((double)neededOld * factor);
    }

    private MemoryUsage getUsage(MemoryPoolMXBean bean, boolean collected) {
        if (collected) {
            try {
                MemoryUsage usage = bean.getCollectionUsage();
                if (usage != null) {
                    return usage;
                }
            }
            catch (IllegalArgumentException e) {
                log.warn(name + ": ", e);
            }
            error = true;
            log.warn(name + ": no colletion usage available at " + bean.getName());
        }
        return bean.getUsage();
    }

    private boolean initPoolBeans() {
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (bean.getName().startsWith("G1")) break;
            if (bean.getName().contains("Eden")) {
                this.eden = bean;
                continue;
            }
            if (bean.getName().contains("Survivor")) {
                this.survivor = bean;
                continue;
            }
            if (!bean.getName().contains("Old") && !bean.getName().contains("Tenured")) continue;
            this.old = bean;
        }
        return this.eden == null || this.survivor == null || this.old == null;
    }
}

