/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.logging.ConsoleOutHandler;

public final class ConsoleOutErrHandler
extends Handler {
    private boolean ignoreCtrlChr = false;
    private Level splitLevel = Level.WARNING;
    private final Handler stdOutHandler = new ConsoleOutHandler();
    private final Handler stdErrHandler = new ConsoleHandler();

    public ConsoleOutErrHandler() {
        this.stdOutHandler.setLevel(Level.FINEST);
        this.stdErrHandler.setLevel(Level.WARNING);
        this.configure();
    }

    private void configure() {
        String className;
        LogManager manager = LogManager.getLogManager();
        String level = manager.getProperty((className = this.getClass().getName()) + ".level");
        this.setLevel(level == null ? Level.INFO : Level.parse(level));
        Level levelStdOut = this.parseLevel(manager.getProperty(className + ".levelStdOut"));
        Level levelSplit = this.parseLevel(manager.getProperty(className + ".levelSplit"));
        Level levelStdErr = this.parseLevel(manager.getProperty(className + ".levelStdErr"));
        this.setLevels(levelStdOut, levelSplit, levelStdErr);
        String filter = manager.getProperty(className + ".filter");
        this.setFilter(this.makeFilter(filter));
        String formatter = manager.getProperty(className + ".formatter");
        this.setFormatter(this.makeFormatter(formatter));
        String encoding = manager.getProperty(className + ".encoding");
        try {
            this.stdOutHandler.setEncoding(encoding);
            this.stdErrHandler.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ConcurrentLog.logException(e);
        }
        String ignoreCtrlChrStr = manager.getProperty(className + ".ignoreCtrlChr");
        this.ignoreCtrlChr = ignoreCtrlChrStr == null ? false : "true".equalsIgnoreCase(ignoreCtrlChrStr);
    }

    private Level parseLevel(String levelName) {
        try {
            return levelName == null ? Level.INFO : Level.parse(levelName);
        }
        catch (Exception e) {
            return Level.ALL;
        }
    }

    private Filter makeFilter(String name) {
        Filter f;
        block3: {
            if (name == null) {
                return null;
            }
            f = null;
            try {
                Class<?> c = Class.forName(name);
                f = (Filter)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (name == null) break block3;
                System.err.println("Unable to load filter: " + name);
            }
        }
        return f;
    }

    private Formatter makeFormatter(String name) {
        if (name == null) {
            return null;
        }
        Formatter f = null;
        try {
            Class<?> c = Class.forName(name);
            f = (Formatter)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            f = new SimpleFormatter();
        }
        return f;
    }

    @Override
    public final void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (this.ignoreCtrlChr) {
            String msg = record.getMessage();
            if (msg != null) {
                msg = msg.replaceAll("[\u0000-\b\u000b\f\u000e-\u001f]", " ");
            }
            record.setMessage(msg);
        }
        if (record.getLevel().intValue() >= this.splitLevel.intValue()) {
            this.stdOutHandler.publish(record);
            this.stdOutHandler.flush();
            this.stdErrHandler.publish(record);
            this.stdErrHandler.flush();
        } else {
            this.stdOutHandler.publish(record);
        }
    }

    @Override
    public void flush() {
        this.stdOutHandler.flush();
        this.stdErrHandler.flush();
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.stdOutHandler.close();
        this.stdErrHandler.close();
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
    }

    public void setLevels(Level stdOutLevel, Level splitLevel, Level stdErrLevel) throws SecurityException {
        this.stdOutHandler.setLevel(stdOutLevel);
        this.splitLevel = splitLevel;
        this.stdErrHandler.setLevel(stdErrLevel);
    }

    @Override
    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
        if (newFormatter == null) {
            return;
        }
        try {
            this.stdOutHandler.setFormatter((Formatter)newFormatter.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.stdErrHandler.setFormatter((Formatter)newFormatter.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
    }

    @Override
    public final synchronized void setFilter(Filter newFilter) throws SecurityException {
        super.setFilter(newFilter);
        if (newFilter == null) {
            return;
        }
        try {
            this.stdOutHandler.setFilter((Filter)newFilter.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.stdErrHandler.setFilter((Filter)newFilter.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
    }
}

