/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.IOException;
import net.yacy.kelondro.io.Writer;

public final class RandomAccessIO {
    protected final Writer ra;
    protected final String name;

    public RandomAccessIO(Writer ra, String name) {
        this.name = name;
        this.ra = ra;
    }

    public final Writer getRA() {
        return this.ra;
    }

    public final synchronized long length() throws IOException {
        return this.ra.length();
    }

    public final synchronized void readFully(long pos, byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.ra.seek(pos);
        this.ra.readFully(b, off, len);
    }

    public final synchronized void write(long pos, byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.ra.seek(pos);
        this.ra.write(b, off, len);
    }

    public final String name() {
        return this.name;
    }

    public final synchronized byte readByte(long pos) throws IOException {
        byte[] b = new byte[1];
        this.readFully(pos, b, 0, 1);
        return b[0];
    }

    public final synchronized void writeByte(long pos, int v) throws IOException {
        this.write(pos, new byte[]{(byte)(v & 0xFF)});
    }

    public final synchronized short readShort(long pos) throws IOException {
        byte[] b = new byte[2];
        this.readFully(pos, b, 0, 2);
        return (short)((b[0] & 0xFF) << 8 | (b[1] & 0xFF) << 0);
    }

    public final synchronized void writeShort(long pos, int v) throws IOException {
        this.write(pos, new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)});
    }

    public final synchronized int readInt(long pos) throws IOException {
        byte[] b = new byte[4];
        this.readFully(pos, b, 0, 4);
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public final synchronized void writeInt(long pos, int v) throws IOException {
        this.write(pos, new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)});
    }

    public final synchronized long readLong(long pos) throws IOException {
        byte[] b = new byte[8];
        this.readFully(pos, b, 0, 8);
        return ((long)b[0] & 0xFFL) << 56 | ((long)b[1] & 0xFFL) << 48 | (long)b[2] << 40 | ((long)b[3] & 0xFFL) << 32 | ((long)b[4] & 0xFFL) << 24 | ((long)b[5] & 0xFFL) << 16 | ((long)b[6] & 0xFFL) << 8 | (long)b[7] & 0xFFL;
    }

    public final synchronized void writeLong(long pos, long v) throws IOException {
        this.write(pos, new byte[]{(byte)(v >>> 56 & 0xFFL), (byte)(v >>> 48 & 0xFFL), (byte)(v >>> 40 & 0xFFL), (byte)(v >>> 32 & 0xFFL), (byte)(v >>> 24 & 0xFFL), (byte)(v >>> 16 & 0xFFL), (byte)(v >>> 8 & 0xFFL), (byte)(v >>> 0 & 0xFFL)});
    }

    public final synchronized void write(long pos, byte[] b) throws IOException {
        this.write(pos, b, 0, b.length);
    }

    public final synchronized void writeSpace(long pos, int spaceCount) throws IOException {
        if (spaceCount < 512) {
            this.write(pos, RandomAccessIO.space(spaceCount));
            return;
        }
        byte[] b = RandomAccessIO.space(512);
        while (spaceCount > b.length) {
            this.write(pos, b);
            pos += (long)b.length;
            spaceCount -= b.length;
        }
        if (spaceCount > 0) {
            this.write(pos, RandomAccessIO.space(spaceCount));
        }
    }

    private static final byte[] space(int count) {
        byte[] s = new byte[count];
        while (count-- > 0) {
            s[count] = 0;
        }
        return s;
    }

    public final synchronized void close() throws IOException {
        if (this.ra != null) {
            this.ra.close();
        }
    }

    public final void deleteOnExit() {
        this.ra.deleteOnExit();
    }
}

