/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;

public final class BinSearch {
    private final byte[] chunks;
    private final int chunksize;
    private final int count;
    private static final ByteOrder objectOrder = new NaturalOrder(true);

    public BinSearch(byte[] chunks, int chunksize) {
        this.chunks = chunks;
        this.chunksize = chunksize;
        this.count = chunks.length / chunksize;
    }

    public BinSearch(List<byte[]> chunkList, int chunksize) {
        Object chunksa = new byte[chunkList.size()][];
        chunksa = (byte[][])chunkList.toArray((T[])chunksa);
        Arrays.sort(chunksa, objectOrder);
        this.chunks = new byte[chunkList.size() * chunksize];
        for (int i = 0; i < ((byte[][])chunksa).length; ++i) {
            System.arraycopy(chunksa[i], 0, this.chunks, i * chunksize, chunksize);
        }
        this.chunksize = chunksize;
        this.count = this.chunks.length / chunksize;
        assert (this.count == chunkList.size());
    }

    public final boolean contains(byte[] t) {
        return this.contains(t, 0, this.count);
    }

    private final boolean contains(byte[] t, int beginPos, int endPos) {
        assert (t.length == this.chunksize);
        while (true) {
            if (beginPos >= endPos) {
                return false;
            }
            int pivot = (beginPos + endPos) / 2;
            if (pivot < 0 || pivot >= this.count) {
                return false;
            }
            assert (this.chunksize == t.length);
            int c = objectOrder.compare(this.chunks, pivot * this.chunksize, t, 0, this.chunksize);
            if (c == 0) {
                return true;
            }
            if (c < 0) {
                beginPos = pivot + 1;
                continue;
            }
            if (c <= 0) break;
            endPos = pivot;
        }
        return false;
    }

    public final int size() {
        return this.count;
    }

    public final byte[] get(int element) {
        byte[] a = new byte[this.chunksize];
        System.arraycopy(this.chunks, element * this.chunksize, a, 0, this.chunksize);
        return a;
    }

    public final byte[] get(int element, byte[] a) {
        assert (a.length == this.chunksize);
        System.arraycopy(this.chunks, element * this.chunksize, a, 0, this.chunksize);
        return a;
    }

    public final void write(File f) throws IOException {
        try (FileOutputStream os = new FileOutputStream(f);){
            os.write(this.chunks);
            os.flush();
        }
    }

    public static void main(String[] args) {
        String s = "4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR";
        BinSearch bs = new BinSearch("4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".getBytes(), 6);
        int i = 0;
        while (i + 6 <= "4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".length()) {
            System.out.println("4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".substring(i, i + 6) + ":" + (bs.contains("4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".substring(i, i + 6).getBytes()) ? "drin" : "draussen"));
            i += 6;
        }
        i = 0;
        while (i + 7 <= "4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".length()) {
            System.out.println("4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".substring(i + 1, i + 7) + ":" + (bs.contains("4CEvsI8FRczRBo_ApRCkwfEbFLn1pIFXg39QGMgj5RHM6HpIMJq67QX3M5iQYr_LyI_5aGDaa_bYbRgJ9XnQjpmq6QkOoGWAoEaihRqhV3kItLFHjRtqauUR".substring(i + 1, i + 7).getBytes()) ? "drin" : "draussen"));
            i += 6;
        }
    }
}

