/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.navigation;

import java.io.Serializable;
import java.util.Collection;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.kelondro.data.navigation.NavigationReference;
import net.yacy.kelondro.data.navigation.NavigationReferenceRow;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.AbstractReference;
import net.yacy.kelondro.rwi.Reference;

public class NavigationReferenceVars
extends AbstractReference
implements NavigationReference,
Reference,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2873544331190937594L;
    private byte[] termhash;
    private byte[] refhash;
    private int hitcount;
    private int position;
    private byte flags;

    private NavigationReferenceVars(byte[] termhash, byte[] refhash, int count, int pos, byte flags) {
        this.refhash = refhash;
        this.termhash = termhash;
        this.hitcount = count;
        this.position = pos;
        this.flags = flags;
    }

    public NavigationReferenceVars(NavigationReference e) {
        this.refhash = e.urlhash();
        this.termhash = e.termHash();
        this.hitcount = e.hitcount();
        this.position = e.position(0);
        this.flags = e.flags();
    }

    public NavigationReferenceVars clone() {
        NavigationReferenceVars c = new NavigationReferenceVars(this.termhash, this.refhash, this.hitcount, this.position, this.flags);
        return c;
    }

    private NavigationReferenceRow toRowEntry() {
        return new NavigationReferenceRow(this.termhash, this.refhash, this.hitcount, this.position, this.flags);
    }

    @Override
    public String toPropertyForm() {
        return this.toRowEntry().toPropertyForm();
    }

    @Override
    public Row.Entry toKelondroEntry() {
        return this.toRowEntry().toKelondroEntry();
    }

    @Override
    public String navigationHash() {
        return ASCII.String(this.termhash) + ASCII.String(this.refhash);
    }

    @Override
    public byte[] urlhash() {
        return this.refhash;
    }

    @Override
    public byte[] termHash() {
        return this.termhash;
    }

    @Override
    public int hitcount() {
        return this.hitcount;
    }

    @Override
    public int position(int p) {
        assert (p == 0) : "p = " + p;
        return this.position;
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    @Override
    public String toString() {
        return this.toPropertyForm();
    }

    @Override
    public int hashCode() {
        return this.navigationHash().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NavigationReferenceVars)) {
            return false;
        }
        NavigationReferenceVars other = (NavigationReferenceVars)obj;
        return this.navigationHash().equals(other.navigationHash());
    }

    @Override
    public boolean isOlder(Reference other) {
        return false;
    }

    @Override
    public void join(Reference oe) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Integer> positions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int posintext() {
        throw new UnsupportedOperationException();
    }
}

