/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.net.MalformedURLException;
import javax.servlet.ServletRequest;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.UserDB;
import net.yacy.search.Switchboard;
import net.yacy.server.serverAccessTracker;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.server.Request;

public class YaCySecurityHandler
extends ConstraintSecurityHandler {
    protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
        String refererHost;
        Switchboard sb = Switchboard.getSwitchboard();
        boolean adminAccountGrantedForLocalhost = sb.getConfigBool("adminAccountForLocalhost", false);
        boolean adminAccountNeededForAllPages = sb.getConfigBool("adminAccountAllPages", false);
        String remoteip = RequestHeader.client((ServletRequest)request);
        serverAccessTracker.track(remoteip, pathInContext);
        try {
            refererHost = new MultiProtocolURL(request.getHeader("Referer")).getHost();
        }
        catch (MalformedURLException e) {
            refererHost = null;
        }
        boolean accessFromLocalhost = Domains.isLocalhost(remoteip) && (refererHost == null || refererHost.length() == 0 || Domains.isLocalhost(refererHost));
        boolean grantedForLocalhost = adminAccountGrantedForLocalhost && accessFromLocalhost;
        boolean protectedPage = adminAccountNeededForAllPages && (sb.isRobinsonMode() && !sb.isPublicRobinson() || !pathInContext.startsWith("/yacy/") && !pathInContext.startsWith("/solr/"));
        boolean bl = protectedPage = protectedPage || pathInContext.indexOf("_p.") > 0;
        if (!protectedPage && !sb.getConfigBool("publicSearchpage", true)) {
            boolean bl2 = protectedPage = pathInContext.startsWith("/solr/") || pathInContext.startsWith("/gsa/");
        }
        if (protectedPage) {
            if (grantedForLocalhost) {
                return null;
            }
            if (accessFromLocalhost) {
                String adminAccountBase64MD5 = sb.getConfig("adminAccountBase64MD5", "");
                String credentials = request.getHeader("Authorization");
                if (credentials != null && credentials.length() < 120 && credentials.startsWith("Basic ")) {
                    String foruser = sb.getConfig("adminAccountUserName", "admin");
                    String b64 = Base64Order.standardCoder.encodeString(foruser + ":" + adminAccountBase64MD5);
                    if (credentials.substring(6).equals(b64)) {
                        return null;
                    }
                }
            }
            RoleInfo roleinfo = new RoleInfo();
            roleinfo.setChecked(true);
            roleinfo.addRole(UserDB.AccessRight.ADMIN_RIGHT.toString());
            return roleinfo;
        }
        return super.prepareConstraintInfo(pathInContext, request);
    }
}

