/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.document.Document;
import net.yacy.peers.graphics.WebStructureGraph;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class webstructure {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        boolean authenticated;
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        String about = post == null ? null : post.get("about", "");
        prop.put("out", 0L);
        prop.put("in", 0L);
        prop.put("references", 0L);
        prop.put("citations", 0L);
        boolean bl = authenticated = sb.adminAuthenticated(header) >= 2;
        if (about != null && about.length() > 0) {
            DigestURL url = null;
            byte[] urlhash = null;
            HashSet<String> hostHashes = new HashSet<String>();
            if (about.length() == 6 && Base64Order.enhancedCoder.wellformed(ASCII.getBytes(about))) {
                hostHashes.add(about);
            } else if (about.length() == 12 && Base64Order.enhancedCoder.wellformed(ASCII.getBytes(about))) {
                urlhash = ASCII.getBytes(about);
                hostHashes.add(about.substring(6));
                if (authenticated) {
                    try {
                        String u = sb.getURL(urlhash);
                        url = u == null ? null : new DigestURL(u);
                    }
                    catch (IOException e) {
                        url = null;
                        ConcurrentLog.logException(e);
                    }
                }
            } else if (about.length() > 0) {
                try {
                    url = new DigestURL((String)(about.indexOf("://") >= 0 ? about : "http://" + about));
                    urlhash = url.hash();
                    if (about.indexOf("://") >= 0) {
                        hostHashes.add(url.hosthash());
                    } else {
                        hostHashes.addAll(sb.webStructure.hostName2HostHashes(about));
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (!hostHashes.isEmpty()) {
                prop.put("out", 1L);
                prop.put("in", 1L);
                int inCount = 0;
                int outCount = 0;
                for (String hostHash : hostHashes) {
                    WebStructureGraph.StructureEntry sentry = sb.webStructure.outgoingReferences(hostHash);
                    if (sentry != null && sentry.references.size() > 0) {
                        webstructure.reference(prop, "out", outCount, sentry, sb.webStructure);
                        ++outCount;
                    } else {
                        prop.put("out_domains", 0L);
                    }
                    sentry = sb.webStructure.incomingReferences(hostHash);
                    if (sentry != null && sentry.references.size() > 0) {
                        webstructure.reference(prop, "in", inCount, sentry, sb.webStructure);
                        prop.put("in_domains", 1L);
                        ++inCount;
                        continue;
                    }
                    prop.put("in_domains", 0L);
                }
                prop.put("out_domains", outCount);
                prop.put("in_domains", inCount);
            }
            boolean documentStructure = true;
            if (post != null && "false".equals(post.get("documentStructure", "true"))) {
                documentStructure = false;
            }
            if (urlhash != null && documentStructure) {
                prop.put("references", 1L);
                Document scraper = null;
                if (url != null) {
                    try {
                        ClientIdentification.Agent agent = ClientIdentification.getAgent(post.get("agentName", "YaCy Internet (cautious)"));
                        scraper = sb.loader.loadDocument(url, CacheStrategy.IFEXIST, null, agent);
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (scraper != null) {
                    byte[] refhash;
                    prop.put("references_count", 1L);
                    prop.put("references_documents", 1L);
                    prop.put("references_documents_0_hash", urlhash);
                    prop.put("references_documents_0_count", scraper.inboundLinks().size() + scraper.outboundLinks().size());
                    prop.put("references_documents_0_date", GenericFormatter.SHORT_DAY_FORMATTER.format(new Date()));
                    prop.put("references_documents_0_urle", url == null ? 0L : 1L);
                    if (url != null) {
                        prop.putXML("references_documents_0_urle_url", url.toNormalform(true));
                    }
                    int d = 0;
                    for (DigestURL refurl : scraper.inboundLinks().keySet()) {
                        refhash = refurl.hash();
                        prop.putXML("references_documents_0_anchors_" + d + "_url", refurl.toNormalform(true));
                        prop.put("references_documents_0_anchors_" + d + "_hash", refhash);
                        prop.put("references_documents_0_anchors_" + d + "_outbound", 0L);
                        ++d;
                    }
                    for (DigestURL refurl : scraper.outboundLinks().keySet()) {
                        refhash = refurl.hash();
                        prop.putXML("references_documents_0_anchors_" + d + "_url", refurl.toNormalform(true));
                        prop.put("references_documents_0_anchors_" + d + "_hash", refhash);
                        prop.put("references_documents_0_anchors_" + d + "_outbound", 1L);
                        ++d;
                    }
                    prop.put("references_documents_0_count", d);
                    prop.put("references_documents_0_anchors", d);
                } else {
                    prop.put("references_count", 0L);
                    prop.put("references_documents", 0L);
                }
                prop.put("citations", 1L);
                Segment.ReferenceReportCache rrc = sb.index.getReferenceReportCache();
                Segment.ReferenceReport rr = null;
                try {
                    rr = rrc.getReferenceReport(ASCII.String(urlhash), true);
                }
                catch (IOException refurl) {
                    // empty catch block
                }
                if (rr != null && rr.getInternalCount() > 0 && rr.getExternalCount() > 0) {
                    prop.put("citations_count", 1L);
                    prop.put("citations_documents", 1L);
                    prop.put("citations_documents_0_hash", urlhash);
                    prop.put("citations_documents_0_count", rr.getInternalCount() + rr.getExternalCount());
                    prop.put("citations_documents_0_date", GenericFormatter.SHORT_DAY_FORMATTER.format(new Date()));
                    prop.put("citations_documents_0_urle", url == null ? 0L : 1L);
                    if (url != null) {
                        prop.putXML("citations_documents_0_urle_url", url.toNormalform(true));
                    }
                    int d = 0;
                    HandleSet ids = rr.getInternallIDs();
                    try {
                        ids.putAll(rr.getExternalIDs());
                    }
                    catch (SpaceExceededException spaceExceededException) {
                        // empty catch block
                    }
                    for (byte[] refhash : ids) {
                        try {
                            String refurl = authenticated ? sb.getURL(refhash) : null;
                            prop.put("citations_documents_0_anchors_" + d + "_urle", refurl == null ? 0L : 1L);
                            if (refurl != null) {
                                prop.putXML("citations_documents_0_anchors_" + d + "_urle_url", refurl);
                            }
                            prop.put("citations_documents_0_anchors_" + d + "_urle_hash", refhash);
                            prop.put("citations_documents_0_anchors_" + d + "_urle_date", GenericFormatter.SHORT_DAY_FORMATTER.format(new Date()));
                            ++d;
                        }
                        catch (IOException e) {
                            ConcurrentLog.logException(e);
                        }
                    }
                    prop.put("citations_documents_0_count", d);
                    prop.put("citations_documents_0_anchors", d);
                } else {
                    prop.put("citations_count", 0L);
                    prop.put("citations_documents", 0L);
                }
            }
        } else if (authenticated) {
            boolean latest = post == null ? false : post.containsKey("latest");
            Iterator<WebStructureGraph.StructureEntry> i = sb.webStructure.structureEntryIterator(latest);
            int c = 0;
            while (i.hasNext()) {
                WebStructureGraph.StructureEntry sentry = i.next();
                webstructure.reference(prop, "out", c, sentry, sb.webStructure);
                ++c;
            }
            prop.put("out_domains", c);
            prop.put("out", 1L);
            if (latest) {
                sb.webStructure.joinOldNew();
            }
        } else {
            prop.put("out_domains", 0L);
            prop.put("out", 1L);
        }
        prop.put("out_maxref", 200L);
        prop.put("maxhosts", 10000L);
        return prop;
    }

    public static void reference(serverObjects prop, String prefix, int c, WebStructureGraph.StructureEntry sentry, WebStructureGraph ws) {
        prop.put(prefix + "_domains_" + c + "_hash", sentry.hosthash);
        prop.putXML(prefix + "_domains_" + c + "_domain", sentry.hostname);
        prop.put(prefix + "_domains_" + c + "_date", sentry.date);
        Iterator<Map.Entry<String, Integer>> k = sentry.references.entrySet().iterator();
        int d = 0;
        while (k.hasNext()) {
            Map.Entry<String, Integer> refentry = k.next();
            String refhash = refentry.getKey();
            String refdom = ws.hostHash2hostName(refhash);
            if (refdom == null) continue;
            prop.put(prefix + "_domains_" + c + "_citations_" + d + "_refhash", refhash);
            prop.putXML(prefix + "_domains_" + c + "_citations_" + d + "_refdom", refdom);
            Integer refcount = refentry.getValue();
            prop.put(prefix + "_domains_" + c + "_citations_" + d + "_refcount", refcount.intValue());
            ++d;
        }
        prop.put(prefix + "_domains_" + c + "_citations", d);
    }
}

