/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Tables;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class table_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int i;
        Pattern matcher;
        String table;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String EXT = header.get("EXT", "");
        boolean html = EXT.equals("html");
        boolean xml = EXT.equals("xml");
        String string = table = post == null ? null : post.get("table");
        if (post == null || !post.containsKey("commitrow") && table != null && !sb.tables.hasHeap(table)) {
            table = null;
        }
        prop.put("showtable", 0L);
        prop.put("tablecount", sb.tables.size());
        if (table != null && post != null && post.containsKey("deletetable")) {
            sb.tables.clear(table);
            table = null;
        }
        if (table == null) {
            int c = 0;
            for (String name : sb.tables) {
                try {
                    if (html) {
                        prop.putHTML("showtable_tables_" + c + "_table", name);
                    }
                    if (xml) {
                        prop.putXML("showtable_tables_" + c + "_table", name);
                    }
                    prop.put("showtable_tables_" + c + "_num", sb.tables.size(name));
                    ++c;
                }
                catch (IOException iOException) {}
            }
            prop.put("showtable_tables", c);
            prop.put("tablecount", c);
            return prop;
        }
        boolean showpk = post.containsKey("pk");
        String selectKey = post.containsKey("selectKey") ? post.get("selectKey") : null;
        String selectValue = selectKey != null && post.containsKey("selectValue") ? post.get("selectValue") : null;
        String counts = post.get("count", "");
        int maxcount = counts == null || counts.length() == 0 || counts.equals("all") ? Integer.MAX_VALUE : post.getInt("count", 10);
        String pattern = post.get("search", "");
        Pattern pattern2 = matcher = pattern.isEmpty() || pattern.equals(".*") ? null : Pattern.compile(".*" + pattern + ".*");
        if (post.containsKey("deleterows")) {
            for (Map.Entry<String, String> entry2 : post.entrySet()) {
                if (!entry2.getValue().startsWith("pk_")) continue;
                try {
                    sb.tables.delete(table, entry2.getValue().substring(3).getBytes());
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (post.containsKey("commitrow")) {
            String pk = post.get("pk");
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            for (Map.Entry<String, String> entry3 : post.entrySet()) {
                if (!entry3.getKey().startsWith("col_")) continue;
                map.put(entry3.getKey().substring(4), entry3.getValue().getBytes());
            }
            try {
                if (pk == null || pk.isEmpty()) {
                    sb.tables.insert(table, map);
                } else {
                    sb.tables.update(table, pk.getBytes(), map);
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        prop.put("showtable", 1L);
        prop.put("showtable_table", table);
        ArrayList<String> columns = null;
        try {
            columns = sb.tables.columns(table);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            columns = new ArrayList();
        }
        String[] row = CommonPattern.COMMA.split(post.get("row", ""));
        for (i = 0; i < row.length; ++i) {
            if (!columns.contains(row[i])) continue;
            columns.remove(row[i]);
            if (i >= columns.size()) continue;
            columns.add(i, row[i]);
        }
        prop.put("showtable_showpk", showpk ? 1L : 0L);
        for (i = 0; i < columns.size(); ++i) {
            prop.putHTML("showtable_columns_" + i + "_header", columns.get(i));
        }
        prop.put("showtable_columns", columns.size());
        try {
            maxcount = Math.min(maxcount, sb.tables.size(table));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            maxcount = 0;
        }
        int count = 0;
        try {
            Iterator<Tables.Row> mapIterator = sb.tables.iterator(table, matcher, true);
            boolean dark = true;
            block18: while (mapIterator.hasNext() && count < maxcount) {
                Tables.Row trow = mapIterator.next();
                if (row == null) continue;
                prop.put("showtable_list_" + count + "_dark", dark ? 1 : 0);
                dark = !dark;
                prop.put("showtable_list_" + count + "_showpk", showpk ? 1L : 0L);
                prop.put("showtable_list_" + count + "_showpk_pk", UTF8.String(trow.getPK()));
                prop.put("showtable_list_" + count + "_count", count);
                for (int i2 = 0; i2 < columns.size(); ++i2) {
                    String cellValue;
                    String cellName = columns.get(i2);
                    if (trow.containsKey(cellName)) {
                        cellValue = UTF8.String((byte[])trow.get(cellName));
                        if (selectKey != null && cellName.equals(selectKey) && !cellValue.matches(selectValue)) {
                            continue block18;
                        }
                    } else {
                        cellValue = "";
                    }
                    if (html) {
                        prop.putHTML("showtable_list_" + count + "_columns_" + i2 + "_column", cellName);
                        prop.putHTML("showtable_list_" + count + "_columns_" + i2 + "_cell", cellValue);
                    }
                    if (!xml) continue;
                    prop.putXML("showtable_list_" + count + "_columns_" + i2 + "_column", cellName);
                    prop.putXML("showtable_list_" + count + "_columns_" + i2 + "_cell", cellValue);
                }
                prop.put("showtable_list_" + count + "_columns", columns.size());
                ++count;
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        prop.put("showtable_list", count);
        prop.put("showtable_num", count);
        return prop;
    }
}

