/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.blacklists;

import java.util.List;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.ListManager;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.Blacklist;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class get_metadata_p {
    private static final Blacklist.BlacklistType[] BLACKLIST_TYPE_VALUES = Blacklist.BlacklistType.values();
    private static final String LISTS = "lists";
    private static final String POSTFIX_SHARED = "_shared";
    private static final String POSTFIX_TYPES = "_types";
    private static final String POSTFIX_VALUE = "_value";
    private static final String POSTFIX_NAME = "_name";
    private static final String POSTFIX_COMMA = "_comma";
    private static final String TYPES_EXT = ".BlackLists";
    private static final String INFIX_TYPES = "_types_";
    private static final String PREFIX_LISTS = "lists_";
    private static final String BLACK_LISTS_SHARED = "BlackLists.Shared";
    private static final int lastTypeIndex = BLACKLIST_TYPE_VALUES.length - 1;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        List<String> dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
        int lastBlacklistCount = dirlist.size() - 1;
        int blacklistCount = 0;
        if (dirlist != null) {
            for (String element : dirlist) {
                prop.putXML(PREFIX_LISTS + blacklistCount + POSTFIX_NAME, element);
                prop.put(PREFIX_LISTS + blacklistCount + POSTFIX_SHARED, ListManager.listSetContains(BLACK_LISTS_SHARED, element));
                int j = 0;
                for (Blacklist.BlacklistType type : BLACKLIST_TYPE_VALUES) {
                    prop.putXML(PREFIX_LISTS + blacklistCount + INFIX_TYPES + j + POSTFIX_NAME, type.toString());
                    prop.put(PREFIX_LISTS + blacklistCount + INFIX_TYPES + j + POSTFIX_VALUE, ListManager.listSetContains(String.valueOf((Object)type) + TYPES_EXT, element));
                    prop.put(PREFIX_LISTS + blacklistCount + INFIX_TYPES + j + POSTFIX_COMMA, j < lastTypeIndex);
                    ++j;
                }
                prop.put(PREFIX_LISTS + blacklistCount + POSTFIX_TYPES, BLACKLIST_TYPE_VALUES.length);
                prop.put(PREFIX_LISTS + blacklistCount + POSTFIX_COMMA, blacklistCount < lastBlacklistCount);
                ++blacklistCount;
            }
        }
        prop.put(LISTS, blacklistCount);
        return prop;
    }
}

