/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.document.importer.JsonListImporter;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexImportJsonList_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        if (JsonListImporter.job != null && JsonListImporter.job.isAlive()) {
            prop.put("import", 1L);
            prop.put("import_thread", "running");
            prop.put("import_jsonlistfile", JsonListImporter.job.source());
            prop.put("import_count", JsonListImporter.job.count());
            prop.put("import_speed", JsonListImporter.job.speed());
            prop.put("import_runningHours", JsonListImporter.job.runningTime() / 60L / 60L);
            prop.put("import_runningMinutes", JsonListImporter.job.runningTime() / 60L % 60L);
            prop.put("import_remainingHours", JsonListImporter.job.remainingTime() / 60L / 60L);
            prop.put("import_remainingMinutes", JsonListImporter.job.remainingTime() / 60L % 60L);
            if (post != null && post.containsKey("abort")) {
                JsonListImporter.job.quit();
            }
        } else {
            prop.put("import", 0L);
            if (post != null && (post.containsKey("file") || post.containsKey("url"))) {
                String filename = post.get("file");
                if (filename != null && filename.length() > 0) {
                    File sourcefile = new File(filename);
                    if (sourcefile.exists()) {
                        try {
                            JsonListImporter wi = new JsonListImporter(sourcefile, false, false);
                            wi.start();
                            prop.put("import_thread", "started");
                        }
                        catch (IOException ex) {
                            prop.put("import_thread", "Error: file not found [" + filename + "]");
                        }
                        prop.put("import", 1L);
                        prop.put("import_jsonlistfile", filename);
                    } else {
                        prop.put("import_jsonlistfile", "");
                        prop.put("import_thread", "Error: file not found [" + filename + "]");
                    }
                } else {
                    String urlstr = post.get("url");
                    if (urlstr != null && urlstr.length() > 0) {
                        try {
                            URL url = new URI(urlstr).toURL();
                            String tempfilename = "jsonlistimporter";
                            boolean gz = urlstr.endsWith(".gz");
                            File tempfile = File.createTempFile("jsonlistimporter", "");
                            FileOutputStream fos = new FileOutputStream(tempfile);
                            fos.getChannel().transferFrom(Channels.newChannel(url.openStream()), 0L, Long.MAX_VALUE);
                            fos.close();
                            JsonListImporter wi = new JsonListImporter(tempfile, gz, true);
                            wi.start();
                            prop.put("import_thread", "started");
                        }
                        catch (IOException | URISyntaxException ex) {
                            prop.put("import_thread", ex.getMessage());
                        }
                        prop.put("import", 1L);
                        prop.put("import_jsonlistfile", urlstr);
                    }
                }
                prop.put("import_count", 0L);
                prop.put("import_speed", 0L);
                prop.put("import_runningHours", 0L);
                prop.put("import_runningMinutes", 0L);
                prop.put("import_remainingHours", 0L);
                prop.put("import_remainingMinutes", 0L);
            }
        }
        return prop;
    }
}

