/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.ListManager;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class BlacklistImpExp_p {
    private static final String DISABLED = "disabled_";

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        List<String> dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
        String blacklistToUse = null;
        serverObjects prop = new serverObjects();
        prop.putHTML("blacklistEngine", Blacklist.getEngineInfo());
        if (blacklistToUse == null && dirlist != null && !dirlist.isEmpty()) {
            blacklistToUse = Blacklist.defaultBlacklist(sb.listsPath);
        }
        if (sb.peers != null && sb.peers.sizeConnected() > 0) {
            int peerCount = 0;
            try {
                TreeMap<String, String> hostList = new TreeMap<String, String>();
                Iterator<Seed> e = sb.peers.seedsConnected(true, false, null, 0.0);
                while (e.hasNext()) {
                    Seed seed = e.next();
                    if (seed == null) continue;
                    hostList.put(seed.get("Name", "nameless"), seed.hash);
                }
                for (String peername : hostList.keySet()) {
                    String Hash = (String)hostList.get(peername);
                    prop.putHTML("disabled_otherHosts_" + peerCount + "_hash", Hash);
                    prop.putXML("disabled_otherHosts_" + peerCount + "_name", peername);
                    ++peerCount;
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            prop.put("disabled_otherHosts", peerCount);
        }
        prop.putXML("disabled_currentBlacklist", blacklistToUse == null ? "" : blacklistToUse);
        prop.put("disabled", blacklistToUse == null ? "1" : "0");
        int count = 0;
        for (String element : dirlist) {
            prop.putHTML("blackListNames_" + count + "_blackListName", element);
            ++count;
        }
        prop.put("blackListNames", count);
        return prop;
    }
}

