/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.input.ClosedInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OOXMLSharedStringsHandler
extends DefaultHandler {
    public static final String ENTRY_NAME = "xl/sharedStrings.xml";
    private static final String SHARED_STRING_TAG = "t";
    private final List<String> sharedStrings;
    private StringBuilder currentString;

    public OOXMLSharedStringsHandler(List<String> sharedStrings) throws IllegalArgumentException {
        if (sharedStrings == null) {
            throw new IllegalArgumentException("sharedStrings list must not be null");
        }
        this.sharedStrings = sharedStrings;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource((InputStream)new ClosedInputStream());
    }

    @Override
    public void startDocument() throws SAXException {
        this.currentString = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SHARED_STRING_TAG.equals(qName)) {
            this.currentString.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentString.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (SHARED_STRING_TAG.equals(qName)) {
            String sharedString = this.currentString.toString();
            this.sharedStrings.add(sharedString);
            this.currentString.setLength(0);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.currentString = null;
    }
}

