/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.xml;

import java.text.ParseException;
import java.util.Date;
import net.yacy.cora.date.ISO8601Formatter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ODMetaHandler
extends DefaultHandler {
    private final StringBuilder buffer = new StringBuilder();
    private String docCreator = null;
    private String docLanguage = null;
    private String docKeyword = null;
    private String docSubject = null;
    private String docTitle = null;
    private String docDescription = null;
    private String docLastmodified = null;

    @Override
    public void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
        this.buffer.delete(0, this.buffer.length());
    }

    @Override
    public void endElement(String uri, String name, String tag) {
        if ("dc:creator".equals(tag)) {
            this.docCreator = this.buffer.toString();
        } else if ("dc:language".equals(tag)) {
            this.docLanguage = this.buffer.toString();
        } else if ("meta:keyword".equals(tag)) {
            this.docKeyword = this.buffer.toString();
        } else if ("dc:subject".equals(tag)) {
            this.docSubject = this.buffer.toString();
        } else if ("dc:title".equals(tag)) {
            this.docTitle = this.buffer.toString();
        } else if ("dc:description".equals(tag)) {
            this.docDescription = this.buffer.toString();
        } else if ("dcterms:modified".equals(tag) || "dc:date".equals(tag)) {
            this.docLastmodified = this.buffer.toString();
        }
    }

    public String getCreator() {
        return this.docCreator;
    }

    public String getLanguage() {
        return this.docLanguage;
    }

    public String getKeyword() {
        return this.docKeyword;
    }

    public String getSubject() {
        return this.docSubject;
    }

    public String getTitle() {
        return this.docTitle;
    }

    public String getDescription() {
        return this.docDescription;
    }

    public Date getLastModified() {
        Date d;
        if (this.docLastmodified != null && !this.docLastmodified.isEmpty()) {
            try {
                d = ISO8601Formatter.FORMATTER.parse(this.docLastmodified, 0).getTime();
            }
            catch (ParseException ex) {
                d = null;
            }
        } else {
            d = null;
        }
        return d;
    }
}

