/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.geo.GeonamesLocation;
import net.yacy.cora.geo.OpenGeoDBLocation;
import net.yacy.cora.geo.OverarchingLocation;
import net.yacy.cora.language.synonyms.AutotaggingLibrary;
import net.yacy.cora.language.synonyms.SynonymLibrary;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.URLRewriterLibrary;
import net.yacy.kelondro.util.FileUtils;

public class LibraryProvider {
    private static final ConcurrentLog LOG = new ConcurrentLog(LibraryProvider.class.getSimpleName());
    public static final String path_to_source_dictionaries = "source";
    public static final String path_to_did_you_mean_dictionaries = "didyoumean";
    public static final String path_to_autotagging_dictionaries = "autotagging";
    public static final String path_to_synonym_dictionaries = "synonyms";
    public static final String path_to_rewriter_dictionaries = "rewriter";
    public static final String disabledExtension = ".disabled";
    public static WordCache dymLib = new WordCache(null);
    public static AutotaggingLibrary autotagging = new AutotaggingLibrary(null);
    public static URLRewriterLibrary urlRewriter = null;
    public static OverarchingLocation geoLoc = new OverarchingLocation();
    private static File dictSource = null;
    private static File dictRoot = null;

    public static void initialize(File rootPath) {
        dictSource = new File(rootPath, path_to_source_dictionaries);
        if (!dictSource.exists()) {
            dictSource.mkdirs();
        }
        dictRoot = rootPath;
        LibraryProvider.initAutotagging();
        LibraryProvider.activateDeReWo();
        LibraryProvider.initDidYouMean();
        LibraryProvider.initSynonyms();
        LibraryProvider.initRewriter();
        LibraryProvider.integrateOpenGeoDB();
        LibraryProvider.integrateGeonames0(-1L);
        LibraryProvider.integrateGeonames1(-1L);
        LibraryProvider.integrateGeonames2(100000L);
        HashSet<String> allTags = new HashSet<String>();
        allTags.addAll(autotagging.allTags());
        autotagging.addPlaces(geoLoc);
        WordCache.learn(allTags);
    }

    public static void integrateOpenGeoDB() {
        File geo2 = Dictionary.GEODB2.file();
        File geo1 = Dictionary.GEODB1.file();
        File geo0 = Dictionary.GEODB0.file();
        if (geo2.exists()) {
            if (geo1.exists() && !geo1.renameTo(Dictionary.GEODB1.fileDisabled())) {
                LOG.warn("Could not rename file " + String.valueOf(geo1) + " to " + String.valueOf(Dictionary.GEODB1.fileDisabled()));
            }
            if (geo0.exists() && !geo0.renameTo(Dictionary.GEODB0.fileDisabled())) {
                LOG.warn("Could not rename file " + String.valueOf(geo0) + " to " + String.valueOf(Dictionary.GEODB0.fileDisabled()));
            }
            geoLoc.activateLocation(Dictionary.GEODB2.nickname, new OpenGeoDBLocation(geo2, dymLib));
        } else if (geo1.exists()) {
            if (geo0.exists() && !geo0.renameTo(Dictionary.GEODB0.fileDisabled())) {
                LOG.warn("Could not rename file " + String.valueOf(geo0) + " to " + String.valueOf(Dictionary.GEODB0.fileDisabled()));
            }
            geoLoc.activateLocation(Dictionary.GEODB1.nickname, new OpenGeoDBLocation(geo1, dymLib));
        } else if (geo0.exists()) {
            geoLoc.activateLocation(Dictionary.GEODB0.nickname, new OpenGeoDBLocation(geo0, dymLib));
        }
    }

    public static void integrateGeonames0(long minPopulation) {
        File geon = Dictionary.GEON0.file();
        if (geon.exists()) {
            geoLoc.activateLocation(Dictionary.GEON0.nickname, new GeonamesLocation(geon, dymLib, minPopulation));
            return;
        }
    }

    public static void integrateGeonames1(long minPopulation) {
        File geon = Dictionary.GEON1.file();
        if (geon.exists()) {
            geoLoc.activateLocation(Dictionary.GEON1.nickname, new GeonamesLocation(geon, dymLib, minPopulation));
            return;
        }
    }

    public static void integrateGeonames2(long minPopulation) {
        File geon = Dictionary.GEON2.file();
        if (geon.exists()) {
            geoLoc.activateLocation(Dictionary.GEON2.nickname, new GeonamesLocation(geon, dymLib, minPopulation));
            return;
        }
    }

    public static void initDidYouMean() {
        File dymDict = new File(dictRoot, path_to_did_you_mean_dictionaries);
        if (!dymDict.exists()) {
            dymDict.mkdirs();
        }
        dymLib = new WordCache(dymDict);
    }

    public static void initAutotagging() {
        File autotaggingPath = new File(dictRoot, path_to_autotagging_dictionaries);
        if (!autotaggingPath.exists()) {
            autotaggingPath.mkdirs();
        }
        autotagging = new AutotaggingLibrary(autotaggingPath);
    }

    public static void initSynonyms() {
        File synonymPath = new File(dictRoot, path_to_synonym_dictionaries);
        if (!synonymPath.exists()) {
            synonymPath.mkdirs();
        }
        SynonymLibrary.init(synonymPath);
    }

    public static void initRewriter() {
        File rewriterPath = new File(dictRoot, path_to_rewriter_dictionaries);
        if (!rewriterPath.exists()) {
            rewriterPath.mkdirs();
        }
        urlRewriter = new URLRewriterLibrary(rewriterPath);
    }

    public static void activateDeReWo() {
        File derewoInput;
        File derewoOutput;
        File dymDict = new File(dictRoot, path_to_did_you_mean_dictionaries);
        if (!dymDict.exists()) {
            dymDict.mkdirs();
        }
        if (!(derewoOutput = new File(dymDict, (derewoInput = Dictionary.DRW0.file()).getName() + ".words")).exists() && derewoInput.exists()) {
            ArrayList<String> derewo = LibraryProvider.loadDeReWo(derewoInput, true);
            try {
                LibraryProvider.writeWords(derewoOutput, derewo);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    public static void deactivateDeReWo() {
        File dymDict = new File(dictRoot, path_to_did_you_mean_dictionaries);
        File derewoInput = Dictionary.DRW0.file();
        File derewoOutput = new File(dymDict, derewoInput.getName() + ".words");
        FileUtils.deletedelete(derewoOutput);
    }

    private static Set<String> sortUnique(List<String> list2) {
        TreeSet<String> s = new TreeSet<String>();
        for (String t : list2) {
            s.add(t);
        }
        return s;
    }

    private static void writeWords(File f, ArrayList<String> list2) throws IOException {
        Set<String> s = LibraryProvider.sortUnique(list2);
        PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        for (String t : s) {
            w.println(t);
        }
        w.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> loadDeReWo(File file, boolean toLowerCase) {
        InputStream derewoTxtEntry;
        ArrayList<String> list2 = new ArrayList<String>();
        try {
            ZipFile zip = new ZipFile(file);
            derewoTxtEntry = zip.getInputStream(zip.getEntry("derewo-v-100000t-2009-04-30-0.1"));
            zip.close();
        }
        catch (ZipException e) {
            ConcurrentLog.logException(e);
            return list2;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return list2;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(derewoTxtEntry, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null && !line.startsWith("# -----")) {
            }
            line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String w;
                int p = (line = line.trim()).indexOf(32, 0);
                if (p <= 0) continue;
                String string = w = toLowerCase ? line.substring(0, p).trim().toLowerCase() : line.substring(0, p).trim();
                if (w.length() < 4) continue;
                list2.add(w);
            }
            reader.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return list2;
    }

    public static void main(String[] args) {
        File here = new File("dummy").getParentFile();
        LibraryProvider.initialize(new File(here, "DATA/DICTIONARIES"));
        System.out.println("dymDict-size = " + dymLib.size());
        Set<StringBuilder> r = dymLib.recommend(new StringBuilder("da"));
        for (StringBuilder s : r) {
            System.out.println("$ " + String.valueOf(s));
        }
        System.out.println("recommendations: " + r.size());
    }

    public static final class Dictionary
    extends Enum<Dictionary> {
        public static final /* enum */ Dictionary GEODB0 = new Dictionary("geo0", "http://downloads.sourceforge.net/project/opengeodb/Data/0.2.5a/opengeodb-0.2.5a-UTF8-sql.gz");
        public static final /* enum */ Dictionary GEODB1 = new Dictionary("geo1", "http://fa-technik.adfc.de/code/opengeodb/dump/opengeodb-02624_2011-10-17.sql.gz");
        public static final /* enum */ Dictionary GEODB2 = new Dictionary("geo2", "http://fa-technik.adfc.de/code/opengeodb/dump/opengeodb-02628_2017-02-07.sql.gz");
        public static final /* enum */ Dictionary GEON0 = new Dictionary("geon0", "http://download.geonames.org/export/dump/cities1000.zip");
        public static final /* enum */ Dictionary GEON1 = new Dictionary("geon1", "http://download.geonames.org/export/dump/cities5000.zip");
        public static final /* enum */ Dictionary GEON2 = new Dictionary("geon2", "http://download.geonames.org/export/dump/cities15000.zip");
        public static final /* enum */ Dictionary DRW0 = new Dictionary("drw0", "http://www1.ids-mannheim.de/fileadmin/kl/derewo/derewo-v-100000t-2009-04-30-0.1.zip");
        public static final /* enum */ Dictionary PND0 = new Dictionary("pnd0", "http://downloads.dbpedia.org/3.7-i18n/de/pnd_de.nt.bz2");
        public String nickname;
        public String url;
        public String filename;
        private static final /* synthetic */ Dictionary[] $VALUES;

        public static Dictionary[] values() {
            return (Dictionary[])$VALUES.clone();
        }

        public static Dictionary valueOf(String name) {
            return Enum.valueOf(Dictionary.class, name);
        }

        private Dictionary(String nickname, String url) {
            block2: {
                try {
                    this.filename = new MultiProtocolURL(url).getFileName();
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
            this.nickname = nickname;
            this.url = url;
        }

        public File file() {
            return new File(dictSource, this.filename);
        }

        public File fileDisabled() {
            return new File(dictSource, this.filename + LibraryProvider.disabledExtension);
        }

        private static /* synthetic */ Dictionary[] $values() {
            return new Dictionary[]{GEODB0, GEODB1, GEODB2, GEON0, GEON1, GEON2, DRW0, PND0};
        }

        static {
            $VALUES = Dictionary.$values();
        }
    }
}

