/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.yacy.cora.util.CommonPattern;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.Blacklist;
import net.yacy.repository.BlacklistFile;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;

public class ListManager {
    public static Switchboard switchboard = null;
    public static File listsPath = null;

    public static Set<String> getListSet(String setName) {
        return ListManager.string2set(switchboard.getConfig(setName, ""));
    }

    public static void removeFromListSet(String setName, String listName) {
        Set<String> listSet = ListManager.getListSet(setName);
        if (!listSet.isEmpty()) {
            listSet.remove(listName);
            switchboard.setConfig(setName, ListManager.collection2string(listSet));
        }
    }

    public static void updateListSet(String setName, String newListName) {
        Set<String> listSet = ListManager.getListSet(setName);
        listSet.add(newListName);
        switchboard.setConfig(setName, ListManager.collection2string(listSet));
    }

    public static boolean listSetContains(String setName, String listName) {
        return ListManager.getListSet(setName).contains(listName);
    }

    public static String getListString(String filename, boolean withcomments) {
        return FileUtils.getListString(new File(listsPath, filename), withcomments);
    }

    public static String collection2string(Collection<String> col) {
        StringBuilder str = new StringBuilder(col.size() * 40);
        if (col != null && !col.isEmpty()) {
            Iterator<String> it = col.iterator();
            str.append(it.next());
            while (it.hasNext()) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(it.next());
            }
        }
        return str.toString();
    }

    public static ArrayList<String> string2arraylist(String string) {
        ArrayList<String> list2 = string != null && string.length() > 0 ? new ArrayList<String>(Arrays.asList(CommonPattern.COMMA.split(string, 0))) : new ArrayList<String>();
        return list2;
    }

    public static Set<String> string2set(String string) {
        HashSet<String> set = string != null ? new HashSet<String>(Arrays.asList(CommonPattern.COMMA.split(string, 0))) : new HashSet<String>();
        return set;
    }

    public static Vector<String> string2vector(String string) {
        Vector<String> v = string != null ? new Vector<String>(Arrays.asList(CommonPattern.COMMA.split(string, 0))) : new Vector<String>();
        return v;
    }

    public static void reloadBlacklists() {
        ArrayList<BlacklistFile> blacklistFiles = new ArrayList<BlacklistFile>(Blacklist.BlacklistType.values().length);
        for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
            BlacklistFile blFile = new BlacklistFile(switchboard.getConfig(supportedBlacklistType.toString() + ".BlackLists", switchboard.getConfig("BlackLists.DefaultList", "url.default.black")), supportedBlacklistType);
            blacklistFiles.add(blFile);
        }
        Switchboard.urlBlacklist.loadList(blacklistFiles.toArray(new BlacklistFile[blacklistFiles.size()]), "/");
        SearchEventCache.cleanupEvents(true);
    }
}

