/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.IOException;
import java.util.Date;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.workflow.WorkflowJob;

public class Request
extends WorkflowJob {
    public static final Row rowdef = new Row("String urlhash-12, String initiator-12, String urlstring-2048, String refhash-12, String urlname-256, Cardinal appdate-8 {b256}, String profile-12, Cardinal depth-2 {b256}, Cardinal parentbr-3 {b256}, Cardinal forkfactor-4 {b256}, byte[] flags-4, Cardinal handle-4 {b256}, Cardinal loaddate-8 {b256}, Cardinal lastmodified-8 {b256}, Cardinal size-8 {b256}", (ByteOrder)Base64Order.enhancedCoder);
    public static final int descrLength = Request.rowdef.column((int)4).cellwidth;
    private byte[] initiator;
    private byte[] refhash;
    private DigestURL url;
    private String name;
    private long appdate;
    private String profileHandle;
    private int depth;
    private Bitfield flags;
    private String statusMessage;
    private int initialHash;
    private int timezoneOffset;

    public Request() {
        this.initiator = null;
        this.url = null;
        this.refhash = null;
        this.name = null;
        this.appdate = 0L;
        this.profileHandle = null;
        this.depth = 0;
        this.flags = null;
        this.statusMessage = null;
        this.initialHash = 0;
        this.status = 0;
        this.timezoneOffset = 0;
    }

    public Request(DigestURL url, byte[] referrerhash) {
        this(null, url, referrerhash, null, null, null, 0, 0);
    }

    public Request(byte[] initiator, DigestURL url, byte[] referrerhash, String name, Date appdate, String profileHandle, int depth, int timezoneOffset) {
        assert (url != null);
        assert (profileHandle == null || profileHandle.length() == 12) : profileHandle + " != 12";
        url.removeRef();
        this.initiator = initiator == null ? null : (initiator.length == 0 ? null : initiator);
        this.url = url;
        this.refhash = referrerhash;
        this.name = name == null ? "" : name;
        this.appdate = appdate == null ? 0L : appdate.getTime();
        this.profileHandle = profileHandle;
        this.depth = depth;
        this.timezoneOffset = timezoneOffset;
        this.flags = new Bitfield(rowdef.width(10));
        this.statusMessage = "loaded(args)";
        this.initialHash = url.hashCode();
        this.status = 0;
    }

    public Request(Row.Entry entry2) throws IOException {
        assert (entry2 != null);
        this.insertEntry(entry2);
    }

    private void insertEntry(Row.Entry entry2) throws IOException {
        try {
            String urlstring = entry2.getColUTF8(2);
            if (urlstring == null) {
                throw new IOException("url string is null");
            }
            this.initiator = entry2.getColBytes(1, true);
            this.initiator = this.initiator == null ? null : (this.initiator.length == 0 ? null : this.initiator);
            this.url = new DigestURL(urlstring, entry2.getPrimaryKeyBytes());
            this.refhash = entry2.empty(3) ? null : entry2.getColBytes(3, true);
            this.name = entry2.empty(4) ? "" : entry2.getColUTF8(4).trim();
            this.appdate = entry2.getColLong(5);
            this.profileHandle = entry2.empty(6) ? null : entry2.getColASCII(6).trim();
            this.depth = (int)entry2.getColLong(7);
            this.flags = new Bitfield(entry2.getColBytes(10, true));
            this.statusMessage = "loaded(kelondroRow.Entry)";
            this.initialHash = this.url.hashCode();
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage());
        }
    }

    public int hashCode() {
        return this.initialHash;
    }

    public void setStatus(String s, int code) {
        this.statusMessage = s;
        this.status = code;
    }

    public String getStatus() {
        return this.statusMessage;
    }

    public Row.Entry toRow() {
        byte[] appdatestr = NaturalOrder.encodeLong(this.appdate, rowdef.width(5));
        byte[] loaddatestr = NaturalOrder.encodeLong(0L, rowdef.width(12));
        byte[] serverdatestr = NaturalOrder.encodeLong(0L, rowdef.width(13));
        byte[] namebytes = UTF8.getBytes(this.name);
        byte[][] entry2 = new byte[][]{this.url.hash(), this.initiator, UTF8.getBytes(this.url.toNormalform(false)), this.refhash, namebytes, appdatestr, this.profileHandle == null ? null : ASCII.getBytes(this.profileHandle), NaturalOrder.encodeLong(this.depth, rowdef.width(7)), NaturalOrder.encodeLong(0L, rowdef.width(8)), NaturalOrder.encodeLong(0L, rowdef.width(9)), this.flags.bytes(), NaturalOrder.encodeLong(0L, rowdef.width(11)), loaddatestr, serverdatestr, new byte[0]};
        return rowdef.newEntry(entry2);
    }

    public DigestURL url() {
        return this.url;
    }

    public void redirectURL(DigestURL redirectedURL) {
        this.url = redirectedURL;
    }

    public byte[] referrerhash() {
        return this.refhash;
    }

    public byte[] initiator() {
        return this.initiator;
    }

    public boolean proxy() {
        return this.initiator() == null || this.initiator().length == 0;
    }

    public Date appdate() {
        return new Date(this.appdate);
    }

    public String name() {
        return this.name;
    }

    public int depth() {
        return this.depth;
    }

    public int timezoneOffset() {
        return this.timezoneOffset;
    }

    public String profileHandle() {
        assert (this.profileHandle == null || this.profileHandle.length() == 12) : this.profileHandle + " != 12";
        return this.profileHandle;
    }

    public String toString() {
        return this.url.toNormalform(true);
    }
}

