/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.crawler.Balancer;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.Latency;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.BufferedObjectIndex;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;

public class LegacyBalancer
implements Balancer {
    private static final String indexSuffix = "A.db";
    private static final int EcoFSBufferSize = 1000;
    private static final int objectIndexBufferSize = 1000;
    private static final int MAX_DOUBLE_PUSH_CHECK = 100000;
    private final File cacheStacksPath;
    private BufferedObjectIndex urlFileIndex;
    private final ConcurrentMap<String, HostHandles> domainStacks;
    private final HandleSet double_push_check;
    private long lastDomainStackFill;
    private int domStackInitSize;
    private final List<Map.Entry<String, byte[]>> zeroWaitingCandidates;
    private final Random random;

    @Override
    public int getOnDemandLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getExceed134217727() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LegacyBalancer(File cachePath, String stackname, boolean useTailCache, boolean exceed134217727) {
        this.cacheStacksPath = cachePath;
        this.domainStacks = new ConcurrentHashMap<String, HostHandles>();
        this.domStackInitSize = Integer.MAX_VALUE;
        this.double_push_check = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
        this.zeroWaitingCandidates = new ArrayList<Map.Entry<String, byte[]>>();
        this.random = new Random(System.currentTimeMillis());
        if (!cachePath.exists()) {
            cachePath.mkdir();
        }
        this.cacheStacksPath.mkdirs();
        File f = new File(this.cacheStacksPath, stackname + indexSuffix);
        try {
            this.urlFileIndex = new BufferedObjectIndex(new Table(f, Request.rowdef, 1000, 0, useTailCache, exceed134217727, true), 1000);
        }
        catch (SpaceExceededException e) {
            try {
                this.urlFileIndex = new BufferedObjectIndex(new Table(f, Request.rowdef, 0, 0, false, exceed134217727, true), 1000);
            }
            catch (SpaceExceededException e1) {
                ConcurrentLog.logException(e1);
            }
        }
        this.lastDomainStackFill = 0L;
        ConcurrentLog.info("LEGACY BALANCER", "opened balancer file with " + this.urlFileIndex.size() + " entries from " + f.toString());
    }

    @Override
    public synchronized void close() {
        if (this.urlFileIndex != null) {
            this.urlFileIndex.close();
            this.urlFileIndex = null;
        }
    }

    @Override
    public void clear() {
        ConcurrentLog.info("LEGACY BALANCER", "cleaning balancer with " + this.urlFileIndex.size() + " entries from " + this.urlFileIndex.filename());
        try {
            this.urlFileIndex.clear();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.domainStacks.clear();
        this.double_push_check.clear();
    }

    @Override
    public Request get(byte[] urlhash) throws IOException {
        assert (urlhash != null);
        if (this.urlFileIndex == null) {
            return null;
        }
        Row.Entry entry2 = this.urlFileIndex.get(urlhash, false);
        if (entry2 == null) {
            return null;
        }
        return new Request(entry2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllByProfileHandle(String profileHandle, long timeout) throws IOException, SpaceExceededException {
        RowHandleSet urlHashes = new RowHandleSet(this.urlFileIndex.row().primaryKeyLength, (ByteOrder)Base64Order.enhancedCoder, 100);
        long terminate = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : (timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE);
        LegacyBalancer legacyBalancer = this;
        synchronized (legacyBalancer) {
            CloneableIterator<Row.Entry> i = this.urlFileIndex.rows();
            while (i.hasNext() && System.currentTimeMillis() < terminate) {
                Row.Entry rowEntry = (Row.Entry)i.next();
                Request crawlEntry = new Request(rowEntry);
                if (!crawlEntry.profileHandle().equals(profileHandle)) continue;
                urlHashes.put(crawlEntry.url().hash());
            }
        }
        return this.remove(urlHashes);
    }

    @Override
    public synchronized int remove(HandleSet urlHashes) throws IOException {
        int s = this.urlFileIndex.size();
        int removedCounter = 0;
        for (byte[] urlhash : urlHashes) {
            Row.Entry entry2 = this.urlFileIndex.remove(urlhash);
            if (entry2 != null) {
                ++removedCounter;
            }
            this.double_push_check.remove(urlhash);
        }
        if (removedCounter == 0) {
            return 0;
        }
        assert (this.urlFileIndex.size() + removedCounter == s) : "urlFileIndex.size() = " + this.urlFileIndex.size() + ", s = " + s;
        Iterator q = this.domainStacks.entrySet().iterator();
        while (q.hasNext()) {
            HandleSet stack = ((HostHandles)q.next().getValue()).handleSet;
            for (byte[] handle : urlHashes) {
                stack.remove(handle);
            }
            if (!stack.isEmpty()) continue;
            q.remove();
        }
        Iterator<Map.Entry<String, byte[]>> i = this.zeroWaitingCandidates.iterator();
        while (i.hasNext()) {
            if (!urlHashes.has(i.next().getValue())) continue;
            i.remove();
        }
        return removedCounter;
    }

    @Override
    public boolean has(byte[] urlhashb) {
        return this.urlFileIndex.has(urlhashb) || this.double_push_check.has(urlhashb);
    }

    @Override
    public int size() {
        return this.urlFileIndex.size();
    }

    @Override
    public boolean isEmpty() {
        return this.urlFileIndex.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String push(Request entry2, CrawlProfile profile2, RobotsTxt robots2) throws IOException, SpaceExceededException {
        assert (entry2 != null);
        byte[] hash = entry2.url().hash();
        LegacyBalancer legacyBalancer = this;
        synchronized (legacyBalancer) {
            if (this.double_push_check.has(hash)) {
                return "double occurrence in double_push_check";
            }
            if (this.urlFileIndex.has(hash)) {
                return "double occurrence in urlFileIndex";
            }
            if (this.double_push_check.size() > 100000 || MemoryControl.shortStatus()) {
                this.double_push_check.clear();
            }
            this.double_push_check.put(hash);
            if (profile2 != null && profile2.domMaxPages() != Integer.MAX_VALUE && profile2.domMaxPages() > 0) {
                profile2.domInc(entry2.url().getHost());
            }
            int s = this.urlFileIndex.size();
            this.urlFileIndex.put(entry2.toRow());
            assert (s < this.urlFileIndex.size()) : "hash = " + ASCII.String(hash) + ", s = " + s + ", size = " + this.urlFileIndex.size();
            assert (this.urlFileIndex.has(hash)) : "hash = " + ASCII.String(hash);
        }
        robots2.ensureExist(entry2.url(), profile2.getAgent(), true);
        return null;
    }

    @Override
    public Map<String, Integer[]> getDomainStackHosts(RobotsTxt robots2) {
        TreeMap<String, Integer[]> map = new TreeMap<String, Integer[]>();
        for (Map.Entry entry2 : this.domainStacks.entrySet()) {
            String hostname = (String)entry2.getKey();
            HostHandles hosthandles = (HostHandles)entry2.getValue();
            int size = hosthandles.handleSet.size();
            int delta = Latency.waitingRemainingGuessed(hostname, 80, hosthandles.hosthash, robots2, ClientIdentification.yacyInternetCrawlerAgent);
            map.put(hostname, new Integer[]{size, delta});
        }
        return map;
    }

    @Override
    public List<Request> getDomainStackReferences(String host, int maxcount, long maxtime) {
        HostHandles hh = (HostHandles)this.domainStacks.get(host);
        if (hh == null) {
            return new ArrayList<Request>(0);
        }
        HandleSet domainList = hh.handleSet;
        if (domainList.isEmpty()) {
            return new ArrayList<Request>(0);
        }
        maxcount = Math.min(maxcount, domainList.size());
        ArrayList<Request> cel = new ArrayList<Request>(maxcount);
        long timeout = maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime;
        for (int i = 0; i < maxcount; ++i) {
            Request crawlEntry;
            Row.Entry rowEntry;
            byte[] urlhash = domainList.getOne(i);
            if (urlhash == null) continue;
            try {
                rowEntry = this.urlFileIndex.get(urlhash, true);
            }
            catch (IOException e) {
                continue;
            }
            if (rowEntry == null) continue;
            try {
                crawlEntry = new Request(rowEntry);
            }
            catch (IOException e) {
                continue;
            }
            cel.add(crawlEntry);
            if (System.currentTimeMillis() > timeout) break;
        }
        return cel;
    }

    private void pushHashToDomainStacks(String host, String hosthash, byte[] urlhash) throws SpaceExceededException {
        HostHandles hh;
        if (host == null) {
            host = "localhost";
        }
        if ((hh = (HostHandles)this.domainStacks.get(host)) == null) {
            RowHandleSet domainList = new RowHandleSet(12, (ByteOrder)Base64Order.enhancedCoder, 1);
            domainList.put(urlhash);
            this.domainStacks.put(host, new HostHandles(hosthash, domainList));
        } else {
            HandleSet domainList = hh.handleSet;
            domainList.put(urlhash);
        }
    }

    private void removeHashFromDomainStacks(String host, byte[] urlhash) {
        HostHandles hh;
        if (host == null) {
            host = "localhost";
        }
        if ((hh = (HostHandles)this.domainStacks.get(host)) == null) {
            this.domainStacks.remove(host);
            return;
        }
        HandleSet domainList = hh.handleSet;
        domainList.remove(urlhash);
        if (domainList.isEmpty()) {
            this.domainStacks.remove(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request pop(boolean delay, CrawlSwitchboard cs, RobotsTxt robots2) throws IOException {
        long sleeptime = 0L;
        Request crawlEntry = null;
        CrawlProfile profileEntry = null;
        byte[] failhash = null;
        while (!this.urlFileIndex.isEmpty()) {
            byte[] nexthash = this.getbest(robots2, cs);
            if (nexthash == null) {
                return null;
            }
            LegacyBalancer legacyBalancer = this;
            synchronized (legacyBalancer) {
                Row.Entry rowEntry;
                Row.Entry entry2 = rowEntry = nexthash == null ? null : this.urlFileIndex.remove(nexthash);
                if (rowEntry == null) {
                    continue;
                }
                crawlEntry = new Request(rowEntry);
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.CRAWLER, crawlEntry.url())) {
                    ConcurrentLog.fine("CRAWLER", "URL '" + String.valueOf(crawlEntry.url()) + "' is in blacklist.");
                    continue;
                }
                profileEntry = cs.get(UTF8.getBytes(crawlEntry.profileHandle()));
                if (profileEntry == null) {
                    ConcurrentLog.fine("LEGACY BALANCER", "no profile entry for handle " + crawlEntry.profileHandle());
                    continue;
                }
                sleeptime = Latency.getDomainSleepTime(robots2, profileEntry, crawlEntry.url());
                assert (Base64Order.enhancedCoder.equal(nexthash, rowEntry.getPrimaryKeyBytes())) : "result = " + ASCII.String(nexthash) + ", rowEntry.getPrimaryKeyBytes() = " + ASCII.String(rowEntry.getPrimaryKeyBytes());
                assert (Base64Order.enhancedCoder.equal(nexthash, crawlEntry.url().hash())) : "result = " + ASCII.String(nexthash) + ", crawlEntry.url().hash() = " + ASCII.String(crawlEntry.url().hash());
                if (failhash != null && Base64Order.enhancedCoder.equal(failhash, nexthash)) {
                }
                break;
            }
        }
        if (crawlEntry == null) {
            return null;
        }
        ClientIdentification.Agent agent = profileEntry == null ? ClientIdentification.yacyInternetCrawlerAgent : profileEntry.getAgent();
        long robotsTime = Latency.getRobotsTime(robots2, crawlEntry.url(), agent);
        Latency.updateAfterSelection(crawlEntry.url(), profileEntry == null ? 0L : robotsTime);
        if (delay && sleeptime > 0L) {
            ConcurrentLog.info("LEGACY BALANCER", "forcing crawl-delay of " + sleeptime + " milliseconds for " + crawlEntry.url().getHost() + ": " + Latency.waitingRemainingExplain(crawlEntry.url(), robots2, agent) + ", domainStacks.size() = " + this.domainStacks.size() + ", domainStacksInitSize = " + this.domStackInitSize);
            long loops = sleeptime / 1000L;
            long rest = sleeptime % 1000L;
            if (loops < 3L) {
                rest += 1000L * loops;
                loops = 0L;
            }
            String tname = Thread.currentThread().getName();
            Thread.currentThread().setName("Balancer waiting for " + crawlEntry.url().getHost() + ": " + sleeptime + " milliseconds");
            LegacyBalancer legacyBalancer = this;
            synchronized (legacyBalancer) {
                if (rest > 0L) {
                    try {
                        Thread.sleep(rest);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                int i = 0;
                while ((long)i < loops) {
                    ConcurrentLog.info("LEGACY BALANCER", "waiting for " + crawlEntry.url().getHost() + ": " + (loops - (long)i) + " seconds remaining...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            Thread.currentThread().setName(tname);
            Latency.updateAfterSelection(crawlEntry.url(), robotsTime);
        }
        return crawlEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getbest(RobotsTxt robots2, CrawlSwitchboard cs) {
        List<Map.Entry<String, byte[]>> list2 = this.zeroWaitingCandidates;
        synchronized (list2) {
            Iterator k;
            byte[] urlhash;
            if (this.zeroWaitingCandidates.size() > 0 && (urlhash = this.pickFromZeroWaiting()) != null) {
                return urlhash;
            }
            this.zeroWaitingCandidates.clear();
            try {
                this.fillDomainStacks();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            Iterator i = this.domainStacks.entrySet().iterator();
            OrderedScoreMap<AbstractMap.SimpleEntry<String, byte[]>> nextZeroCandidates = new OrderedScoreMap<AbstractMap.SimpleEntry<String, byte[]>>(null);
            OrderedScoreMap<AbstractMap.SimpleEntry<String, byte[]>> failoverCandidates = new OrderedScoreMap<AbstractMap.SimpleEntry<String, byte[]>>(null);
            int newCandidatesForward = 1;
            while (i.hasNext() && nextZeroCandidates.size() < 1000) {
                int w;
                Map.Entry entry2 = i.next();
                String hostname = (String)entry2.getKey();
                HostHandles hosthandles = (HostHandles)entry2.getValue();
                if (hosthandles.handleSet.isEmpty()) {
                    i.remove();
                    continue;
                }
                byte[] urlhash2 = hosthandles.handleSet.getOne(0);
                if (urlhash2 == null) continue;
                try {
                    Row.Entry rowEntry = this.urlFileIndex.get(urlhash2, false);
                    if (rowEntry == null) continue;
                    Request crawlEntry = new Request(rowEntry);
                    CrawlProfile profileEntry = cs.get(UTF8.getBytes(crawlEntry.profileHandle()));
                    if (profileEntry == null) {
                        ConcurrentLog.warn("LEGACY BALANCER", "no profile entry for handle " + crawlEntry.profileHandle());
                        continue;
                    }
                    w = Latency.waitingRemaining(crawlEntry.url(), robots2, profileEntry.getAgent());
                }
                catch (IOException e1) {
                    ConcurrentLog.warn("LEGACY BALANCER", e1.getMessage(), e1);
                    continue;
                }
                if (w <= 0) {
                    if (w == Integer.MIN_VALUE) {
                        if (newCandidatesForward-- > 0) {
                            nextZeroCandidates.set(new AbstractMap.SimpleEntry<String, byte[]>(hostname, urlhash2), 10000);
                            continue;
                        }
                        failoverCandidates.set(new AbstractMap.SimpleEntry<String, byte[]>(hostname, urlhash2), 0);
                        continue;
                    }
                    nextZeroCandidates.set(new AbstractMap.SimpleEntry<String, byte[]>(hostname, urlhash2), hosthandles.handleSet.size());
                    continue;
                }
                failoverCandidates.set(new AbstractMap.SimpleEntry<String, byte[]>(hostname, urlhash2), w);
            }
            if (!nextZeroCandidates.isEmpty()) {
                int pick = nextZeroCandidates.size() <= 10 ? nextZeroCandidates.size() : Math.max(1, nextZeroCandidates.size() / 3);
                Iterator k2 = nextZeroCandidates.keys(false);
                while (k2.hasNext() && pick-- > 0) {
                    this.zeroWaitingCandidates.add((Map.Entry)k2.next());
                }
                return this.pickFromZeroWaiting();
            }
            if (!failoverCandidates.isEmpty() && (k = failoverCandidates.keys(true)).hasNext()) {
                Map.Entry hosthash = (Map.Entry)k.next();
                String besthost = (String)hosthash.getKey();
                byte[] besturlhash = (byte[])hosthash.getValue();
                this.removeHashFromDomainStacks(besthost, besturlhash);
                return besturlhash;
            }
            return null;
        }
    }

    private byte[] pickFromZeroWaiting() {
        String host = null;
        byte[] hash = null;
        while (this.zeroWaitingCandidates.size() > 0) {
            Map.Entry<String, byte[]> z = this.zeroWaitingCandidates.remove(this.random.nextInt(this.zeroWaitingCandidates.size()));
            HostHandles hh = (HostHandles)this.domainStacks.get(z.getKey());
            if (hh == null || (host = z.getKey()) == null || (hash = z.getValue()) == null) continue;
            this.removeHashFromDomainStacks(host, hash);
            ConcurrentLog.info("LEGACY BALANCER", "// getbest: picked a random from the zero-waiting stack: " + host + ", zeroWaitingCandidates.size = " + this.zeroWaitingCandidates.size());
            return hash;
        }
        this.zeroWaitingCandidates.clear();
        return null;
    }

    private void fillDomainStacks() throws IOException {
        if (!this.domainStacks.isEmpty() && System.currentTimeMillis() - this.lastDomainStackFill < 60000L) {
            return;
        }
        this.domainStacks.clear();
        this.lastDomainStackFill = System.currentTimeMillis();
        RowHandleSet blackhandles = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 10);
        int count = 0;
        long timeout = System.currentTimeMillis() + 5000L;
        for (Row.Entry entry2 : this.urlFileIndex.random(10000)) {
            if (entry2 == null) continue;
            Request request = new Request(entry2);
            if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.CRAWLER, request.url())) {
                ConcurrentLog.fine("CRAWLER", "URL '" + String.valueOf(request.url()) + "' is in blacklist.");
                try {
                    blackhandles.put(entry2.getPrimaryKeyBytes());
                }
                catch (SpaceExceededException spaceExceededException) {}
                continue;
            }
            String host = request.url().getHost();
            try {
                this.pushHashToDomainStacks(host, request.url().hosthash(), entry2.getPrimaryKeyBytes());
            }
            catch (SpaceExceededException e) {
                break;
            }
            if (this.domainStacks.size() < 1000 && ++count < 100000 && System.currentTimeMillis() <= timeout) continue;
            break;
        }
        for (byte[] blackhandle : blackhandles) {
            this.urlFileIndex.remove(blackhandle);
        }
        ConcurrentLog.info("LEGACY BALANCER", "re-fill of domain stacks; fileIndex.size() = " + this.urlFileIndex.size() + ", domainStacks.size = " + this.domainStacks.size() + ", blackhandles = " + blackhandles.size() + ", collection time = " + (System.currentTimeMillis() - this.lastDomainStackFill) + " ms");
        this.domStackInitSize = this.domainStacks.size();
    }

    @Override
    public Iterator<Request> iterator() throws IOException {
        return new EntryIterator();
    }

    @Override
    public int removeAllByHostHashes(Set<String> hosthashes) {
        return 0;
    }

    private static class HostHandles {
        public String hosthash;
        public HandleSet handleSet;

        public HostHandles(String hosthash, HandleSet handleSet) {
            this.hosthash = hosthash;
            this.handleSet = handleSet;
        }
    }

    private class EntryIterator
    implements Iterator<Request> {
        private Iterator<Row.Entry> rowIterator;

        public EntryIterator() throws IOException {
            this.rowIterator = LegacyBalancer.this.urlFileIndex.rows();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator == null ? false : this.rowIterator.hasNext();
        }

        @Override
        public Request next() {
            Row.Entry entry2 = this.rowIterator.next();
            try {
                return entry2 == null ? null : new Request(entry2);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                this.rowIterator = null;
                return null;
            }
        }

        @Override
        public void remove() {
            if (this.rowIterator != null) {
                this.rowIterator.remove();
            }
        }
    }
}

