/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.util.HashMap;
import net.yacy.cora.document.encoding.UTF8;

public class ByteArray {
    private final byte[] buffer;
    private int hashCache = Integer.MIN_VALUE;

    public ByteArray(byte[] bb) {
        this.buffer = bb;
    }

    public long usedMemory() {
        return this.buffer.length;
    }

    public byte[] asBytes() {
        return this.buffer;
    }

    public static boolean startsWith(byte[] buffer, byte[] pattern) {
        if (buffer == null && pattern == null) {
            return true;
        }
        if (buffer == null || pattern == null) {
            return false;
        }
        if (buffer.length < pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (buffer[i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            this.hashCache = ByteArray.hashCode(this.buffer);
        }
        return this.hashCache;
    }

    public static int hashCode(byte[] b) {
        int h = 0;
        for (byte c : b) {
            h = 31 * h + (c & 0xFF);
        }
        return h;
    }

    public boolean equals(Object other) {
        ByteArray b = (ByteArray)other;
        if (this.buffer == null && b == null) {
            return true;
        }
        if (this.buffer == null || b == null) {
            return false;
        }
        if (this.buffer.length != b.buffer.length) {
            return false;
        }
        int l = this.buffer.length;
        while (--l >= 0) {
            if (this.buffer[l] == b.buffer[l]) continue;
            return false;
        }
        return true;
    }

    public static long parseDecimal(byte[] s) throws NumberFormatException {
        long digit;
        long limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length;
        if (max <= 0) {
            throw new NumberFormatException(UTF8.String(s));
        }
        if (s[0] == 45) {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long multmin = limit / 10L;
        if (i < max) {
            if ((digit = (long)(s[i++] - 48)) < 0L) {
                throw new NumberFormatException(UTF8.String(s));
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = (long)(s[i++] - 48)) < 0L) {
                throw new NumberFormatException(UTF8.String(s));
            }
            if (result < multmin) {
                throw new NumberFormatException(UTF8.String(s));
            }
            if ((result *= 10L) < limit + digit) {
                throw new NumberFormatException(UTF8.String(s));
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(UTF8.String(s));
        }
        return -result;
    }

    public static void main(String[] args) {
        ByteArray a0 = new ByteArray("abc".getBytes());
        ByteArray a1 = new ByteArray("abc".getBytes());
        ByteArray b = new ByteArray("bbb".getBytes());
        System.out.println("a0 " + (a0.equals(a1) ? "=" : "!=") + " a1");
        System.out.println("a0 " + (a0.equals(b) ? "=" : "!=") + " b");
        HashMap<ByteArray, Integer> map = new HashMap<ByteArray, Integer>();
        map.put(a0, 1);
        map.put(b, 2);
        System.out.println("map.size() = " + map.size());
        System.out.println("hashCode(a0) = " + a0.hashCode());
        System.out.println("UTF8.String(a0).hashCode = " + UTF8.String(a0.asBytes()).hashCode());
        System.out.println("hashCode(a1) = " + a1.hashCode());
        System.out.println("UTF8.String(a1).hashCode = " + UTF8.String(a1.asBytes()).hashCode());
        System.out.println("hashCode(b) = " + b.hashCode());
        System.out.println("a0 " + (map.containsKey(a0) ? "in" : "not in") + " map");
        System.out.println("a1 " + (map.containsKey(a1) ? "in" : "not in") + " map");
        System.out.println("b " + (map.containsKey(b) ? "in" : "not in") + " map");
        System.out.println("parseIntDecimal " + ByteArray.parseDecimal("6543".getBytes()));
    }
}

