/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import net.yacy.cora.util.StrictLimitInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class StrictSizeLimitEntityWrapper
extends HttpEntityWrapper {
    private InputStream content;
    private final long maxBytes;

    public StrictSizeLimitEntityWrapper(HttpEntity wrappedEntity, long maxBytes) {
        super(wrappedEntity);
        if (wrappedEntity == null) {
            throw new IllegalArgumentException("The wrappedEntity parameter must not be null.");
        }
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("The maxBytes parameter must be greater or equal than zero.");
        }
        this.maxBytes = maxBytes;
    }

    private InputStream getWrappedStream() throws IOException {
        InputStream in = this.wrappedEntity.getContent();
        if (in == null) {
            return in;
        }
        return new StrictLimitInputStream(in, this.maxBytes);
    }

    public InputStream getContent() throws IOException {
        InputStream result = this.content == null ? (this.content = this.getWrappedStream()) : this.content;
        return result;
    }
}

