/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ConnectionInfo
implements Comparable<ConnectionInfo> {
    private static final Set<ConnectionInfo> allConnections = Collections.synchronizedSet(new HashSet());
    private static final Set<ConnectionInfo> serverConnections = Collections.synchronizedSet(new HashSet());
    private static final int staleAfterMillis = 1800000;
    private static int maxcount = 20;
    private static int serverMaxCount = 50;
    private final String protocol;
    private final String targetHost;
    private final String command;
    private final int id;
    private final long initTime;
    private final long upbytes;

    public ConnectionInfo(String protocol, String targetHost, String command, int id, long initTime, long upbytes) {
        this.protocol = protocol;
        this.targetHost = targetHost;
        this.command = command;
        this.id = id;
        this.initTime = initTime;
        this.upbytes = upbytes;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public long getLifetime() {
        return System.currentTimeMillis() - this.initTime;
    }

    public long getUpbytes() {
        return this.upbytes;
    }

    public String getCommand() {
        return this.command;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public int getID() {
        return this.id;
    }

    public static Set<ConnectionInfo> getAllConnections() {
        return allConnections;
    }

    public static Set<ConnectionInfo> getServerConnections() {
        return serverConnections;
    }

    public static int getCount() {
        return ConnectionInfo.getAllConnections().size();
    }

    public static int getServerCount() {
        return ConnectionInfo.getServerConnections().size();
    }

    public static int getLoadPercent() {
        return ConnectionInfo.getCount() * 100 / ConnectionInfo.getMaxcount();
    }

    public static boolean isServerCountReached() {
        return ConnectionInfo.getServerCount() >= ConnectionInfo.getServerMaxcount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getActiveUpbytes() {
        Iterator<ConnectionInfo> iter;
        long up = 0L;
        Iterator<ConnectionInfo> iterator = iter = ConnectionInfo.getAllConnections().iterator();
        synchronized (iterator) {
            while (iter.hasNext()) {
                ConnectionInfo con = iter.next();
                up += con.getUpbytes();
            }
        }
        return up;
    }

    public static int getMaxcount() {
        return maxcount;
    }

    public static void setMaxcount(int max) {
        if (max > 0) {
            maxcount = max;
        }
    }

    public static int getServerMaxcount() {
        return serverMaxCount;
    }

    public static void setServerMaxcount(int max) {
        if (max > 0) {
            serverMaxCount = max;
        }
    }

    public static void addConnection(ConnectionInfo conInfo) {
        ConnectionInfo.getAllConnections().add(conInfo);
    }

    public static void addServerConnection(ConnectionInfo conInfo) {
        ConnectionInfo.getServerConnections().add(conInfo);
    }

    protected static void removeConnection(ConnectionInfo conInfo) {
        ConnectionInfo.getAllConnections().remove(conInfo);
    }

    public static void removeServerConnection(ConnectionInfo conInfo) {
        ConnectionInfo.getServerConnections().remove(conInfo);
    }

    public static void removeConnection(int id) {
        ConnectionInfo.removeConnection(new ConnectionInfo(null, null, null, id, 0L, 0L));
    }

    public static void removeServerConnection(int id) {
        ConnectionInfo.removeServerConnection(new ConnectionInfo(null, null, null, id, 0L, 0L));
    }

    public static void cleanUp() {
        ConnectionInfo.cleanup(ConnectionInfo.getAllConnections());
        ConnectionInfo.cleanup(ConnectionInfo.getServerConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void cleanup(Set<ConnectionInfo> connectionSet) {
        Iterator<ConnectionInfo> iter;
        Iterator<ConnectionInfo> iterator = iter = connectionSet.iterator();
        // MONITORENTER : iterator
        while (true) {
            if (!iter.hasNext()) {
                // MONITOREXIT : iterator
                return;
            }
            ConnectionInfo con = null;
            try {
                con = iter.next();
            }
            catch (Throwable e) {
                return;
            }
            try {
                if (con.getLifetime() <= 1800000L) continue;
                connectionSet.remove(con);
            }
            catch (Throwable e) {
            }
        }
    }

    public String toString() {
        StringBuilder string = new StringBuilder(50);
        string.append("ID ");
        string.append(this.getID());
        string.append(", ");
        string.append(this.getProtocol());
        string.append("://");
        string.append(this.getTargetHost());
        string.append(" ");
        string.append(this.getCommand());
        string.append(", since ");
        string.append(this.getLifetime());
        string.append(" ms");
        return string.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionInfo other = (ConnectionInfo)obj;
        return this.id == other.id;
    }

    @Override
    public int compareTo(ConnectionInfo o) {
        if (o == null) {
            throw new NullPointerException("ConnectionInfo: compare() : passed argument is null \n");
        }
        if (this.initTime > o.initTime) {
            return 1;
        }
        if (this.initTime < o.initTime) {
            return -1;
        }
        return 0;
    }
}

