/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.order;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Random;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.AbstractOrder;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.order.Order;

public class Base64Order
extends AbstractOrder<byte[]>
implements ByteOrder,
Comparator<byte[]>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 980647587445343851L;
    public static final byte[] alpha_standard;
    public static final byte[] alpha_enhanced;
    private static final byte[] ahpla_standard;
    private static final byte[] ahpla_enhanced;
    public static final Base64Order standardCoder;
    public static final Base64Order enhancedCoder;
    private final boolean rfc1521compliant;
    private final byte[] alpha;
    private final byte[] ahpla;
    private final byte[] ab;
    static final Pattern cr;

    public Base64Order(boolean up, boolean rfc1521compliant) {
        this.rfc1521compliant = rfc1521compliant;
        this.asc = up;
        this.alpha = rfc1521compliant ? alpha_standard : alpha_enhanced;
        this.ahpla = rfc1521compliant ? ahpla_standard : ahpla_enhanced;
        this.ab = new byte[16384];
        for (byte ac : this.alpha) {
            for (byte bc : this.alpha) {
                byte acc = this.ahpla[ac];
                byte bcc = this.ahpla[bc];
                int c = 0;
                if (acc > bcc) {
                    c = 1;
                }
                if (acc < bcc) {
                    c = -1;
                }
                this.ab[ac << 7 | bc] = c;
            }
        }
    }

    public static byte[] zero(int length) {
        byte[] z = new byte[length];
        while (length > 0) {
            z[--length] = alpha_standard[0];
        }
        return z;
    }

    @Override
    public Order<byte[]> clone() {
        Base64Order o = new Base64Order(this.asc, this.rfc1521compliant);
        o.rotate((byte[])this.zero);
        return o;
    }

    @Override
    public final boolean wellformed(byte[] a) {
        return this.wellformed(a, 0, a.length);
    }

    @Override
    public final boolean wellformed(byte[] a, int astart, int alength) {
        assert (astart + alength <= a.length) : "astart = " + astart + ", alength = " + alength + ", a.length = " + a.length;
        for (int i = astart + alength - 1; i >= astart; --i) {
            byte b = a[i];
            if (b >= 0 && b < 128 && this.ahpla[b] != -1) continue;
            return false;
        }
        return true;
    }

    public static final ByteOrder bySignature(String signature) {
        if ("Bd".equals(signature)) {
            return new Base64Order(false, false);
        }
        if ("bd".equals(signature)) {
            return new Base64Order(false, true);
        }
        if ("Bu".equals(signature)) {
            return new Base64Order(true, false);
        }
        if ("bu".equals(signature)) {
            return new Base64Order(true, true);
        }
        return null;
    }

    @Override
    public final String signature() {
        if (!this.asc && !this.rfc1521compliant) {
            return "Bd";
        }
        if (!this.asc && this.rfc1521compliant) {
            return "bd";
        }
        if (this.asc && !this.rfc1521compliant) {
            return "Bu";
        }
        if (this.asc && this.rfc1521compliant) {
            return "bu";
        }
        return null;
    }

    public final char encodeByte(byte b) {
        return (char)this.alpha[b];
    }

    public final byte decodeByte(byte b) {
        return this.ahpla[b];
    }

    public final byte decodeByte(char b) {
        return this.ahpla[b];
    }

    public final StringBuilder encodeLongSB(long c, int length) {
        StringBuilder s = new StringBuilder(length);
        s.setLength(length);
        while (length > 0) {
            s.setCharAt(--length, (char)this.alpha[(byte)(c & 0x3FL)]);
            c >>= 6;
        }
        return s;
    }

    public final byte[] encodeLongBA(long c, int length) {
        byte[] s = new byte[length];
        while (length > 0) {
            s[--length] = this.alpha[(byte)(c & 0x3FL)];
            c >>= 6;
        }
        return s;
    }

    public final void encodeLong(long c, byte[] b, int offset, int length) {
        assert (offset + length <= b.length);
        while (length > 0) {
            b[--length + offset] = this.alpha[(byte)(c & 0x3FL)];
            c >>= 6;
        }
    }

    public final long decodeLong(String s) {
        while (s.endsWith("=")) {
            s = s.substring(0, s.length() - 1);
        }
        long c = 0L;
        for (int i = 0; i < s.length(); ++i) {
            c = c << 6 | (long)this.ahpla[s.charAt(i)];
        }
        return c;
    }

    public final long decodeLong(byte[] s, int offset, int length) {
        while (length > 0 && s[offset + length - 1] == 61) {
            --length;
        }
        long c = 0L;
        for (int i = 0; i < length; ++i) {
            c = c << 6 | (long)this.ahpla[s[offset + i]];
        }
        return c;
    }

    public static long max(int len) {
        long c = 0L;
        for (int i = 0; i < len; ++i) {
            c = c << 6 | 0x3FL;
        }
        return c;
    }

    public final String encodeString(String in) {
        return this.encode(UTF8.getBytes(in));
    }

    public final String encode(byte[] in) {
        int rfc1521compliantLength = (in.length + 2) / 3 * 4;
        if (!this.rfc1521compliant) {
            rfc1521compliantLength -= in.length % 3 == 2 ? 1 : (in.length % 3 == 1 ? 2 : 0);
        }
        return ASCII.String(this.encodeSubstring(in, rfc1521compliantLength));
    }

    public final byte[] encodeSubstring(byte[] in, int sublen) {
        int writepos;
        if (in.length == 0) {
            return new byte[0];
        }
        assert (sublen <= (in.length + 2) / 3 * 4) : "sublen = " + sublen + ", expected: " + (in.length + 2) / 3 * 4;
        byte[] out = new byte[sublen];
        int pos = 0;
        for (writepos = 0; in.length - pos >= 3 && writepos < sublen; writepos += 4) {
            long l = ((0xFFL & (long)in[pos++]) << 8 | 0xFFL & (long)in[pos++]) << 8 | 0xFFL & (long)in[pos++];
            this.encodeLong(l, out, writepos, 4);
        }
        if (in.length % 3 != 0 && writepos < sublen) {
            if (in.length % 3 == 2) {
                long c = ((0xFFL & (long)in[pos]) << 8) + (0xFFL & (long)in[pos + 1]) << 2;
                out[writepos + 2] = this.alpha[(byte)(c & 0x3FL)];
                out[writepos + 1] = this.alpha[(byte)((c >>= 6) & 0x3FL)];
                out[writepos] = this.alpha[(byte)((c >>= 6) & 0x3FL)];
                c >>= 6;
                if (this.rfc1521compliant && (writepos += 3) < sublen) {
                    out[writepos++] = 61;
                }
            } else {
                long c = (0xFFL & (long)in[pos]) << 4;
                out[writepos + 1] = this.alpha[(byte)(c & 0x3FL)];
                out[writepos] = this.alpha[(byte)((c >>= 6) & 0x3FL)];
                c >>= 6;
                writepos += 2;
                if (this.rfc1521compliant) {
                    if (writepos < sublen) {
                        out[writepos++] = 61;
                    }
                    if (writepos < sublen) {
                        out[writepos++] = 61;
                    }
                }
            }
        }
        return out;
    }

    public final String decodeString(String in) {
        return UTF8.String(this.decode(in));
    }

    public final byte[] decode(String in) {
        if (in == null || in.isEmpty()) {
            return new byte[0];
        }
        in = cr.matcher(in).replaceAll("");
        try {
            long l;
            int posIn = 0;
            int posOut = 0;
            if (this.rfc1521compliant) {
                while (in.charAt(in.length() - 1) == '=') {
                    in = in.substring(0, in.length() - 1);
                }
            }
            byte[] out = new byte[in.length() / 4 * 3 + (in.length() % 4 == 0 ? 0 : in.length() % 4 - 1)];
            while (posIn + 3 < in.length()) {
                l = this.decodeLong(in.substring(posIn, posIn + 4));
                out[posOut + 2] = (byte)(l % 256L);
                out[posOut + 1] = (byte)((l /= 256L) % 256L);
                out[posOut] = (byte)((l /= 256L) % 256L);
                l /= 256L;
                posIn += 4;
                posOut += 3;
            }
            if (posIn < in.length()) {
                if (in.length() - posIn == 3) {
                    l = this.decodeLong(in.substring(posIn) + "A");
                    out[posOut + 1] = (byte)((l /= 256L) % 256L);
                    out[posOut] = (byte)((l /= 256L) % 256L);
                    l /= 256L;
                } else {
                    l = this.decodeLong(in.substring(posIn) + "AA");
                    l = l / 256L / 256L;
                    out[posOut] = (byte)(l % 256L);
                    l /= 256L;
                }
            }
            return out;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("wrong string receive: " + in);
            return new byte[0];
        }
    }

    private final long cardinalI(String key) {
        long c = 0L;
        int p = 0;
        while (p < 10 && p < key.length()) {
            byte b;
            if ((b = this.ahpla[key.charAt(p++)]) < 0) {
                return -1L;
            }
            c = c << 6 | (long)b;
        }
        while (p++ < 10) {
            c <<= 6;
        }
        c = c << 3 | 7L;
        assert (c >= 0L);
        return c;
    }

    private final long cardinalI(byte[] key, int off, int len) {
        long c = 0L;
        int lim = off + Math.min(10, len);
        int lim10 = off + 10;
        while (off < lim) {
            byte b;
            if ((b = key[off++]) < 0) {
                return -1L;
            }
            if ((b = this.ahpla[b]) < 0) {
                return -1L;
            }
            c = c << 6 | (long)b;
        }
        while (off++ < lim10) {
            c <<= 6;
        }
        c = c << 3 | 7L;
        assert (c >= 0L);
        return c;
    }

    public final byte[] uncardinal(long c) {
        c >>= 3;
        byte[] b = new byte[12];
        for (int p = 9; p >= 0; --p) {
            b[p] = this.alpha[(int)(c & 0x3FL)];
            c >>= 6;
        }
        b[10] = this.alpha[63];
        b[11] = this.alpha[63];
        return b;
    }

    @Override
    public final long cardinal(byte[] key) {
        if (this.zero == null) {
            return this.cardinalI(key, 0, key.length);
        }
        long zeroCardinal = this.cardinalI((byte[])this.zero, 0, ((byte[])this.zero).length);
        long keyCardinal = this.cardinalI(key, 0, key.length);
        if (keyCardinal > zeroCardinal) {
            return keyCardinal - zeroCardinal;
        }
        return Long.MAX_VALUE - keyCardinal + zeroCardinal;
    }

    @Override
    public final long cardinal(byte[] key, int off, int len) {
        if (this.zero == null) {
            return this.cardinalI(key, off, len);
        }
        long zeroCardinal = this.cardinalI((byte[])this.zero, 0, ((byte[])this.zero).length);
        long keyCardinal = this.cardinalI(key, off, len);
        if (keyCardinal > zeroCardinal) {
            return keyCardinal - zeroCardinal;
        }
        return Long.MAX_VALUE - keyCardinal + zeroCardinal;
    }

    @Override
    public final long cardinal(String key) {
        if (this.zero == null) {
            return this.cardinalI(key);
        }
        long zeroCardinal = this.cardinalI((byte[])this.zero, 0, ((byte[])this.zero).length);
        long keyCardinal = this.cardinalI(key);
        if (keyCardinal > zeroCardinal) {
            return keyCardinal - zeroCardinal;
        }
        return Long.MAX_VALUE - keyCardinal + zeroCardinal;
    }

    private static final int sig(int x) {
        return x > 0 ? 1 : (x < 0 ? -1 : 0);
    }

    @Override
    public final boolean equal(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int astart = 0;
        int bstart = 0;
        int length = a.length;
        while (length-- != 0) {
            if (a[astart++] == b[bstart++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equal(byte[] a, int astart, byte[] b, int bstart, int length) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        while (length-- != 0) {
            if (a[astart++] == b[bstart++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int compare(byte[] a, byte[] b) {
        try {
            return this.asc ? (this.zero == null ? this.compares(a, b) : this.compare0(a, b, a.length)) : (this.zero == null ? this.compares(b, a) : this.compare0(b, a, a.length));
        }
        catch (Throwable e) {
            boolean wfa = this.wellformed(a);
            boolean wfb = this.wellformed(b);
            if (wfa && wfb) {
                if (e instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            if (wfa) {
                return this.asc ? -1 : 1;
            }
            if (wfb) {
                return this.asc ? 1 : -1;
            }
            return (this.asc ? 1 : -1) * NaturalOrder.naturalOrder.compare(a, b);
        }
    }

    @Override
    public final int compare(byte[] a, byte[] b, int length) {
        try {
            return this.asc ? this.compare0(a, b, length) : this.compare0(b, a, length);
        }
        catch (Throwable e) {
            boolean wfa = this.wellformed(a, 0, length);
            boolean wfb = this.wellformed(b, 0, length);
            if (wfa && wfb) {
                if (e instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            if (wfa) {
                return this.asc ? -1 : 1;
            }
            if (wfb) {
                return this.asc ? 1 : -1;
            }
            return (this.asc ? 1 : -1) * NaturalOrder.naturalOrder.compare(a, b, length);
        }
    }

    @Override
    public final int compare(byte[] a, int aoffset, byte[] b, int boffset, int length) {
        try {
            return this.asc ? this.compare0(a, aoffset, b, boffset, length) : this.compare0(b, boffset, a, aoffset, length);
        }
        catch (Throwable e) {
            boolean wfa = this.wellformed(a, aoffset, length);
            boolean wfb = this.wellformed(b, boffset, length);
            if (wfa && wfb) {
                if (e instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            if (wfa) {
                return this.asc ? -1 : 1;
            }
            if (wfb) {
                return this.asc ? 1 : -1;
            }
            return (this.asc ? 1 : -1) * NaturalOrder.naturalOrder.compare(a, aoffset, b, boffset, length);
        }
    }

    private final int compare0(byte[] a, byte[] b, int length) {
        int bz;
        int az;
        if (this.zero == null) {
            return this.compares(a, b, length);
        }
        if (((byte[])this.zero).length < length) {
            length = ((byte[])this.zero).length;
        }
        if ((az = this.compares(a, (byte[])this.zero, length)) == (bz = this.compares(b, (byte[])this.zero, length))) {
            return this.compares(a, b, length);
        }
        return Base64Order.sig(az - bz);
    }

    private final int compare0(byte[] a, int aoffset, byte[] b, int boffset, int length) {
        int bz;
        int az;
        if (this.zero == null) {
            return this.compares(a, aoffset, b, boffset, length);
        }
        if (((byte[])this.zero).length < length) {
            length = ((byte[])this.zero).length;
        }
        if ((az = this.compares(a, aoffset, (byte[])this.zero, 0, length)) == (bz = this.compares(b, boffset, (byte[])this.zero, 0, length))) {
            return this.compares(a, aoffset, b, boffset, length);
        }
        return Base64Order.sig(az - bz);
    }

    private final int compares(byte[] a, byte[] b) {
        int al = a.length;
        int bl = b.length;
        short ml = (short)Math.min(al, bl);
        for (short i = 0; i < ml; i = (short)(i + 1)) {
            byte ac = a[i];
            byte bc = b[i];
            if (ac == bc) continue;
            return this.ab[ac << 7 | bc];
        }
        if (al > bl) {
            return 1;
        }
        if (al < bl) {
            return -1;
        }
        return 0;
    }

    private final int compares(byte[] a, byte[] b, int length) {
        for (int i = 0; i < length; i = (int)((short)(i + 1))) {
            byte ac = a[i];
            byte bc = b[i];
            if (ac == bc) continue;
            return this.ab[ac << 7 | bc];
        }
        return 0;
    }

    private final int compares(byte[] a, int aoffset, byte[] b, int boffset, int length) {
        for (int i = 0; i < length; i = (int)((short)(i + 1))) {
            byte ac = a[aoffset + i];
            byte bc = b[boffset + i];
            if (ac == bc) continue;
            return this.ab[ac << 7 | bc];
        }
        return 0;
    }

    public static void main(String[] s) {
        Base64Order b64 = new Base64Order(true, true);
        if (s.length == 0) {
            System.out.println("usage: -[ec|dc|es|ds|clcn] <arg>");
            System.exit(0);
        }
        if ("-ec".equals(s[0])) {
            System.out.println(b64.encodeLongSB(Long.parseLong(s[1]), 4));
        }
        if ("-dc".equals(s[0])) {
            System.out.println(b64.decodeLong(s[1]));
        }
        if ("-es".equals(s[0])) {
            System.out.println(b64.encodeString(s[1]));
        }
        if ("-ds".equals(s[0])) {
            System.out.println(b64.decodeString(s[1]));
        }
        if ("-cl".equals(s[0])) {
            System.out.println(enhancedCoder.cardinal(s[1].getBytes()));
        }
        if ("-cn".equals(s[0])) {
            System.out.println((double)enhancedCoder.cardinal(s[1].getBytes()) / 9.223372036854776E18);
        }
        if ("-test".equals(s[0])) {
            System.out.println("Pid: " + ManagementFactory.getRuntimeMXBean().getName());
            Random r = new Random(0L);
            try {
                Class<?> rfc1521Decoder_class = Class.forName("sun.misc.BASE64Decoder");
                Object rfc1521Decoder = rfc1521Decoder_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method rfc1521Decoder_decodeBuffer = rfc1521Decoder_class.getMethod("decodeBuffer", String.class);
                Class<?> rfc1521Encoder_class = Class.forName("sun.misc.BASE64Encoder");
                Object rfc1521Encoder = rfc1521Encoder_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method rfc1521Encoder_encode = rfc1521Encoder_class.getMethod("encode", byte[].class);
                System.out.println("preparing tests..");
                int count = 100000;
                String[] challenges = new String[100000];
                String[] rfc1521Encoded = new String[100000];
                for (int i = 0; i < 100000; ++i) {
                    int len = r.nextInt(10000);
                    StringBuilder challenge = new StringBuilder(len);
                    for (int j = 0; j < len; ++j) {
                        challenge.append((char)(32 + r.nextInt(64)));
                    }
                    challenges[i] = challenge.toString();
                    rfc1521Encoded[i] = (String)rfc1521Encoder_encode.invoke(rfc1521Encoder, new Object[]{UTF8.getBytes(challenges[i])});
                }
                long start = System.currentTimeMillis();
                for (Object rfc1521Compliant : (StringBuilder)new boolean[]{false, true}) {
                    String eb64;
                    Object rfc1521;
                    int i;
                    System.out.println("starting tests, rfc1521Compliant = " + (boolean)rfc1521Compliant + " ...");
                    for (i = 0; i < 100000; ++i) {
                        if (rfc1521Compliant != false) {
                            rfc1521 = standardCoder.encode(UTF8.getBytes(challenges[i]));
                        } else {
                            eb64 = enhancedCoder.encode(UTF8.getBytes(challenges[i]));
                            rfc1521 = new String(eb64);
                            while (((String)rfc1521).length() % 4 != 0) {
                                rfc1521 = (String)rfc1521 + "=";
                            }
                            rfc1521 = ((String)rfc1521).replace('-', '+').replace('_', '/');
                        }
                        String rfc1521Decoded = UTF8.String((byte[])rfc1521Decoder_decodeBuffer.invoke(rfc1521Decoder, rfc1521));
                        if (rfc1521Decoded.equals(challenges[i])) continue;
                        System.out.println("Encode enhancedB64 + Decode RFC1521: Fail for " + challenges[i]);
                    }
                    for (i = 0; i < 100000; ++i) {
                        rfc1521 = new String(rfc1521Encoded[i]);
                        if (rfc1521Compliant != false) {
                            String standardCoderDecoded = UTF8.String(standardCoder.decode((String)rfc1521));
                            if (standardCoderDecoded.equals(challenges[i])) continue;
                            System.out.println("Encode RFC1521 + Decode enhancedB64: Fail for " + (String)rfc1521);
                            continue;
                        }
                        eb64 = new String((String)rfc1521);
                        while (eb64.endsWith("=")) {
                            eb64 = eb64.substring(0, eb64.length() - 1);
                        }
                        String enhancedCoderDecoded = UTF8.String(enhancedCoder.decode(eb64 = eb64.replace('+', '-').replace('/', '_')));
                        if (enhancedCoderDecoded.equals(challenges[i])) continue;
                        System.out.println("Encode RFC1521 + Decode enhancedB64: Fail for " + eb64);
                    }
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("time: " + time / 1000L + " seconds, " + 1000L * time / 100000L + " ms / 1000 steps");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        int i;
        alpha_standard = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
        alpha_enhanced = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".getBytes();
        ahpla_standard = new byte[128];
        ahpla_enhanced = new byte[128];
        for (i = 0; i < 128; ++i) {
            Base64Order.ahpla_standard[i] = -1;
            Base64Order.ahpla_enhanced[i] = -1;
        }
        for (i = 0; i < alpha_standard.length; ++i) {
            Base64Order.ahpla_standard[Base64Order.alpha_standard[i]] = (byte)i;
            Base64Order.ahpla_enhanced[Base64Order.alpha_enhanced[i]] = (byte)i;
        }
        standardCoder = new Base64Order(true, true);
        enhancedCoder = new Base64Order(true, false);
        cr = Pattern.compile("\n");
    }
}

