/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.language.phonetic;

import net.yacy.cora.language.phonetic.ColognePhonetic;
import net.yacy.cora.language.phonetic.DoubleMetaphone;
import net.yacy.cora.language.phonetic.Metaphone;
import net.yacy.cora.language.phonetic.Soundex;

public class Phonetic {
    private static final Soundex soundexEncoder = new Soundex();
    private static final Metaphone metaphoneEncoder = new Metaphone();
    private static final DoubleMetaphone doubleMetaphoneEncoder = new DoubleMetaphone();
    private static final ColognePhonetic colognePhonetic = new ColognePhonetic();

    public static String encode(Encoder encoder, String s) {
        try {
            if (encoder == Encoder.SOUNDEX) {
                return soundexEncoder.encode(s);
            }
            if (encoder == Encoder.COLONE_PHONETIC) {
                return colognePhonetic.encode(s);
            }
            if (encoder == Encoder.METAPHONE) {
                return metaphoneEncoder.encode(s);
            }
            if (encoder == Encoder.DOUBLE_METAPHONE) {
                return doubleMetaphoneEncoder.encode(s);
            }
            return s;
        }
        catch (Throwable e) {
            return s;
        }
    }

    public static void main(String[] args) {
        for (Encoder encoder : Encoder.values()) {
            for (String s : args) {
                System.out.print(Phonetic.encode(encoder, s));
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    public static enum Encoder {
        SOUNDEX("Soundex", ""),
        COLONE_PHONETIC("Koelner Phonetik", "http://de.wikipedia.org/wiki/K%C3%B6lner_Phonetik"),
        METAPHONE("Metaphone", ""),
        DOUBLE_METAPHONE("Double Metaphone", ""),
        NONE("", "");

        final String printName;
        final String infoUrl;

        private Encoder(String printName, String infoUrl) {
            this.printName = printName;
            this.infoUrl = infoUrl;
        }
    }
}

