/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import net.yacy.cora.lod.vocabulary.DublinCore;
import net.yacy.cora.lod.vocabulary.Geo;
import net.yacy.cora.lod.vocabulary.YaCyMetadata;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.crawler.retrieval.Response;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;

public class OpensearchResponseWriter
implements QueryResponseWriter,
SolrjResponseWriter {
    private static final Map<String, String> field2tag = new HashMap<String, String>();
    private static final CollectionSchema[] extrafields = new CollectionSchema[]{CollectionSchema.id, CollectionSchema.title, CollectionSchema.description_txt, CollectionSchema.text_t, CollectionSchema.h1_txt, CollectionSchema.h2_txt, CollectionSchema.h3_txt, CollectionSchema.h4_txt, CollectionSchema.h5_txt, CollectionSchema.h6_txt};
    static final Set<String> SOLR_FIELDS = new HashSet<String>();
    private String title;
    static final Pattern keymarks;

    public void setTitle(String searchPageTitle) {
        this.title = searchPageTitle;
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/xml; charset=UTF-8";
    }

    public void init(NamedList n) {
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        NamedList values = rsp.getValues();
        Object responseObj = rsp.getResponse();
        assert (values.get("response") != null);
        this.write(writer, request, values, responseObj);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, String coreName, QueryResponse rsp) throws IOException {
        NamedList values = rsp.getResponse();
        SolrDocumentList documents = rsp.getResults();
        this.write(writer, request, values, documents);
    }

    private void write(Writer writer, SolrQueryRequest request, NamedList<?> values, Object responseObj) throws IOException {
        NamedList collections;
        DocList documents;
        HashMap<String, Collection<String>> snippets;
        ResHead resHead = new ResHead();
        resHead.rows = request.getOriginalParams().getLong("rows", -1L);
        SimpleOrderedMap facetCounts = (SimpleOrderedMap)values.get("facet_counts");
        SimpleOrderedMap facetFields = facetCounts == null || facetCounts.size() == 0 ? null : (SimpleOrderedMap)facetCounts.get("facet_fields");
        Object highlightingObj = values.get("highlighting");
        Map<Object, Object> map = snippets = highlightingObj instanceof NamedList ? OpensearchResponseWriter.snippetsFromHighlighting((NamedList)highlightingObj) : new HashMap();
        if (responseObj instanceof ResultContext) {
            documents = ((ResultContext)responseObj).getDocList();
            resHead.offset = documents.offset();
            resHead.numFound = documents.matches();
            this.writeHeader(writer, resHead);
            this.writeDocs(writer, documents, request, snippets);
        } else if (responseObj instanceof SolrDocumentList) {
            documents = (SolrDocumentList)responseObj;
            resHead.offset = documents.getStart();
            resHead.numFound = documents.getNumFound();
            this.writeHeader(writer, resHead);
            this.writeDocs(writer, (SolrDocumentList)documents, snippets);
        } else {
            throw new IOException("Unable to process Solr response format");
        }
        OpensearchResponseWriter.openTag(writer, "yacy:navigation");
        NamedList domains = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.host_s.getSolrFieldName());
        NamedList filetypes = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.url_file_ext_s.getSolrFieldName());
        NamedList protocols = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.url_protocol_s.getSolrFieldName());
        NamedList authors = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.author_sxt.getSolrFieldName());
        NamedList namedList = collections = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.collection_sxt.getSolrFieldName());
        if (domains != null) {
            OpensearchResponseWriter.openTag(writer, "yacy:facet name=\"domains\" displayname=\"Domains\" type=\"String\" min=\"0\" max=\"0\" mean=\"0\"");
            for (Map.Entry entry2 : domains) {
                OpensearchResponseWriter.facetEntry(writer, "site", (String)entry2.getKey(), Integer.toString((Integer)entry2.getValue()));
            }
            OpensearchResponseWriter.closeTag(writer, "yacy:facet");
        }
        if (filetypes != null) {
            OpensearchResponseWriter.openTag(writer, "yacy:facet name=\"filetypes\" displayname=\"Filetypes\" type=\"String\" min=\"0\" max=\"0\" mean=\"0\"");
            for (Map.Entry entry2 : filetypes) {
                OpensearchResponseWriter.facetEntry(writer, "filetype", (String)entry2.getKey(), Integer.toString((Integer)entry2.getValue()));
            }
            OpensearchResponseWriter.closeTag(writer, "yacy:facet");
        }
        if (protocols != null) {
            OpensearchResponseWriter.openTag(writer, "yacy:facet name=\"protocols\" displayname=\"Protocols\" type=\"String\" min=\"0\" max=\"0\" mean=\"0\"");
            for (Map.Entry entry2 : protocols) {
                OpensearchResponseWriter.facetEntry(writer, "protocol", (String)entry2.getKey(), Integer.toString((Integer)entry2.getValue()));
            }
            OpensearchResponseWriter.closeTag(writer, "yacy:facet");
        }
        if (authors != null) {
            OpensearchResponseWriter.openTag(writer, "yacy:facet name=\"authors\" displayname=\"Authors\" type=\"String\" min=\"0\" max=\"0\" mean=\"0\"");
            for (Map.Entry entry2 : authors) {
                OpensearchResponseWriter.facetEntry(writer, "author", (String)entry2.getKey(), Integer.toString((Integer)entry2.getValue()));
            }
            OpensearchResponseWriter.closeTag(writer, "yacy:facet");
        }
        if (collections != null) {
            OpensearchResponseWriter.openTag(writer, "yacy:facet name=\"collections\" displayname=\"Collections\" type=\"String\" min=\"0\" max=\"0\" mean=\"0\"");
            for (Map.Entry entry2 : collections) {
                OpensearchResponseWriter.facetEntry(writer, "collection", (String)entry2.getKey(), Integer.toString((Integer)entry2.getValue()));
            }
            OpensearchResponseWriter.closeTag(writer, "yacy:facet");
        }
        OpensearchResponseWriter.closeTag(writer, "yacy:navigation");
        OpensearchResponseWriter.closeTag(writer, "channel");
        writer.write("</rss>\n".toCharArray());
    }

    private void writeHeader(Writer writer, ResHead resHead) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type='text/xsl' href='/yacysearch.xsl' version='1.0'?>\n<rss version=\"2.0\"\n    xmlns:yacy=\"http://www.yacy.net/\"\n    xmlns:opensearch=\"http://a9.com/-/spec/opensearch/1.1/\"\n    xmlns:media=\"http://search.yahoo.com/mrss/\"\n    xmlns:atom=\"http://www.w3.org/2005/Atom\"\n    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n    xmlns:geo=\"http://www.w3.org/2003/01/geo/wgs84_pos#\"\n>\n".toCharArray());
        OpensearchResponseWriter.openTag(writer, "channel");
        OpensearchResponseWriter.solitaireTag(writer, "opensearch:totalResults", Long.toString(resHead.numFound));
        OpensearchResponseWriter.solitaireTag(writer, "opensearch:startIndex", Long.toString(resHead.offset));
        OpensearchResponseWriter.solitaireTag(writer, "opensearch:itemsPerPage", Long.toString(resHead.rows));
        OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.title.name(), this.title);
        writer.write("<atom:link rel=\"search\" href=\"/opensearchdescription.xml\" type=\"application/opensearchdescription+xml\"/>");
        OpensearchResponseWriter.solitaireTag(writer, "description", "Search Result");
    }

    private void writeDocs(Writer writer, SolrDocumentList documents, Map<String, Collection<String>> snippets) throws IOException {
        String urlhash = null;
        MultiProtocolURL url = null;
        for (SolrDocument doc : documents) {
            OpensearchResponseWriter.openTag(writer, "item");
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<String> descriptions = new ArrayList<String>();
            String docTitle = "";
            ArrayList<Object> images_protocol_obj = new ArrayList<Object>();
            ArrayList<String> images_stub = new ArrayList<String>();
            for (Map.Entry fieldEntry : doc) {
                String fieldName = (String)fieldEntry.getKey();
                Object value = fieldEntry.getValue();
                if (value == null) continue;
                String stag = field2tag.get(fieldName);
                if (stag != null) {
                    OpensearchResponseWriter.solitaireTag(writer, stag, value.toString());
                    continue;
                }
                if (CollectionSchema.sku.getSolrFieldName().equals(fieldName)) {
                    url = this.writeLink(writer, value.toString());
                    continue;
                }
                if (CollectionSchema.id.getSolrFieldName().equals(fieldName)) {
                    urlhash = value.toString();
                    OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.guid.name(), urlhash, "isPermaLink=\"false\"");
                    continue;
                }
                if (CollectionSchema.title.getSolrFieldName().equals(fieldName)) {
                    if (value instanceof Iterable) {
                        for (Object valueItem : (Iterable)value) {
                            docTitle = valueItem.toString();
                            texts.add(docTitle);
                        }
                        continue;
                    }
                    docTitle = value.toString();
                    texts.add(docTitle);
                    continue;
                }
                if (CollectionSchema.last_modified.getSolrFieldName().equals(fieldName) && value instanceof Date) {
                    OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.pubDate.name(), HeaderFramework.formatRFC1123((Date)value));
                    continue;
                }
                if (CollectionSchema.description_txt.getSolrFieldName().equals(fieldName)) {
                    if (value instanceof Iterable) {
                        for (Object valueItem : (Iterable)value) {
                            String description = valueItem.toString();
                            descriptions.add(description);
                            texts.add(description);
                            OpensearchResponseWriter.solitaireTag(writer, DublinCore.Description.getURIref(), description);
                        }
                        continue;
                    }
                    String description = value.toString();
                    descriptions.add(description);
                    texts.add(description);
                    OpensearchResponseWriter.solitaireTag(writer, DublinCore.Description.getURIref(), description);
                    continue;
                }
                if (CollectionSchema.text_t.getSolrFieldName().equals(fieldName)) {
                    texts.add(value.toString());
                    continue;
                }
                if (CollectionSchema.size_i.getSolrFieldName().equals(fieldName) && value instanceof Integer) {
                    int size = (Integer)value;
                    OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.size.getURIref(), Integer.toString(size));
                    OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.sizename.getURIref(), RSSMessage.sizename(size));
                    continue;
                }
                if (CollectionSchema.h1_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h2_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h3_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h4_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h5_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h6_txt.getSolrFieldName().equals(fieldName)) {
                    if (value instanceof Iterable) {
                        for (Object valueItem : (Iterable)value) {
                            texts.add(valueItem.toString());
                        }
                        continue;
                    }
                    texts.add(value.toString());
                    continue;
                }
                if (CollectionSchema.images_protocol_sxt.getSolrFieldName().equals(fieldName)) {
                    if (value instanceof Iterable) {
                        for (Object valueItem : (Iterable)value) {
                            images_protocol_obj.add(valueItem.toString());
                        }
                        continue;
                    }
                    images_protocol_obj.add(value.toString());
                    continue;
                }
                if (!CollectionSchema.images_urlstub_sxt.getSolrFieldName().equals(fieldName)) continue;
                if (value instanceof Iterable) {
                    for (Object valueItem : (Iterable)value) {
                        images_stub.add(valueItem.toString());
                    }
                    continue;
                }
                images_stub.add(value.toString());
            }
            Object keywordsObj = doc.get((Object)CollectionSchema.keywords.getSolrFieldName());
            String keywords = keywordsObj instanceof String ? (String)keywordsObj : null;
            this.writeDocEnd(writer, snippets, urlhash, url, keywords, texts, descriptions, docTitle, images_protocol_obj, images_stub);
        }
    }

    private void writeDocs(Writer writer, DocList documents, SolrQueryRequest request, Map<String, Collection<String>> snippets) throws IOException {
        SolrIndexSearcher searcher = request.getSearcher();
        String urlhash = null;
        MultiProtocolURL url = null;
        DocIterator iterator = documents.iterator();
        while (iterator.hasNext()) {
            OpensearchResponseWriter.openTag(writer, "item");
            int id = iterator.nextDoc();
            Document doc = searcher.doc(id, SOLR_FIELDS);
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<String> descriptions = new ArrayList<String>();
            String docTitle = "";
            ArrayList<Object> images_protocol_obj = new ArrayList<Object>();
            ArrayList<String> images_stub = new ArrayList<String>();
            for (IndexableField value : doc.getFields()) {
                String fieldName = value.name();
                String stag = field2tag.get(fieldName);
                if (stag != null) {
                    OpensearchResponseWriter.solitaireTag(writer, stag, value.stringValue());
                    continue;
                }
                if (CollectionSchema.sku.getSolrFieldName().equals(fieldName)) {
                    url = this.writeLink(writer, value.stringValue());
                    continue;
                }
                if (CollectionSchema.id.getSolrFieldName().equals(fieldName)) {
                    urlhash = value.stringValue();
                    OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.guid.name(), urlhash, "isPermaLink=\"false\"");
                    continue;
                }
                if (CollectionSchema.title.getSolrFieldName().equals(fieldName)) {
                    docTitle = value.stringValue();
                    texts.add(docTitle);
                    continue;
                }
                if (CollectionSchema.last_modified.getSolrFieldName().equals(fieldName)) {
                    Date d = new Date(Long.parseLong(value.stringValue()));
                    OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.pubDate.name(), HeaderFramework.formatRFC1123(d));
                    continue;
                }
                if (CollectionSchema.description_txt.getSolrFieldName().equals(fieldName)) {
                    String description = value.stringValue();
                    descriptions.add(description);
                    OpensearchResponseWriter.solitaireTag(writer, DublinCore.Description.getURIref(), description);
                    texts.add(description);
                    continue;
                }
                if (CollectionSchema.text_t.getSolrFieldName().equals(fieldName)) {
                    texts.add(value.stringValue());
                    continue;
                }
                if (CollectionSchema.size_i.getSolrFieldName().equals(fieldName)) {
                    int size = value.numericValue().intValue();
                    OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.size.getURIref(), Integer.toString(size));
                    OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.sizename.getURIref(), RSSMessage.sizename(size));
                    continue;
                }
                if (CollectionSchema.h1_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h2_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h3_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h4_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h5_txt.getSolrFieldName().equals(fieldName) || CollectionSchema.h6_txt.getSolrFieldName().equals(fieldName)) {
                    texts.add(value.stringValue());
                    continue;
                }
                if (CollectionSchema.images_protocol_sxt.getSolrFieldName().equals(fieldName)) {
                    images_protocol_obj.add(value.stringValue());
                    continue;
                }
                if (!CollectionSchema.images_urlstub_sxt.getSolrFieldName().equals(fieldName)) continue;
                images_stub.add(value.stringValue());
            }
            String keywordsObj = doc.get(CollectionSchema.keywords.getSolrFieldName());
            String keywords = keywordsObj instanceof String ? keywordsObj : null;
            this.writeDocEnd(writer, snippets, urlhash, url, keywords, texts, descriptions, docTitle, images_protocol_obj, images_stub);
        }
    }

    private MultiProtocolURL writeLink(Writer writer, String sku) throws IOException {
        MultiProtocolURL url;
        OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.link.name(), sku);
        try {
            url = new MultiProtocolURL(sku);
            OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.host.getURIref(), url.getHost());
            OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.path.getURIref(), url.getPath());
            OpensearchResponseWriter.solitaireTag(writer, YaCyMetadata.file.getURIref(), url.getFileName());
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    private void writeDocEnd(Writer writer, Map<String, Collection<String>> snippets, String urlhash, MultiProtocolURL url, String keywords, List<String> texts, List<String> descriptions, String docTitle, List<Object> imagesProtocolObjs, List<String> imagesStubs) throws IOException {
        if (Math.min(imagesProtocolObjs.size(), imagesStubs.size()) > 0) {
            List<String> imagesProtocols = CollectionConfiguration.indexedList2protocolList(imagesProtocolObjs, imagesStubs.size());
            String imageurl = imagesProtocols.get(0) + "://" + imagesStubs.get(0);
            writer.write("<media:content medium=\"image\" url=\"");
            XML.escapeCharData((String)imageurl, (Writer)writer);
            writer.write("\"/>\n");
        } else if (url != null && Response.docTypeExt(MultiProtocolURL.getFileExtension(url.getFile()).toLowerCase(Locale.ROOT)) == 'i') {
            writer.write("<media:content medium=\"image\" url=\"");
            XML.escapeCharData((String)url.toNormalform(true), (Writer)writer);
            writer.write("\"/>\n");
        }
        OpensearchResponseWriter.solitaireTag(writer, RSSMessage.Token.title.name(), docTitle.length() == 0 ? (texts.size() == 0 ? "" : texts.get(0)) : docTitle);
        Collection<String> snippet = urlhash == null ? null : snippets.get(urlhash);
        String tagname = RSSMessage.Token.description.name();
        if (snippet == null || snippet.size() == 0) {
            writer.write("<");
            writer.write(tagname);
            writer.write(62);
            for (String d : descriptions) {
                XML.escapeCharData((String)d, (Writer)writer);
            }
            writer.write("</");
            writer.write(tagname);
            writer.write(">\n");
        } else {
            OpensearchResponseWriter.removeSubsumedTitle(snippet, docTitle);
            OpensearchResponseWriter.solitaireTag(writer, tagname, OpensearchResponseWriter.getLargestSnippet(snippet));
        }
        if (keywords != null) {
            OpensearchResponseWriter.solitaireTag(writer, DublinCore.Subject.getURIref(), keywords);
        }
        OpensearchResponseWriter.closeTag(writer, "item");
    }

    public static Map<String, Collection<String>> snippetsFromHighlighting(NamedList<?> sorlHighlighting) {
        HashMap<String, Collection<String>> snippets = new HashMap<String, Collection<String>>();
        if (sorlHighlighting == null) {
            return snippets;
        }
        for (Map.Entry highlightingEntry : sorlHighlighting) {
            String urlHash = (String)highlightingEntry.getKey();
            Object highlights = highlightingEntry.getValue();
            if (!(highlights instanceof SimpleOrderedMap)) continue;
            LinkedHashSet urlSnippets = new LinkedHashSet();
            for (Map.Entry entry2 : (SimpleOrderedMap)highlights) {
                Object texts = entry2.getValue();
                if (!(texts instanceof String[])) continue;
                Collections.addAll(urlSnippets, (String[])texts);
            }
            snippets.put(urlHash, urlSnippets);
        }
        return snippets;
    }

    public static void removeSubsumedTitle(Collection<String> snippets, String title) {
        if (title == null || title.length() == 0 || snippets == null || snippets.size() == 0) {
            return;
        }
        snippets.remove(title);
        String tlc = title.toLowerCase();
        Iterator<String> i = snippets.iterator();
        while (i.hasNext()) {
            String s = i.next().toLowerCase();
            s = keymarks.matcher(s).replaceAll("");
            if (tlc.toLowerCase().indexOf(s) < 0 && s.toLowerCase().indexOf(tlc) < 0) continue;
            i.remove();
        }
    }

    public static String getLargestSnippet(Collection<String> snippets) {
        if (snippets == null || snippets.isEmpty()) {
            return null;
        }
        String l = null;
        for (String s : snippets) {
            if (l != null && s.length() <= l.length() || s.length() <= 1 || s.indexOf(32, 1) <= 0) continue;
            l = s;
        }
        if (l != null) {
            l = l.replaceAll("\"", "'");
        }
        return l;
    }

    public static void openTag(Writer writer, String tag) throws IOException {
        writer.write(60);
        writer.write(tag);
        writer.write(">\n");
    }

    public static void closeTag(Writer writer, String tag) throws IOException {
        writer.write("</");
        writer.write(tag);
        writer.write(">\n");
    }

    public static void solitaireTag(Writer writer, String tagname, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        writer.write("<");
        writer.write(tagname);
        writer.write(62);
        XML.escapeCharData((String)value, (Writer)writer);
        writer.write("</");
        writer.write(tagname);
        writer.write(">\n");
    }

    public static void solitaireTag(Writer writer, String tagname, String value, String attr) throws IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        writer.write("<");
        writer.write(tagname);
        if (attr.charAt(0) != ' ') {
            writer.write(32);
        }
        writer.write(attr);
        writer.write(62);
        writer.write(value);
        writer.write("</");
        writer.write(tagname);
        writer.write(">\n");
    }

    private static void facetEntry(Writer writer, String modifier, String propname, String value) throws IOException {
        writer.write("<yacy:element name=\"");
        XML.escapeCharData((String)propname, (Writer)writer);
        writer.write("\" count=\"");
        XML.escapeCharData((String)value, (Writer)writer);
        writer.write("\" modifier=\"");
        writer.write(modifier);
        writer.write("%3A");
        XML.escapeCharData((String)propname, (Writer)writer);
        writer.write("\" />\n");
    }

    static {
        field2tag.put(CollectionSchema.coordinate_p.getSolrFieldName() + "_0_coordinate", Geo.Lat.getURIref());
        field2tag.put(CollectionSchema.coordinate_p.getSolrFieldName() + "_1_coordinate", Geo.Long.getURIref());
        field2tag.put(CollectionSchema.publisher_t.getSolrFieldName(), DublinCore.Publisher.getURIref());
        field2tag.put(CollectionSchema.author.getSolrFieldName(), DublinCore.Creator.getURIref());
        SOLR_FIELDS.addAll(field2tag.keySet());
        for (CollectionSchema field : extrafields) {
            SOLR_FIELDS.add(field.getSolrFieldName());
        }
        keymarks = Pattern.compile("<b>|</b>");
    }

    public static class ResHead {
        public long offset;
        public long rows;
        public long numFound;
    }
}

