/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.logic;

import net.yacy.cora.federate.solr.logic.AbstractOperations;
import net.yacy.cora.federate.solr.logic.Operations;
import net.yacy.cora.federate.solr.logic.Term;
import net.yacy.cora.federate.solr.logic.TermTools;
import org.apache.solr.common.SolrDocument;

public class Disjunction
extends AbstractOperations
implements Operations {
    public Disjunction() {
        super("OR");
    }

    public Disjunction(Term t1, Term t2) {
        super("OR");
        this.addOperand(t1);
        this.addOperand(t2);
    }

    public Object clone() {
        Disjunction c = new Disjunction();
        for (Term t : this.terms) {
            c.addOperand(t);
        }
        return c;
    }

    @Override
    public boolean equals(Object otherTerm) {
        if (!(otherTerm instanceof Disjunction)) {
            return false;
        }
        Disjunction o = (Disjunction)otherTerm;
        for (Term t : this.terms) {
            if (TermTools.isIn(t, o.getOperands())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(SolrDocument doc) {
        for (Term term : this.terms) {
            if (!term.matches(doc)) continue;
            return true;
        }
        return false;
    }
}

