/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.opensearch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.concurrent.BlockingQueue;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.feed.RSSReader;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.http.HTTPClient;
import org.apache.http.entity.mime.content.ContentBody;

public class SRURSSConnector {
    private static final int recordsPerSession = 250;

    public static Thread searchSRURSS(final BlockingQueue<RSSMessage> queue, final String urlBase, final String query2, final long timeoutInit, final int maximumRecordsInit, final CacheStrategy verify, final boolean global, final ClientIdentification.Agent agent) {
        Thread job = new Thread("searchSRURSS:" + urlBase){

            @Override
            public void run() {
                long st;
                int startRecord = 0;
                int maximumRecords = maximumRecordsInit;
                for (long timeout = timeoutInit; timeout > 0L && maximumRecords > 0; timeout -= System.currentTimeMillis() - st) {
                    RSSMessage message2;
                    RSSFeed feed2;
                    st = System.currentTimeMillis();
                    try {
                        feed2 = SRURSSConnector.loadSRURSS(urlBase, query2, startRecord, 250, verify, global, agent);
                    }
                    catch (IOException e1) {
                        break;
                    }
                    if (feed2 == null || feed2.isEmpty()) break;
                    maximumRecords -= feed2.size();
                    while (!feed2.isEmpty() && (message2 = feed2.pollMessage()) != null) {
                        try {
                            queue.put(message2);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    startRecord += 250;
                }
                try {
                    queue.put(RSSMessage.POISON);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        job.start();
        return job;
    }

    public static RSSFeed loadSRURSS(String rssSearchServiceURL, String query2, int startRecord, int maximumRecords, CacheStrategy cacheStrategy, boolean global, ClientIdentification.Agent agent) throws IOException {
        MultiProtocolURL uri = null;
        try {
            uri = new MultiProtocolURL(rssSearchServiceURL);
        }
        catch (MalformedURLException e) {
            throw new IOException("cora.Search failed asking peer '" + rssSearchServiceURL + "': bad url, " + e.getMessage());
        }
        byte[] result = new byte[]{};
        try {
            LinkedHashMap<String, ContentBody> parts = new LinkedHashMap<String, ContentBody>();
            parts.put("query", (ContentBody)UTF8.StringBody(query2));
            parts.put("startRecord", (ContentBody)UTF8.StringBody(Integer.toString(startRecord)));
            parts.put("maximumRecords", (ContentBody)UTF8.StringBody(Long.toString(maximumRecords)));
            parts.put("verify", (ContentBody)(cacheStrategy == null ? UTF8.StringBody("false") : UTF8.StringBody(cacheStrategy.toName())));
            parts.put("resource", (ContentBody)UTF8.StringBody(global ? "global" : "local"));
            parts.put("nav", (ContentBody)UTF8.StringBody("none"));
            try (HTTPClient httpClient = new HTTPClient(agent);){
                result = httpClient.POSTbytes(new MultiProtocolURL(rssSearchServiceURL), uri.getHost(), parts, false, false);
            }
            RSSReader reader = RSSReader.parse(10000, result);
            if (reader == null) {
                throw new IOException("cora.Search failed asking peer '" + uri.getHost() + "': probably bad response from remote peer (1), reader == null");
            }
            RSSFeed feed2 = reader.getFeed();
            if (feed2 == null) {
                throw new IOException("cora.Search failed asking peer '" + uri.getHost() + "': probably bad response from remote peer (2)");
            }
            return feed2;
        }
        catch (IOException e) {
            throw new IOException("cora.Search error asking peer '" + uri.getHost() + "':" + e.toString());
        }
    }
}

