/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.StringBody;

public class UTF8
implements Comparator<String> {
    private static final ContentType contentType = ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8);
    public static final UTF8 insensitiveUTF8Comparator = new UTF8(true);
    public static final UTF8 identityUTF8Comparator = new UTF8(false);
    public boolean insensitive;

    public UTF8(boolean insensitive) {
        this.insensitive = insensitive;
    }

    @Override
    public int compare(String o0, String o1) {
        int l0 = o0.length();
        int l1 = o1.length();
        int ml = Math.min(l0, l1);
        for (int i = 0; i < ml; ++i) {
            char c1;
            char c0;
            if (this.insensitive) {
                c0 = Character.toLowerCase(o0.charAt(i));
                c1 = Character.toLowerCase(o1.charAt(i));
            } else {
                c0 = o0.charAt(i);
                c1 = o1.charAt(i);
            }
            if (c0 == c1) continue;
            return c0 - c1;
        }
        return l0 - l1;
    }

    public boolean equals(String o0, String o1) {
        int l1;
        int l0 = o0.length();
        if (l0 != (l1 = o1.length())) {
            return false;
        }
        return this.equals(o0, o1, l1);
    }

    private boolean equals(String o0, String o1, int l) {
        for (int i = 0; i < l; ++i) {
            char c1;
            char c0;
            if (this.insensitive) {
                c0 = Character.toLowerCase(o0.charAt(i));
                c1 = Character.toLowerCase(o1.charAt(i));
            } else {
                c0 = o0.charAt(i);
                c1 = o1.charAt(i);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    public static final StringBody StringBody(byte[] b) {
        return UTF8.StringBody(UTF8.String(b));
    }

    public static final StringBody StringBody(String s) {
        return new StringBody(s == null ? "" : s, contentType);
    }

    public static final String String(byte[] bytes) {
        return new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
    }

    public static final String String(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static final byte[] getBytes(String s) {
        if (s == null) {
            return null;
        }
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static final byte[] getBytes(StringBuilder s) {
        if (s == null) {
            return null;
        }
        return s.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static String decodeURL(String s) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        boolean insearchpart = false;
        byte[] bytes = null;
        block7: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '?': {
                    sb.append(c);
                    ++i;
                    insearchpart = true;
                    continue block7;
                }
                case '+': {
                    if (insearchpart) {
                        sb.append(' ');
                        needToChange = true;
                    } else {
                        sb.append(c);
                    }
                    ++i;
                    continue block7;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                return s;
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            return s;
                        }
                        sb.append(new String(bytes, 0, pos, StandardCharsets.UTF_8));
                    }
                    catch (NumberFormatException e) {
                        return s;
                    }
                    needToChange = true;
                    continue block7;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String encodeUrl(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }
}

