/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;

public final class OffsetsFromTokens
implements OffsetsRetrievalStrategy {
    private final String field;
    private final Analyzer analyzer;

    public OffsetsFromTokens(String field, Analyzer analyzer) {
        this.field = field;
        this.analyzer = analyzer;
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        List<CharSequence> values = doc.getValues(this.field);
        final HashSet matchTerms = new HashSet();
        while (matchesIterator.next()) {
            Query q = matchesIterator.getQuery();
            q.visit(new QueryVisitor(){

                public void consumeTerms(Query query, Term ... terms) {
                    for (Term t : terms) {
                        if (!OffsetsFromTokens.this.field.equals(t.field())) continue;
                        matchTerms.add(t.bytes());
                    }
                }
            });
        }
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int valueOffset = 0;
        int max = values.size();
        for (int valueIndex = 0; valueIndex < max; ++valueIndex) {
            String value = values.get(valueIndex).toString();
            TokenStream ts = this.analyzer.tokenStream(this.field, value);
            OffsetAttribute offsetAttr = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
            TermToBytesRefAttribute termAttr = (TermToBytesRefAttribute)ts.getAttribute(TermToBytesRefAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                if (!matchTerms.contains(termAttr.getBytesRef())) continue;
                int startOffset = valueOffset + offsetAttr.startOffset();
                int endOffset = valueOffset + offsetAttr.endOffset();
                ranges.add(new OffsetRange(startOffset, endOffset));
            }
            ts.end();
            valueOffset += offsetAttr.endOffset() + this.analyzer.getOffsetGap(this.field);
            ts.close();
        }
        return ranges;
    }

    @Override
    public boolean requiresDocument() {
        return true;
    }
}

