/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.solr.cluster.api.Resource;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.KeeperException;

public class SimpleZkMap
implements SimpleMap<Resource> {
    private final ZkStateReader zkStateReader;
    private final String basePath;
    static final byte[] EMPTY_BYTES = new byte[0];

    public SimpleZkMap(ZkStateReader zkStateReader, String path) {
        this.zkStateReader = zkStateReader;
        this.basePath = path;
    }

    @Override
    public Resource get(String key) {
        return this.readZkNode(this.basePath + key);
    }

    @Override
    public void abortableForEach(BiFunction<String, ? super Resource, Boolean> fun) {
        try {
            this.recursiveRead("", this.zkStateReader.getZkClient().getChildren(this.basePath, null, true), fun);
        }
        catch (InterruptedException | KeeperException e) {
            SimpleZkMap.throwZkExp((Exception)e);
        }
    }

    @Override
    public void forEachEntry(BiConsumer<String, ? super Resource> fun) {
        this.abortableForEach((BiFunction<String, ? super Resource, Boolean>)((BiFunction<String, Resource, Boolean>)(path, resource) -> {
            fun.accept((String)path, (Resource)resource);
            return Boolean.TRUE;
        }));
    }

    @Override
    public int size() {
        return 0;
    }

    private Resource readZkNode(final String path) {
        return new Resource(){

            @Override
            public String name() {
                return path;
            }

            @Override
            public void get(Resource.Consumer consumer) throws SolrException {
                try {
                    byte[] data = SimpleZkMap.this.zkStateReader.getZkClient().getData(SimpleZkMap.this.basePath + "/" + path, null, null, true);
                    if (data != null && data.length > 0) {
                        consumer.read(new ByteArrayInputStream(data));
                    } else {
                        consumer.read(new ByteArrayInputStream(EMPTY_BYTES));
                    }
                }
                catch (InterruptedException | KeeperException e) {
                    SimpleZkMap.throwZkExp((Exception)e);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can;t read stream", (Throwable)e);
                }
            }
        };
    }

    private boolean recursiveRead(String parent, List<String> childrenList, BiFunction<String, ? super Resource, Boolean> fun) {
        if (childrenList == null || childrenList.isEmpty()) {
            return true;
        }
        try {
            LinkedHashMap<String, List<String>> withKids = new LinkedHashMap<String, List<String>>();
            for (String string : childrenList) {
                String relativePath;
                String string2 = relativePath = parent.isEmpty() ? string : parent + "/" + string;
                if (!fun.apply(relativePath, this.readZkNode(relativePath)).booleanValue()) {
                    return false;
                }
                List<String> l1 = this.zkStateReader.getZkClient().getChildren(this.basePath + "/" + relativePath, null, true);
                if (l1 == null || l1.isEmpty()) continue;
                withKids.put(relativePath, l1);
            }
            for (Map.Entry entry : withKids.entrySet()) {
                if (this.recursiveRead((String)entry.getKey(), (List)entry.getValue(), fun)) continue;
                return false;
            }
        }
        catch (InterruptedException | KeeperException e) {
            SimpleZkMap.throwZkExp((Exception)e);
        }
        return true;
    }

    static void throwZkExp(Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZK errror", (Throwable)e);
    }
}

