/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.api.collections.DistributedCollectionConfigSetCommandRunner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final Boolean DISABLE_CREATE_AUTH_CHECKS = Boolean.getBoolean("solr.disableConfigSetsCreateAuthChecks");
    public static final String DEFAULT_CONFIGSET_NAME = "_default";
    public static final String AUTOCREATED_CONFIGSET_SUFFIX = ".AUTOCREATED";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    private final Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionConfigSetCommandRunner;
    public static long CONFIG_SET_TIMEOUT = 300000L;

    public ConfigSetsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.distributedCollectionConfigSetCommandRunner = coreContainer != null ? coreContainer.getDistributedCollectionCommandRunner() : Optional.empty();
    }

    public static String getSuffixedNameForAutoGeneratedConfigSet(String configName) {
        return configName + AUTOCREATED_CONFIGSET_SUFFIX;
    }

    public static boolean isAutoGeneratedConfigSet(String configName) {
        return configName != null && configName.endsWith(AUTOCREATED_CONFIGSET_SUFFIX);
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ConfigSetParams.ConfigSetAction action;
        this.checkErrors();
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            if (action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                this.handleConfigUploadRequest(req, rsp);
                return;
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        this.invokeAction(req, rsp, action);
        rsp.setHttpCaching(false);
    }

    protected void checkErrors() {
        if (this.coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
    }

    void invokeAction(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetParams.ConfigSetAction action) throws Exception {
        Map<String, Object> result;
        ConfigSetOperation operation = ConfigSetOperation.get(action);
        if (log.isInfoEnabled()) {
            log.info("Invoked ConfigSet Action :{} with params {} ", (Object)action.toLower(), (Object)req.getParamString());
        }
        if ((result = operation.call(req, rsp, this)) != null) {
            if (this.distributedCollectionConfigSetCommandRunner.isPresent()) {
                this.distributedCollectionConfigSetCommandRunner.get().runConfigSetCommand(rsp, operation, result, CONFIG_SET_TIMEOUT);
            } else {
                this.sendToOverseer(rsp, operation, result);
            }
        }
    }

    protected void sendToOverseer(SolrQueryResponse rsp, ConfigSetOperation operation, Map<String, Object> result) throws KeeperException, InterruptedException {
        result.put("operation", "configsets:" + operation.action.toLower());
        ZkNodeProps props = new ZkNodeProps(result);
        this.handleResponse(operation.action.toLower(), props, rsp, CONFIG_SET_TIMEOUT);
    }

    private void handleConfigUploadRequest(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        if (!"true".equals(System.getProperty("configset.upload.enabled", "true"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Configset upload feature is disabled. To enable this, start Solr with '-Dconfigset.upload.enabled=true'.");
        }
        String configSetName = req.getParams().get("name");
        if (StringUtils.isBlank((CharSequence)configSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration name should be provided in the \"name\" parameter");
        }
        ConfigSetService configSetService = this.coreContainer.getConfigSetService();
        boolean overwritesExisting = configSetService.checkConfigExists(configSetName);
        boolean requestIsTrusted = ConfigSetsHandler.isTrusted(req, this.coreContainer.getAuthenticationPlugin());
        String singleFilePath = req.getParams().get("filePath", "");
        boolean allowOverwrite = req.getParams().getBool("overwrite", false);
        boolean cleanup = req.getParams().getBool("cleanup", false);
        Iterator<ContentStream> contentStreamsIterator = req.getContentStreams().iterator();
        if (!contentStreamsIterator.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No stream found for the config data to be uploaded");
        }
        InputStream inputStream = contentStreamsIterator.next().getStream();
        if (!singleFilePath.isEmpty()) {
            String fixedSingleFilePath = singleFilePath;
            if (fixedSingleFilePath.charAt(0) == '/') {
                fixedSingleFilePath = fixedSingleFilePath.substring(1);
            }
            if (fixedSingleFilePath.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The file path provided for upload, '" + singleFilePath + "', is not valid.");
            }
            if (cleanup) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet uploads do not allow cleanup=true when file path is used.");
            }
            this.createBaseNode(configSetService, overwritesExisting, requestIsTrusted, configSetName);
            configSetService.uploadFileToConfig(configSetName, fixedSingleFilePath, IOUtils.toByteArray((InputStream)inputStream), allowOverwrite);
            return;
        }
        if (overwritesExisting && !allowOverwrite) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration " + configSetName + " already exists in zookeeper");
        }
        List<Object> filesToDelete = overwritesExisting && cleanup ? configSetService.getAllConfigFiles(configSetName) : Collections.emptyList();
        this.createBaseNode(configSetService, overwritesExisting, requestIsTrusted, configSetName);
        try (ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);){
            ZipEntry zipEntry;
            boolean hasEntry = false;
            while ((zipEntry = zis.getNextEntry()) != null) {
                hasEntry = true;
                String filePath = zipEntry.getName();
                filesToDelete.remove(filePath);
                if (zipEntry.isDirectory()) continue;
                configSetService.uploadFileToConfig(configSetName, filePath, IOUtils.toByteArray((InputStream)zis), true);
            }
            if (!hasEntry) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either empty zipped data, or non-zipped data was uploaded. In order to upload a configSet, you must zip a non-empty directory to upload.");
            }
        }
        this.deleteUnusedFiles(configSetService, configSetName, filesToDelete);
        if (cleanup && requestIsTrusted && overwritesExisting && !ConfigSetsHandler.isCurrentlyTrusted(configSetService, configSetName)) {
            Map<String, Object> metadata = Collections.singletonMap("trusted", true);
            configSetService.setConfigMetadata(configSetName, metadata);
        }
    }

    private void createBaseNode(ConfigSetService configSetService, boolean overwritesExisting, boolean requestIsTrusted, String configName) throws IOException {
        Map<String, Object> metadata = Collections.singletonMap("trusted", requestIsTrusted);
        if (overwritesExisting) {
            if (!requestIsTrusted) {
                this.ensureOverwritingUntrustedConfigSet(configSetService, configName);
            }
        } else {
            configSetService.setConfigMetadata(configName, metadata);
        }
    }

    private void deleteUnusedFiles(ConfigSetService configSetService, String configName, List<String> filesToDelete) throws IOException {
        if (!filesToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("Cleaning up {} unused files", (Object)filesToDelete.size());
            }
            if (log.isDebugEnabled()) {
                log.debug("Cleaning up unused files: {}", filesToDelete);
            }
            configSetService.deleteFilesFromConfig(configName, filesToDelete);
        }
    }

    private void ensureOverwritingUntrustedConfigSet(ConfigSetService configSetService, String configName) throws IOException {
        boolean isCurrentlyTrusted = ConfigSetsHandler.isCurrentlyTrusted(configSetService, configName);
        if (isCurrentlyTrusted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Trying to make an untrusted ConfigSet update on a trusted configSet");
        }
    }

    private static boolean isCurrentlyTrusted(ConfigSetService configSetService, String configName) throws IOException {
        Map<String, Object> contentMap = configSetService.getConfigMetadata(configName);
        return (Boolean)contentMap.getOrDefault("trusted", true);
    }

    static boolean isTrusted(SolrQueryRequest req, AuthenticationPlugin authPlugin) {
        if (authPlugin != null && req.getUserPrincipal() != null) {
            log.debug("Trusted configset request");
            return true;
        }
        log.debug("Untrusted configset request");
        return false;
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerConfigSetQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            OverseerSolrResponse response = OverseerSolrResponseSerializer.deserialize(event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset unknown case");
        }
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        props.put("immutable", "false");
        return props;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud ConfigSets";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String a = ctx.getParams().get("action");
        if (a != null) {
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == ConfigSetParams.ConfigSetAction.CREATE || action == ConfigSetParams.ConfigSetAction.DELETE || action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
            if (action == ConfigSetParams.ConfigSetAction.LIST) {
                return PermissionNameProvider.Name.CONFIG_READ_PERM;
            }
        }
        return null;
    }

    public static enum ConfigSetOperation {
        UPLOAD_OP(ConfigSetParams.ConfigSetAction.UPLOAD){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                h.handleConfigUploadRequest(req, rsp);
                return null;
            }
        }
        ,
        CREATE_OP(ConfigSetParams.ConfigSetAction.CREATE){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                String baseConfigSetName = req.getParams().get("baseConfigSet", ConfigSetsHandler.DEFAULT_CONFIGSET_NAME);
                String newConfigSetName = req.getParams().get("name");
                if (newConfigSetName == null || newConfigSetName.length() == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
                }
                if (h.coreContainer.getConfigSetService().checkConfigExists(newConfigSetName)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet already exists: " + newConfigSetName);
                }
                if (!h.coreContainer.getConfigSetService().checkConfigExists(baseConfigSetName)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Base ConfigSet does not exist: " + baseConfigSetName);
                }
                Map<String, Object> props = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
                props.put("baseConfigSet", baseConfigSetName);
                if (!DISABLE_CREATE_AUTH_CHECKS.booleanValue() && !ConfigSetsHandler.isTrusted(req, h.coreContainer.getAuthenticationPlugin()) && ConfigSetsHandler.isCurrentlyTrusted(h.coreContainer.getConfigSetService(), baseConfigSetName)) {
                    throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Can't create a configset with an unauthenticated request from a trusted baseConfigSet");
                }
                return ConfigSetsHandler.copyPropertiesWithPrefix(req.getParams(), props, "configSetProp.");
            }
        }
        ,
        DELETE_OP(ConfigSetParams.ConfigSetAction.DELETE){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                return CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            }
        }
        ,
        LIST_OP(ConfigSetParams.ConfigSetAction.LIST){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                NamedList results = new NamedList();
                List<String> configSetsList = h.coreContainer.getConfigSetService().listConfigs();
                results.add("configSets", configSetsList);
                OverseerSolrResponse response = new OverseerSolrResponse((NamedList<Object>)results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }
        };

        ConfigSetParams.ConfigSetAction action;

        private ConfigSetOperation(ConfigSetParams.ConfigSetAction action) {
            this.action = action;
        }

        public ConfigSetParams.ConfigSetAction getAction() {
            return this.action;
        }

        public abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, ConfigSetsHandler var3) throws Exception;

        public static ConfigSetOperation get(ConfigSetParams.ConfigSetAction action) {
            for (ConfigSetOperation op : ConfigSetOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + action);
        }
    }
}

