/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ZkController zkController;
    private SolrZkServer zkServer;
    private ExecutorService coreZkRegister = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("coreZkRegister"));
    private boolean zkRunOnly = Boolean.getBoolean("zkRunOnly");
    public static volatile Predicate<CoreDescriptor> testing_beforeRegisterInZk;

    public void initZooKeeper(CoreContainer cc, CloudConfig config) {
        String zkRun = System.getProperty("zkRun");
        if (zkRun != null && config == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot start Solr in cloud mode - no cloud config provided");
        }
        if (config == null) {
            return;
        }
        String zookeeperHost = config.getZkHost();
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        String solrHome = cc.getSolrHome();
        if (zkRun != null) {
            String zkDataHome = System.getProperty("zkServerDataDir", Paths.get(solrHome, new String[0]).resolve("zoo_data").toString());
            String zkConfHome = System.getProperty("zkServerConfDir", solrHome);
            this.zkServer = new SolrZkServer(this.stripChroot(zkRun), this.stripChroot(config.getZkHost()), new File(zkDataHome), zkConfHome, config.getSolrHostPort());
            this.zkServer.parseConfig();
            this.zkServer.start();
            if (zookeeperHost == null) {
                zookeeperHost = this.zkServer.getClientString();
            }
        }
        int zkClientConnectTimeout = 30000;
        if (zookeeperHost != null) {
            try {
                boolean alreadyUsedChroot;
                if (zkRun != null && this.zkServer.getServers().size() > 1) {
                    zkClientConnectTimeout = 86400000;
                    log.info("Zookeeper client={}  Waiting for a quorum.", (Object)zookeeperHost);
                } else {
                    log.info("Zookeeper client={}", (Object)zookeeperHost);
                }
                boolean createRoot = Boolean.getBoolean("createZkChroot");
                boolean bl = alreadyUsedChroot = cc.getConfig().isFromZookeeper() && zookeeperHost.equals(cc.getConfig().getDefaultZkHost());
                if (!alreadyUsedChroot && !ZkController.checkChrootPath(zookeeperHost, this.zkRunOnly || createRoot)) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A chroot was specified in ZkHost but the znode doesn't exist. " + zookeeperHost);
                }
                Supplier<List<CoreDescriptor>> descriptorsSupplier = () -> cc.getCores().stream().map(SolrCore::getCoreDescriptor).collect(Collectors.toList());
                ZkController zkController = new ZkController(cc, zookeeperHost, zkClientConnectTimeout, config, descriptorsSupplier);
                if (zkRun != null && StringUtils.isNotEmpty((CharSequence)System.getProperty("solr.jetty.https.port"))) {
                    new ClusterProperties(zkController.getZkClient()).setClusterProperty("urlScheme", (Object)"https");
                }
                this.zkController = zkController;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("Could not connect to ZooKeeper", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException | KeeperException e) {
                log.error("", e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
        }
    }

    private String stripChroot(String zkRun) {
        if (zkRun == null || zkRun.trim().length() == 0 || zkRun.lastIndexOf(47) < 0) {
            return zkRun;
        }
        return zkRun.substring(0, zkRun.lastIndexOf(47));
    }

    public void registerInZk(SolrCore core, boolean background, boolean skipRecovery) {
        if (this.zkController == null) {
            return;
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        Runnable r = () -> {
            MDCLoggingContext.setCore(core);
            try {
                try {
                    if (testing_beforeRegisterInZk != null) {
                        boolean didTrigger = testing_beforeRegisterInZk.test(cd);
                        if (log.isDebugEnabled()) {
                            log.debug("{} pre-zk hook", (Object)(didTrigger ? "Ran" : "Skipped"));
                        }
                    }
                    if (!core.getCoreContainer().isShutDown()) {
                        this.zkController.register(core.getName(), cd, skipRecovery);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
                catch (AlreadyClosedException e) {
                }
                catch (Exception e) {
                    try {
                        this.zkController.publish(cd, Replica.State.DOWN);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e1);
                    }
                    catch (Exception e1) {
                        log.error("", (Throwable)e1);
                    }
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
            }
            finally {
                MDCLoggingContext.clear();
            }
        };
        if (background) {
            this.coreZkRegister.execute(r);
        } else {
            r.run();
        }
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public void close() {
        try {
            if (this.zkController != null) {
                this.zkController.close();
            }
        }
        finally {
            try {
                if (this.zkServer != null) {
                    this.zkServer.stop();
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreZkRegister);
            }
        }
    }

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.coreZkRegister;
    }
}

