/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene87;

import java.io.IOException;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.compress.LZ4;

public final class LZ4WithPresetDictCompressionMode
extends CompressionMode {
    private static final int NUM_SUB_BLOCKS = 10;
    private static final int DICT_SIZE_FACTOR = 2;

    public Compressor newCompressor() {
        return new LZ4WithPresetDictCompressor();
    }

    public Decompressor newDecompressor() {
        return new LZ4WithPresetDictDecompressor();
    }

    public String toString() {
        return "BEST_SPEED";
    }

    private static class LZ4WithPresetDictCompressor
    extends Compressor {
        final ByteBuffersDataOutput compressed = ByteBuffersDataOutput.newResettableInstance();
        final LZ4.FastCompressionHashTable hashTable = new LZ4.FastCompressionHashTable();
        byte[] buffer = BytesRef.EMPTY_BYTES;

        LZ4WithPresetDictCompressor() {
        }

        private void doCompress(byte[] bytes, int dictLen, int len, DataOutput out) throws IOException {
            long prevCompressedSize = this.compressed.size();
            LZ4.compressWithDictionary((byte[])bytes, (int)0, (int)dictLen, (int)len, (DataOutput)this.compressed, (LZ4.HashTable)this.hashTable);
            out.writeVInt(Math.toIntExact(this.compressed.size() - prevCompressedSize));
        }

        public void compress(byte[] bytes, int off, int len, DataOutput out) throws IOException {
            int dictLength = len / 20;
            int blockLength = (len - dictLength + 10 - 1) / 10;
            this.buffer = ArrayUtil.grow((byte[])this.buffer, (int)(dictLength + blockLength));
            out.writeVInt(dictLength);
            out.writeVInt(blockLength);
            int end = off + len;
            this.compressed.reset();
            System.arraycopy(bytes, off, this.buffer, 0, dictLength);
            this.doCompress(this.buffer, 0, dictLength, out);
            for (int start = off + dictLength; start < end; start += blockLength) {
                int l = Math.min(blockLength, off + len - start);
                System.arraycopy(bytes, start, this.buffer, dictLength, l);
                this.doCompress(this.buffer, dictLength, l, out);
            }
            this.compressed.copyTo(out);
        }

        public void close() throws IOException {
        }
    }

    private static final class LZ4WithPresetDictDecompressor
    extends Decompressor {
        private int[] compressedLengths = new int[0];
        private byte[] buffer = new byte[0];

        LZ4WithPresetDictDecompressor() {
        }

        private int readCompressedLengths(DataInput in, int originalLength, int dictLength, int blockLength) throws IOException {
            in.readVInt();
            int i = 0;
            for (int totalLength = dictLength; totalLength < originalLength; totalLength += blockLength) {
                this.compressedLengths = ArrayUtil.grow((int[])this.compressedLengths, (int)(i + 1));
                this.compressedLengths[i++] = in.readVInt();
            }
            return i;
        }

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            assert (offset + length <= originalLength);
            if (length == 0) {
                bytes.length = 0;
                return;
            }
            int dictLength = in.readVInt();
            int blockLength = in.readVInt();
            int numBlocks = this.readCompressedLengths(in, originalLength, dictLength, blockLength);
            this.buffer = ArrayUtil.grow((byte[])this.buffer, (int)(dictLength + blockLength));
            bytes.length = 0;
            if (LZ4.decompress((DataInput)EndiannessReverserUtil.wrapDataInput(in), (int)dictLength, (byte[])this.buffer, (int)0) != dictLength) {
                throw new CorruptIndexException("Illegal dict length", in);
            }
            int offsetInBlock = dictLength;
            int offsetInBytesRef = offset;
            if (offset >= dictLength) {
                offsetInBytesRef -= dictLength;
                int numBytesToSkip = 0;
                for (int i = 0; i < numBlocks && offsetInBlock + blockLength < offset; ++i) {
                    int compressedBlockLength = this.compressedLengths[i];
                    numBytesToSkip += compressedBlockLength;
                    offsetInBlock += blockLength;
                    offsetInBytesRef -= blockLength;
                }
                in.skipBytes((long)numBytesToSkip);
            } else {
                bytes.bytes = ArrayUtil.grow((byte[])bytes.bytes, (int)dictLength);
                System.arraycopy(this.buffer, 0, bytes.bytes, 0, dictLength);
                bytes.length = dictLength;
            }
            while (offsetInBlock < offset + length) {
                int bytesToDecompress = Math.min(blockLength, offset + length - offsetInBlock);
                LZ4.decompress((DataInput)EndiannessReverserUtil.wrapDataInput(in), (int)bytesToDecompress, (byte[])this.buffer, (int)dictLength);
                bytes.bytes = ArrayUtil.grow((byte[])bytes.bytes, (int)(bytes.length + bytesToDecompress));
                System.arraycopy(this.buffer, dictLength, bytes.bytes, bytes.length, bytesToDecompress);
                bytes.length += bytesToDecompress;
                offsetInBlock += blockLength;
            }
            bytes.offset = offsetInBytesRef;
            bytes.length = length;
            assert (bytes.isValid());
        }

        public Decompressor clone() {
            return new LZ4WithPresetDictDecompressor();
        }
    }
}

