/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacAudioHeader;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.Utils;

public class FlacInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");

    public FlacAudioHeader read(RandomAccessFile raf) throws CannotReadException, IOException {
        FlacStreamReader flacStream = new FlacStreamReader(raf);
        flacStream.findStream();
        MetadataBlockDataStreamInfo mbdsi = null;
        boolean isLastBlock = false;
        while (!isLastBlock) {
            MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
            if (mbh.getBlockType() == BlockType.STREAMINFO) {
                mbdsi = new MetadataBlockDataStreamInfo(mbh, raf);
                if (!mbdsi.isValid()) {
                    throw new CannotReadException("FLAC StreamInfo not valid");
                }
            } else {
                raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
            }
            isLastBlock = mbh.isLastBlock();
        }
        long streamStart = raf.getFilePointer();
        if (mbdsi == null) {
            throw new CannotReadException("Unable to find Flac StreamInfo");
        }
        FlacAudioHeader info = new FlacAudioHeader();
        info.setNoOfSamples(mbdsi.getNoOfSamples());
        info.setPreciseLength(mbdsi.getPreciseLength());
        info.setChannelNumber(mbdsi.getNoOfChannels());
        info.setSamplingRate(mbdsi.getSamplingRate());
        info.setBitsPerSample(mbdsi.getBitsPerSample());
        info.setEncodingType(mbdsi.getEncodingType());
        info.setLossless(true);
        info.setMd5(mbdsi.getMD5Signature());
        info.setAudioDataLength(raf.length() - streamStart);
        info.setAudioDataStartPosition(streamStart);
        info.setAudioDataEndPosition(raf.length());
        info.setBitRate(this.computeBitrate(info.getAudioDataLength(), mbdsi.getPreciseLength()));
        return info;
    }

    private int computeBitrate(long size, float length) {
        return (int)((float)(size / (long)Utils.KILOBYTE_MULTIPLIER * (long)Utils.BITS_IN_BYTE_MULTIPLIER) / length);
    }

    public int countMetaBlocks(File f) throws CannotReadException, IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        FlacStreamReader flacStream = new FlacStreamReader(raf);
        flacStream.findStream();
        boolean isLastBlock = false;
        int count = 0;
        while (!isLastBlock) {
            MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
            logger.config("Found block:" + (Object)((Object)mbh.getBlockType()));
            raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
            isLastBlock = mbh.isLastBlock();
            ++count;
        }
        raf.close();
        return count;
    }
}

