/*
 * Decompiled with CFR 0.152.
 */
package org.openzim;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.openzim.ZIMFile;
import org.openzim.ZIMReader;

public class ZIMTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java ZIMTest <ZIM_FILE>");
            System.exit(0);
        }
        try {
            ZIMFile file = new ZIMFile(args[0]);
            ZIMReader zReader = new ZIMReader(file);
            int c = Math.min(10, file.header_entryCount);
            for (int i = 0; i < c; ++i) {
                System.out.println("URL by URL   " + i + ": " + zReader.getURLByURLOrder(i));
                System.out.println("URL by Title " + i + ": " + zReader.getURLByTitleOrder(i));
                ZIMReader.DirectoryEntry entry2 = zReader.getDirectoryInfo(i);
                System.out.println("URL   by Pos " + i + ": " + entry2.url);
                System.out.println("Title by Pos " + i + ": " + entry2.title);
                System.out.println("Namespace by Pos " + i + ": " + entry2.namespace);
            }
            ZIMReader.DirectoryEntry directory_entry = zReader.getDirectoryInfo(c - 1);
            byte[] articleBytes = zReader.getArticleData(directory_entry);
            String article = articleBytes == null ? "NULL" : new String(articleBytes, StandardCharsets.UTF_8);
            System.out.println(article);
            ZIMReader.ClusterIterator i = zReader.new ZIMReader.ClusterIterator();
            int count = 0;
            while (i.hasNext()) {
                ZIMReader.ArticleBlobEntry entry3 = (ZIMReader.ArticleBlobEntry)i.next();
                System.out.println(entry3.article.url);
                ++count;
            }
            System.out.println("Number of articles extracted: " + count);
            System.out.println("Number of articles expected:  " + file.header_entryCount);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

