/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class TriangulationGridOverlayPlotter
extends RasterPlotter {
    private final int centerX;
    private final int centerY;

    public TriangulationGridOverlayPlotter(int width, int height) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 24L);
        this.centerX = width / 2;
        this.centerY = height / 2;
    }

    public void renderFrame(int frame) {
        this.clear();
        this.drawBaseMap();
        this.drawTriangulation(frame);
        this.drawCrosshair(frame);
        this.drawReadouts(frame);
    }

    private void drawBaseMap() {
        this.setColor(6178L);
        for (int y = 0; y < this.getHeight(); y += 8) {
            this.line(0, y, this.getWidth(), y, 12);
        }
        for (int x = 0; x < this.getWidth(); x += 10) {
            this.line(x, 0, x, this.getHeight(), 12);
        }
        this.setColor(10808L);
        for (int i = -6; i <= 6; ++i) {
            this.line(this.centerX + i * 40, 0, this.centerX + i * 40, this.getHeight(), 18);
            this.line(0, this.centerY + i * 40, this.getWidth(), this.centerY + i * 40, 18);
        }
    }

    private void drawTriangulation(int frame) {
        int i;
        int sectors = 6;
        int radius = Math.min(this.getWidth(), this.getHeight()) / 2 - 40;
        double baseAngle = (double)frame * 6.0;
        for (i = 0; i < 6; ++i) {
            double angle = baseAngle + (double)i * 60.0;
            int x = this.centerX + (int)(Math.cos(Math.toRadians(angle)) * (double)radius);
            int y = this.centerY - (int)(Math.sin(Math.toRadians(angle)) * (double)radius);
            this.setColor(65450L);
            this.line(this.centerX, this.centerY, x, y, 50);
            this.setColor(26367L);
            this.arcLine(this.centerX, this.centerY, radius - 20, radius, angle + 6.0, true, null, null, -1, -1, -1, false);
        }
        this.setColor(17578L);
        for (i = 0; i < 6; ++i) {
            double angle1 = baseAngle + (double)i * 60.0;
            double angle2 = baseAngle + (double)(i + 1) * 60.0;
            int x1 = this.centerX + (int)(Math.cos(Math.toRadians(angle1)) * (double)radius / 1.2);
            int y1 = this.centerY - (int)(Math.sin(Math.toRadians(angle1)) * (double)radius / 1.2);
            int x2 = this.centerX + (int)(Math.cos(Math.toRadians(angle2)) * (double)radius / 1.2);
            int y2 = this.centerY - (int)(Math.sin(Math.toRadians(angle2)) * (double)radius / 1.2);
            int[] xs = new int[]{this.centerX, x1, x2};
            int[] ys = new int[]{this.centerY, y1, y2};
            this.fillPolygon(xs, ys, 7731L, 25);
            this.setColor(26367L);
            this.line(this.centerX, this.centerY, x1, y1, 35);
            this.line(this.centerX, this.centerY, x2, y2, 35);
            this.line(x1, y1, x2, y2, 20);
        }
    }

    private void drawCrosshair(int frame) {
        int pulse = (int)(10.0 + 5.0 * Math.sin(Math.toRadians(frame * 15)));
        this.setColor(65535L);
        this.line(this.centerX - 80, this.centerY, this.centerX + 80, this.centerY, 50);
        this.line(this.centerX, this.centerY - 80, this.centerX, this.centerY + 80, 50);
        this.dot(this.centerX, this.centerY, pulse, false, 40);
        this.dot(this.centerX, this.centerY, 4, true, 90);
    }

    private void drawReadouts(int frame) {
        int left = 20;
        int top = 20;
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 20, 20, 0, "TRIANGULATION", -1, 80);
        this.setColor(65450L);
        PrintTool.print5(this, 20, 32, 0, String.format("Bearing:%03d", frame * 6 % 360), -1, 70);
        PrintTool.print5(this, 20, 44, 0, String.format("Phase:%02d", frame % 8), -1, 60);
        this.setColor(48127L);
        PrintTool.print5(this, this.getWidth() - 6, this.getHeight() - 10, 0, "COORD" + frame % 5, 1, 60);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        TriangulationGridOverlayPlotter plotter = new TriangulationGridOverlayPlotter(480, 360);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame(frame);
            File out = new File(dir, String.format("triangulation_overlay_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save triangulation frame", e);
            }
        }
    }
}

