/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.yacy.visualization.RasterPlotter;

public class SubsystemStatusMosaicPlotter
extends RasterPlotter {
    private final int columns;
    private final int rows;
    private final double[][] phases;
    private final Random random;

    public SubsystemStatusMosaicPlotter(int width, int height, int columns, int rows) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 21L);
        this.columns = columns;
        this.rows = rows;
        this.phases = new double[rows][columns];
        this.random = new Random(449753100L);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                this.phases[r][c] = this.random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    public void renderFrame(int frame) {
        this.clear();
        this.drawBackground();
        int cellWidth = this.getWidth() / this.columns;
        int cellHeight = this.getHeight() / this.rows;
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.drawCell(r, c, frame, c * cellWidth, r * cellHeight, cellWidth, cellHeight);
            }
        }
    }

    private void drawBackground() {
        this.setColor(4128L);
        for (int y = 0; y < this.getHeight(); y += 6) {
            this.line(0, y, this.getWidth(), y, 12);
        }
    }

    private void drawCell(int row, int col, int frame, int x, int y, int width, int height) {
        double phase = this.phases[row][col] + (double)frame * 0.2 + (double)col * 0.1;
        long color = this.colorForCell(row, col);
        this.setColor(SubsystemStatusMosaicPlotter.darken(color, 0.5));
        for (int yy = y + 2; yy < y + height - 2; ++yy) {
            this.line(x + 2, yy, x + width - 2, yy, 25);
        }
        this.setColor(color);
        this.line(x + 2, y + 2, x + width - 2, y + 2, 70);
        this.line(x + 2, y + height - 2, x + width - 2, y + height - 2, 40);
        this.line(x + 2, y + 2, x + 2, y + height - 2, 40);
        this.line(x + width - 2, y + 2, x + width - 2, y + height - 2, 40);
        int inset = 6;
        switch ((row + col) % 4) {
            case 0: {
                this.drawSpinner(x + 6, y + 6, width - 12, height - 12, phase);
                break;
            }
            case 1: {
                this.drawHistogram(x + 6, y + 6, width - 12, height - 12, phase);
                break;
            }
            case 2: {
                this.drawWaveform(x + 6, y + 6, width - 12, height - 12, phase);
                break;
            }
            default: {
                this.drawPulseDot(x + 6, y + 6, width - 12, height - 12, phase);
            }
        }
    }

    private void drawSpinner(int x, int y, int width, int height, double phase) {
        int cx = x + width / 2;
        int cy = y + height / 2;
        int radius = Math.min(width, height) / 2 - 2;
        this.setColor(65450L);
        for (int spoke = 0; spoke < 4; ++spoke) {
            double angle = phase * 40.0 + (double)(spoke * 90);
            int sx = cx + (int)(Math.cos(Math.toRadians(angle)) * (double)radius);
            int sy = cy - (int)(Math.sin(Math.toRadians(angle)) * (double)radius);
            this.line(cx, cy, sx, sy, 70 - spoke * 5);
        }
    }

    private void drawHistogram(int x, int y, int width, int height, double phase) {
        int bars = Math.max(3, width / 6);
        for (int b = 0; b < bars; ++b) {
            double value = 0.5 + Math.sin(phase + (double)b * 0.6) * 0.45;
            int barHeight = (int)(value * (double)height);
            int left = x + b * (width / bars);
            this.setColor(0x66FFEEL);
            for (int yy = y + height - barHeight; yy < y + height; yy += 2) {
                this.line(left + 1, yy, left + width / bars - 2, yy, 60);
            }
        }
    }

    private void drawWaveform(int x, int y, int width, int height, double phase) {
        this.setColor(0xFF66CCL);
        int prevX = x;
        int prevY = y + height / 2;
        for (int i = 0; i <= width; ++i) {
            double t = (double)i / (double)width;
            int yy = y + height / 2 - (int)(Math.sin(phase * 3.0 + t * Math.PI * 2.0) * (double)height / 2.2);
            this.line(prevX, prevY, x + i, yy, 70);
            prevX = x + i;
            prevY = yy;
        }
    }

    private void drawPulseDot(int x, int y, int width, int height, double phase) {
        int cx = x + width / 2;
        int cy = y + height / 2;
        int radius = (int)(Math.abs(Math.sin(phase)) * (double)Math.min(width, height) / 2.0);
        this.setColor(56831L);
        this.dot(cx, cy, radius + 1, true, 80);
        this.setColor(0x66FFAAL);
        this.dot(cx, cy, radius / 2 + 1, true, 90);
    }

    private long colorForCell(int row, int col) {
        int base = row * 37 + col * 53 & 0xFF;
        int r = 40 + (base & 0x3F);
        int g = 120 + (base >> 2 & 0x3F);
        int b = 160 + (base >> 4 & 0x3F);
        return r << 16 | g << 8 | b;
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        SubsystemStatusMosaicPlotter plotter = new SubsystemStatusMosaicPlotter(640, 360, 8, 4);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame(frame);
            File out = new File(dir, String.format("status_mosaic_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to save mosaic frame", e);
            }
        }
    }
}

