/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.yacy.visualization.RasterPlotter;

public class CircleTool {
    private static final List<int[]> CIRCLES_CACHE = new ArrayList<int[]>();
    private static final ReentrantLock CIRCLES_CACHE_LOCK = new ReentrantLock();

    public static void clearcache() {
        CIRCLES_CACHE_LOCK.lock();
        try {
            CIRCLES_CACHE.clear();
        }
        finally {
            CIRCLES_CACHE_LOCK.unlock();
        }
    }

    private static int[] getCircleCoords(short radius, List<int[]> circles) {
        ArrayList<Integer> crc;
        if (radius - 1 < circles.size()) {
            return circles.get(radius - 1);
        }
        HashSet<Integer> crds = new HashSet<Integer>();
        for (short i = (short)Math.max(0, circles.size() - 1); i < circles.size(); i = (short)(i + 1)) {
            int[] circle;
            for (int c : circle = circles.get(i)) {
                crds.add(c);
            }
        }
        short rc = radius < 200 ? (radius < 100 ? (short)100 : radius + 9) : radius;
        for (short r = (short)circles.size(); r < rc; r = (short)(r + 1)) {
            short r1 = (short)(r + 1);
            crc = new ArrayList<Integer>();
            for (int a = 0; a < 2 * r1; a = (int)((short)(a + 1))) {
                double sinh;
                short y;
                double h = 0.7853981633974483 * (double)a / (double)r1;
                double cosh = Math.cos(h);
                short x = (short)((double)r1 * cosh);
                Integer co = x << 16 | (y = (short)((double)r1 * (sinh = Math.sin(h))));
                if (!crds.contains(co)) {
                    crc.add(co);
                    crds.add(co);
                }
                if (crds.contains(co = Integer.valueOf((x = (short)(((double)r + 0.5) * cosh)) << 16 | (y = (short)(((double)r + 0.5) * sinh))))) continue;
                crc.add(co);
                crds.add(co);
            }
            int[] newCircle = new int[crc.size() - 1];
            for (int i = 0; i < crc.size() - 1; i = (int)((short)(i + 1))) {
                int coords;
                newCircle[i] = coords = ((Integer)crc.get(i)).intValue();
            }
            circles.add(newCircle);
        }
        crc = null;
        crds = null;
        return circles.get(radius - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void circle(RasterPlotter matrix, int xc, int yc, int radius, int intensity) {
        if (radius != 0) {
            int[] c;
            block8: {
                try {
                    if (CIRCLES_CACHE_LOCK.tryLock(1L, TimeUnit.SECONDS)) {
                        try {
                            c = CircleTool.getCircleCoords((short)radius, CIRCLES_CACHE);
                            break block8;
                        }
                        finally {
                            CIRCLES_CACHE_LOCK.unlock();
                        }
                    }
                    c = CircleTool.getCircleCoords((short)radius, new ArrayList<int[]>());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            short limit = (short)c.length;
            for (short i = 0; i < limit; i = (short)(i + 1)) {
                int co = c[i];
                short x = (short)(0xFFFF & co >> 16);
                short y = (short)(0xFFFF & co);
                matrix.plot(xc + x, yc - y - 1, intensity);
                matrix.plot(xc - x + 1, yc - y - 1, intensity);
                matrix.plot(xc + x, yc + y, intensity);
                matrix.plot(xc - x + 1, yc + y, intensity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void circle(RasterPlotter matrix, int xc, int yc, int radius, int fromArc, int toArc) {
        block19: {
            int from;
            int i;
            int[] c;
            block18: {
                while (fromArc > 360) {
                    fromArc -= 360;
                }
                while (fromArc < 0) {
                    fromArc += 360;
                }
                while (toArc > 360) {
                    toArc -= 360;
                }
                while (toArc < 0) {
                    toArc += 360;
                }
                if (radius == 0) break block19;
                try {
                    if (CIRCLES_CACHE_LOCK.tryLock(1L, TimeUnit.SECONDS)) {
                        try {
                            c = CircleTool.getCircleCoords((short)radius, CIRCLES_CACHE);
                            break block18;
                        }
                        finally {
                            CIRCLES_CACHE_LOCK.unlock();
                        }
                    }
                    c = CircleTool.getCircleCoords((short)radius, new ArrayList<int[]>());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            int q = c.length;
            short q2 = (short)(q * 2);
            short q3 = (short)(q * 3);
            short q4 = (short)(q * 4);
            short[] c4x = new short[q4];
            short[] c4y = new short[q4];
            for (i = 0; i < q; i = (int)((short)(i + 1))) {
                int b0 = i;
                short b1 = (short)(q - 1 - i);
                int co = c[b0];
                short a0 = (short)(0xFFFF & co >> 16);
                short a1 = (short)(0xFFFF & co);
                co = c[b1];
                short a2 = (short)(0xFFFF & co >> 16);
                short a3 = (short)(0xFFFF & co);
                c4x[i] = a0;
                c4y[i] = (short)(-a1 - 1);
                c4x[i + q] = (short)(1 - a2);
                c4y[i + q] = (short)(-a3 - 1);
                c4x[i + q2] = (short)(1 - a0);
                c4y[i + q2] = a1;
                c4x[i + q3] = a2;
                c4y[i + q3] = a3;
            }
            if (fromArc == toArc) {
                i = q4 * fromArc / 360;
                matrix.plot(xc + c4x[i], yc + c4y[i], 100);
            } else if (fromArc > toArc) {
                int i2;
                from = q4 * fromArc / 360;
                int to = q4 * toArc / 360;
                for (i2 = from; i2 < q4; ++i2) {
                    matrix.plot(xc + c4x[i2], yc + c4y[i2], 100);
                }
                for (i2 = 0; i2 < to; ++i2) {
                    matrix.plot(xc + c4x[i2], yc + c4y[i2], 100);
                }
            } else {
                from = q4 * fromArc / 360;
                int to = q4 * toArc / 360;
                for (int i3 = from; i3 < to; ++i3) {
                    matrix.plot(xc + c4x[i3], yc + c4y[i3], 100);
                }
            }
        }
    }
}

