/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.ListManager;
import net.yacy.data.Translator;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.utils.translation.ExtensionsFileFilter;
import net.yacy.utils.translation.TranslatorUtil;

public class ListNonTranslatedFiles
extends TranslatorUtil {
    private static void printResults(List<File> nonTranslatedFiles) {
        System.out.println(nonTranslatedFiles.size() + " files are not translated.");
        for (File file : nonTranslatedFiles) {
            System.out.println(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File sourceDir = ListNonTranslatedFiles.getSourceDir(args, 0);
        Path sourcePath = sourceDir.toPath();
        File translationFile = ListNonTranslatedFiles.getTranslationFile(args, 1);
        Vector<String> extensions = ListManager.string2vector(ListNonTranslatedFiles.getExtensions(args, 2));
        ExtensionsFileFilter fileFilter = new ExtensionsFileFilter(extensions);
        String excludedDir = "locale";
        ConcurrentLog.info("ListNonTranslatedFiles", "Listing non translated " + String.valueOf(extensions) + " files from " + String.valueOf(sourceDir) + " using " + String.valueOf(translationFile));
        try {
            Set<String> translatedRelativePaths = new Translator().loadTranslationsLists(translationFile).keySet();
            List<File> srcFiles = FileUtils.getFilesRecursive(sourceDir, excludedDir, fileFilter);
            ArrayList<File> nonTranslatedFiles = new ArrayList<File>();
            for (File srcFile : srcFiles) {
                Path relativeSrcFile = sourcePath.relativize(srcFile.toPath());
                if (translatedRelativePaths.contains(relativeSrcFile.toString().replace('\\', '/'))) continue;
                nonTranslatedFiles.add(srcFile);
            }
            ListNonTranslatedFiles.printResults(nonTranslatedFiles);
        }
        finally {
            ConcurrentLog.shutdown();
        }
    }
}

