/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.yacy.search.navigator.FileTypeNavigator;
import net.yacy.search.navigator.HostNavigator;
import net.yacy.search.navigator.LanguageNavigator;
import net.yacy.search.navigator.NameSpaceNavigator;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.NavigatorSortDirection;
import net.yacy.search.navigator.NavigatorSortType;
import net.yacy.search.navigator.RestrictedStringNavigator;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.navigator.TokenizedStringNavigator;
import net.yacy.search.navigator.YearNavigator;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.schema.CollectionSchema;

public class NavigatorPlugins {
    public static final String NAV_PROPS_CONFIG_SEPARATOR = ":";

    public static Map<String, String> listAvailable() {
        TreeMap<String, String> defaultnavplugins = new TreeMap<String, String>();
        defaultnavplugins.put("filetype", "Filetype");
        defaultnavplugins.put("hosts", "Domain");
        defaultnavplugins.put("language", "Language");
        defaultnavplugins.put("authors", "Authors");
        defaultnavplugins.put("collections", "Collection");
        defaultnavplugins.put("namespace", "Wiki Name Space");
        defaultnavplugins.put("year", "Year");
        defaultnavplugins.put("keywords", "Keywords");
        return defaultnavplugins;
    }

    public static final String getNavName(String navConfig) {
        int navConfigPopsIndex;
        String name = navConfig;
        if (navConfig != null && (navConfigPopsIndex = navConfig.indexOf(NAV_PROPS_CONFIG_SEPARATOR)) >= 0) {
            name = navConfig.substring(0, navConfigPopsIndex);
        }
        return name;
    }

    public static final NavigatorSort getDefaultSort(String navName) {
        if ("year".equals(navName)) {
            return NavigatorSort.LABEL_DESC;
        }
        return NavigatorSort.COUNT_DESC;
    }

    public static final NavigatorSort parseNavSortConfig(String navConfig) {
        return NavigatorPlugins.parseNavSortConfig(navConfig, NavigatorPlugins.getDefaultSort(NavigatorPlugins.getNavName(navConfig)));
    }

    public static final NavigatorSort parseNavSortConfig(String navConfig, NavigatorSort defaultSort) {
        if (navConfig == null) {
            return defaultSort;
        }
        HashSet navProperties = new HashSet();
        Collections.addAll(navProperties, navConfig.split(NAV_PROPS_CONFIG_SEPARATOR));
        NavigatorSort sort = defaultSort;
        if (navProperties.contains(NavigatorSortType.LABEL.toString().toLowerCase(Locale.ROOT))) {
            sort = NavigatorSort.LABEL_ASC;
            if (navProperties.contains(NavigatorSortDirection.DESC.toString().toLowerCase(Locale.ROOT))) {
                sort = NavigatorSort.LABEL_DESC;
            }
        }
        if (navProperties.contains(NavigatorSortType.COUNT.toString().toLowerCase(Locale.ROOT))) {
            sort = NavigatorSort.COUNT_DESC;
            if (navProperties.contains(NavigatorSortDirection.ASC.toString().toLowerCase(Locale.ROOT))) {
                sort = NavigatorSort.COUNT_ASC;
            }
        }
        return sort;
    }

    public static Map<String, Navigator> initFromCfgStrings(Set<String> navConfigs) {
        LinkedHashMap<String, Navigator> navigatorPlugins = new LinkedHashMap<String, Navigator>();
        if (navConfigs == null) {
            return navigatorPlugins;
        }
        for (String navConfig : navConfigs) {
            String navName = NavigatorPlugins.getNavName(navConfig);
            if ("authors".equals(navName)) {
                navigatorPlugins.put("authors", new StringNavigator("Authors", CollectionSchema.author_sxt, NavigatorPlugins.parseNavSortConfig(navConfig)));
                continue;
            }
            if ("collections".equals(navName)) {
                RestrictedStringNavigator tmpnav = new RestrictedStringNavigator("Collection", CollectionSchema.collection_sxt, NavigatorPlugins.parseNavSortConfig(navConfig));
                tmpnav.addForbidden("dht");
                tmpnav.addForbidden("robot_autocrawlDeep");
                tmpnav.addForbidden("robot_autocrawlShallow");
                tmpnav.addForbidden("robot_proxy");
                tmpnav.addForbidden("robot_remote");
                tmpnav.addForbidden("robot_snippetLocalText");
                tmpnav.addForbidden("robot_snippetGlobalText");
                tmpnav.addForbidden("robot_snippetGreedyLearningText");
                tmpnav.addForbidden("robot_snippetLocalMedia");
                tmpnav.addForbidden("robot_snippetGlobalMedia");
                tmpnav.addForbidden("robot_packs");
                navigatorPlugins.put("collections", tmpnav);
                continue;
            }
            if ("filetype".equals(navName)) {
                navigatorPlugins.put("filetype", new FileTypeNavigator("Filetype", CollectionSchema.url_file_ext_s, NavigatorPlugins.parseNavSortConfig(navConfig)));
                continue;
            }
            if ("hosts".equals(navName)) {
                navigatorPlugins.put("hosts", new HostNavigator("Domain", CollectionSchema.host_s, NavigatorPlugins.parseNavSortConfig(navConfig)));
                continue;
            }
            if ("language".equals(navName)) {
                navigatorPlugins.put("language", new LanguageNavigator("Language", NavigatorPlugins.parseNavSortConfig(navConfig)));
                continue;
            }
            if ("namespace".equals(navName)) {
                navigatorPlugins.put("namespace", new NameSpaceNavigator("Wiki Name Space", NavigatorPlugins.parseNavSortConfig(navConfig)));
                continue;
            }
            if ("year".equals(navName)) {
                LinkedHashSet navProperties = new LinkedHashSet();
                Collections.addAll(navProperties, navConfig.split(NAV_PROPS_CONFIG_SEPARATOR));
                for (NavigatorSortType navigatorSortType : NavigatorSortType.values()) {
                    navProperties.remove(navigatorSortType.toString().toLowerCase(Locale.ROOT));
                }
                for (Enum enum_ : NavigatorSortDirection.values()) {
                    navProperties.remove(enum_.toString().toLowerCase(Locale.ROOT));
                }
                String[] navfielddef = navProperties.toArray(new String[navProperties.size()]);
                if (navfielddef.length > 1) {
                    try {
                        CollectionSchema field = CollectionSchema.valueOf(navfielddef[1]);
                        if (navfielddef.length > 2) {
                            navigatorPlugins.put(navfielddef[1], new YearNavigator(navfielddef[2], field, NavigatorPlugins.parseNavSortConfig(navConfig)));
                            continue;
                        }
                        navigatorPlugins.put(navfielddef[1], new YearNavigator("Year-" + navfielddef[1], field, NavigatorPlugins.parseNavSortConfig(navConfig)));
                    }
                    catch (IllegalArgumentException ex) {
                        SearchEvent.log.severe("wrong navigator name in config: \"" + navConfig + "\" " + ex.getMessage());
                    }
                    continue;
                }
                navigatorPlugins.put("year", new YearNavigator("Year", CollectionSchema.last_modified, NavigatorPlugins.parseNavSortConfig(navConfig)));
                continue;
            }
            if (!"keywords".equals(navName)) continue;
            navigatorPlugins.put("keywords", new TokenizedStringNavigator("Keywords", CollectionSchema.keywords, NavigatorPlugins.parseNavSortConfig(navConfig)));
        }
        return navigatorPlugins;
    }
}

