/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.index;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.workflow.AbstractBusyThread;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionConfiguration;
import org.apache.solr.common.SolrDocument;

public class ReindexSolrBusyThread
extends AbstractBusyThread {
    public static final String THREAD_NAME = "reindexSolr";
    SolrConnector esc;
    final CollectionConfiguration colcfg;
    int processed = 0;
    int docstoreindex = 0;
    Semaphore sem = new Semaphore(1);
    OrderedScoreMap<String> querylist = new OrderedScoreMap(null);
    String currentquery = null;
    int start = 0;
    int chunksize = 100;

    public ReindexSolrBusyThread(String query2) {
        super(100L, 0L);
        this.esc = Switchboard.getSwitchboard().index.fulltext().getDefaultConnector();
        this.colcfg = Switchboard.getSwitchboard().index.fulltext().getDefaultConfiguration();
        if (Switchboard.getSwitchboard().getThread(THREAD_NAME) != null) {
            this.interrupt();
        } else if (query2 != null) {
            this.querylist.set(query2, 0);
        }
        this.setName(THREAD_NAME);
        this.setPriority(1);
    }

    public void addSelectQuery(String query2) {
        if (query2 != null && !query2.isEmpty()) {
            this.querylist.set(query2, 0);
        }
    }

    public void addSelectFieldname(String field) {
        if (field != null && !field.isEmpty()) {
            this.querylist.set(field + ":[* TO *]", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean job() {
        ret = true;
        if (this.esc != null && this.colcfg != null && !this.querylist.isEmpty()) {
            if (this.sem.tryAcquire()) {
                try {
                    this.currentquery = this.querylist.keys(true).next();
                    xdocs = this.esc.getDocumentListByQuery(this.currentquery, null, this.start, this.chunksize, new String[0]);
                    if (xdocs.size() == 0) {
                        if (this.start > 0) {
                            this.esc.commit(true);
                            this.start = 0;
                        } else {
                            this.querylist.delete(this.currentquery);
                        }
                        if (this.chunksize >= 100) ** GOTO lbl42
                        this.chunksize += 10;
                    }
                    this.docstoreindex = (int)xdocs.getNumFound();
                    ConcurrentLog.info("MIGRATION-REINDEX", "reindex docs with query=" + this.currentquery + " found=" + this.docstoreindex + " start=" + this.start);
                    this.start += this.chunksize;
                    this.querylist.set(this.currentquery, this.docstoreindex);
                    for (SolrDocument doc : xdocs) {
                        pdoc = new URIMetadataNode(doc);
                        idoc = this.colcfg.toSolrInputDocument(pdoc);
                        Switchboard.getSwitchboard().index.putDocument(idoc);
                        ++this.processed;
                    }
                    if (xdocs.size() < this.docstoreindex) ** GOTO lbl42
                    this.querylist.delete(this.currentquery);
                }
                catch (IOException ex) {
                    ConcurrentLog.warn("MIGRATION-REINDEX", "remove following query from list due to error, q=" + this.currentquery);
                    this.querylist.delete(this.currentquery);
                    ConcurrentLog.logException(ex);
                }
                finally {
                    this.sem.release();
                }
            }
        } else {
            ret = false;
        }
lbl42:
        // 7 sources

        if (this.querylist.isEmpty()) {
            Switchboard.getSwitchboard().terminateThread("reindexSolr", false);
            ret = false;
        }
        return ret;
    }

    @Override
    public void terminate(boolean waitFor) {
        this.querylist.clear();
        if (this.docstoreindex > 0 && this.processed > 0) {
            this.esc.commit(true);
        }
        super.terminate(waitFor);
    }

    public int getProcessed() {
        return this.processed;
    }

    public String getCurrentQuery() {
        return this.querylist.isEmpty() ? "" : this.currentquery;
    }

    public OrderedScoreMap<String> getQueryList() {
        return this.querylist;
    }

    @Override
    public int getJobCount() {
        return this.docstoreindex;
    }

    @Override
    public void freemem() {
        if (this.chunksize > 2) {
            this.chunksize /= 2;
        }
        this.esc.commit(true);
        this.start = 0;
    }
}

