/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.Serializable;
import net.yacy.cora.order.Base64Order;

public class Bitfield
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3605122793792478052L;
    private byte[] bb;

    public Bitfield() {
        this(0);
    }

    public Bitfield(byte[] b) {
        this.bb = b == null ? new byte[0] : b;
    }

    public Bitfield(int bytelength) {
        this.bb = new byte[bytelength];
        for (int i = 0; i < bytelength; ++i) {
            this.bb[i] = 0;
        }
    }

    public Bitfield(int bytelength, String exported) {
        byte[] b = Base64Order.enhancedCoder.decode(exported);
        if (b.length == bytelength) {
            this.bb = b;
        } else {
            this.bb = new byte[bytelength];
            assert (b.length <= bytelength) : "exported = " + exported + " has bytelength = " + b.length + " > " + bytelength;
            System.arraycopy(b, 0, this.bb, 0, Math.min(b.length, bytelength));
        }
    }

    public Bitfield clone() {
        Bitfield theClone = new Bitfield(new byte[this.bb.length]);
        System.arraycopy(this.bb, 0, theClone.bb, 0, this.bb.length);
        return theClone;
    }

    public void set(int pos, boolean value) {
        assert (pos >= 0);
        int slot = pos >> 3;
        if (slot >= this.bb.length) {
            byte[] nb = new byte[slot + 1];
            System.arraycopy(this.bb, 0, nb, 0, this.bb.length);
            for (int i = this.bb.length; i < nb.length; ++i) {
                nb[i] = 0;
            }
            this.bb = nb;
        }
        this.bb[slot] = value ? (byte)(this.bb[slot] | 1 << pos % 8) : (byte)(this.bb[slot] & (0xFF ^ 1 << pos % 8));
    }

    public boolean get(int pos) {
        assert (pos >= 0);
        int slot = pos >> 3;
        if (slot >= this.bb.length) {
            return false;
        }
        return (this.bb[slot] & 1 << pos % 8) > 0;
    }

    public int length() {
        return this.bb.length << 3;
    }

    public String exportB64() {
        return Base64Order.enhancedCoder.encode(this.bb);
    }

    public byte[] bytes() {
        return this.bb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        for (int i = this.length() - 1; i >= 0; --i) {
            sb.append(this.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bitfield)) {
            return false;
        }
        Bitfield other = (Bitfield)obj;
        if (other.bb.length != this.bb.length) {
            return false;
        }
        for (int i = 0; i < this.bb.length; ++i) {
            if (this.bb[i] == other.bb[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static void main(String[] args) {
        int i;
        Bitfield test2 = new Bitfield(4);
        int l = test2.length();
        System.out.println("available: " + l);
        System.out.println("bevore:    " + test2.toString());
        for (i = 0; i < l / 2; ++i) {
            System.out.println(test2.exportB64());
            test2.set(i, true);
            System.out.println(i + ":" + test2.toString());
        }
        for (i = l / 2; i < l; ++i) {
            System.out.println(test2.exportB64());
            test2 = new Bitfield(4, test2.exportB64());
            test2.set(i, true);
            System.out.println(i + ":" + test2.toString());
        }
        System.out.println(test2.exportB64());
        for (i = l - 1; i >= 0; --i) {
            test2.set(i, false);
            System.out.println(i + ":" + test2.toString());
        }
        System.out.println("after:     " + test2.toString());
    }
}

